/*
 * @(#)FileUploadServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import java.io.IOException;
import java.io.File;

import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServlet;

import stec.iws.MultiPartForm;
import stec.iws.FileUpload;
import stec.iws.iws;
import stec.iws.Utils;

public class FileUploadServlet extends HttpServlet
{
    private static final int KB = 1024;
    private static final int DEFAULT_MAX_CONTENT_LENGTH = 1024 * KB;
    
    private static int max_content_length;
    
    public void init(ServletConfig _config) throws ServletException
    {
        super.init(_config);
            
    	String sValue = _config.getInitParameter("max_content_length");
        if(sValue == null)
        {
            max_content_length = DEFAULT_MAX_CONTENT_LENGTH;
        }
        else
        {
            try
            {
                max_content_length = Integer.parseInt(sValue);
            }
            catch(NumberFormatException ex)
            {
                max_content_length = DEFAULT_MAX_CONTENT_LENGTH; // [mjg] ignore
            }
        }
    }
    
    public void doPost(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        ServletOutputStream out = _response.getOutputStream();

        try
        {
            _response.setContentType("text/html");

            File fh = new File(iws.getBaseDirectory(), "./samples/upload");
            Hashtable ht = MultiPartForm.parse(_request, fh.getCanonicalPath(), max_content_length);
            
            String key;
            Vector v;
            Object obj;
            String sValue;
            byte[] bValue;
            FileUpload fileUpload;
            
            out.println("<html>");
            out.println("<head><title>File Upload Servlet</title></head>");
            out.println("<body>");
            out.println("<h1>File Upload Servlet</h1>");

            out.println("<table border=1>");

            out.println("<tr>");
            out.println("<th>");
            out.println("Key");
            out.println("</th>");
            out.println("<th>");
            out.println("Data");
            out.println("</th>");
            out.println("</tr>");

            Enumeration e = ht.keys();
            while(e.hasMoreElements())
            {
                out.println("<tr>");
                
                key = (String)e.nextElement();
                
                out.println("<td>");
                out.println(key);
                out.println("</td>");

                out.println("<td>");
                
                v = (Vector)ht.get(key);
                for(int i = 0; i < v.size(); i++)
                {
                    obj = v.elementAt(i);
                    if(obj instanceof FileUpload)
                    {
                        fileUpload = (FileUpload)obj;
                        sValue = fileUpload.getRemoteFilePath();
                        out.println("remote file path: [" + (((sValue = fileUpload.getRemoteFilePath()) == null) ? "" : sValue) + "]<br>");
                        out.println("local file path: [" + (((sValue = fileUpload.getLocalFilePath()) == null) ? "" : sValue) + "]<br>");
                        out.println("content type: [" + (((sValue = fileUpload.getContentType()) == null) ? "" : sValue) + "]<br>");
                        out.print("buffer: [");
                        out.write((((bValue = fileUpload.getBuffer()) == null) ? "".getBytes() : bValue));
                        out.println("]<br>");
                    }
                    else
                    {
                        out.println((String)obj + "<br>");
                    }
                }

                out.println("</td>");
                
                out.println("</tr>");
            }
            
            out.println("</table>");
            
            out.println("</body>");
            out.println("</html>");

            out.flush();
        }
        catch(Exception ex)
        {
            throw new ServletException(ex.getMessage());
        }
    }

    public String getServletInfo()
    {
        return "FileUploadServlet";
    }
}