/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import stec.iws.RequestHandler;
import stec.iws.ResponseOutputStream;
import stec.iws.Session;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class Response
implements HttpServletResponse {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    protected ResponseOutputStream responseOutputStream;
    protected PrintWriter responseWriter;
    protected static final int NONE = 0;
    protected static final int SERVLET_WRITER = 1;
    protected static final int SERVLET_OUTPUT_STREAM = 2;
    protected int whichOutputStream = 0;
    protected int iStatus;
    protected String statusMessage;
    protected boolean headersSent = false;
    protected Hashtable headers = new Hashtable();
    protected Vector cookies = new Vector();
    protected String item;
    protected RequestHandler handler;

    protected Response(RequestHandler requestHandler) {
        this.handler = requestHandler;
        this.responseOutputStream = new ResponseOutputStream(this);
    }

    private void _sendError(int n, String string) throws IOException {
        this.sendMessage(n, string);
        this.responseOutputStream._flush();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    private void clearCookie(String string) {
        this.removeCookie(string);
        Cookie cookie = Utils.extractCookie(this.handler.request.cookies, string);
        if (cookie != null && cookie.getValue().length() > 0) {
            cookie = new Cookie(string, "");
            cookie.setMaxAge(0);
            if (iws.sessionDomain != null) {
                cookie.setDomain(iws.sessionDomain);
            }
            if (iws.sessionPath != null) {
                cookie.setPath(DString.replace(iws.sessionPath, "%base_uri%", this.handler.request.base_uri));
            }
            cookie.setSecure(iws.sessionSecure);
            this.cookies.addElement(cookie);
        }
    }

    public boolean containsHeader(String string) {
        return this.headers.contains(string);
    }

    public String encodeRedirectURL(String string) {
        if (this.handler.request.session == null) {
            return string;
        }
        if (string.indexOf(this.handler.request.getRemoteHost()) == -1) {
            return string;
        }
        return Session.encodeURL(string, this.handler.request.session.id);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        if (this.handler.request.session == null) {
            return string;
        }
        if (this.handler.request.sessionSource == 2) {
            return string;
        }
        return Session.encodeURL(string, this.handler.request.session.id);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    protected void flush() throws IOException {
        if (this.responseWriter != null) {
            this.responseWriter.flush();
        }
        if (this.responseOutputStream != null) {
            this.responseOutputStream.flush();
        }
    }

    public String getCharacterEncoding() {
        String string = this.getContentType();
        return Utils.parseCharacterEncoding(string);
    }

    protected int getContentLength() {
        String string = (String)this.headers.get("Content-Length");
        if (string == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected String getContentType() {
        return (String)this.headers.get("Content-Type");
    }

    private String getErrorMessage(int n) {
        String string = this.getMessage(n);
        return this.replaceServerVariables(n, string);
    }

    private String getHeaderMessage(int n) {
        String string = this.getMessage(n);
        int n2 = string.indexOf(59);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return this.replaceServerVariables(n, string);
    }

    private String getMessage(int n) {
        Object object = iws.messages.get(String.valueOf(n));
        if (object == null && (object = iws.messages.get(String.valueOf(500))) == null) {
            object = "Server Error: " + n;
        }
        return (String)object;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.whichOutputStream == 1) {
            throw new IllegalStateException("getWriter() has been called.");
        }
        this.whichOutputStream = 2;
        return this.responseOutputStream;
    }

    private String getTextMessage(int n) {
        String string = this.getMessage(n);
        int n2 = string.indexOf(59);
        if (n2 == -1) {
            return null;
        }
        string = string.substring(n2 + 1);
        return this.replaceServerVariables(n, string);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.whichOutputStream == 2) {
            throw new IllegalStateException("getOutputStream() has been called.");
        }
        if (this.responseWriter == null) {
            this.responseWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.responseOutputStream), this.getCharacterEncoding()));
            this.whichOutputStream = 1;
        }
        return this.responseWriter;
    }

    protected void init(Socket socket) throws Exception {
        this.responseOutputStream._init(new BufferedOutputStream(socket.getOutputStream()));
    }

    protected void removeCookie(String string) {
        int n = 0;
        while (n < this.cookies.size()) {
            Cookie cookie = (Cookie)this.cookies.elementAt(n);
            if (cookie.getName().equals(string)) {
                this.cookies.removeElementAt(n);
            }
            ++n;
        }
    }

    private static final String replaceServerVariable(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        return DString.replace(string, string2, string3);
    }

    private String replaceServerVariables(int n, String string) {
        string = DString.replace(string, "%error%", String.valueOf(n));
        String string2 = this.handler.request.auth_type;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%auth_type%", string2);
        string2 = this.handler.request.auth_user;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%auth_user%", string2);
        string2 = this.handler.request.auth_password;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%auth_password%", string2);
        string2 = this.handler.request.https;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%https%", string2);
        string2 = this.handler.request.location;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%location%", string2);
        string2 = this.handler.request.instance_id;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%instance_id%", string2);
        string2 = this.handler.request.server_software;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%server_software%", string2);
        string2 = this.handler.request.remote_host;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%remote_host%", string2);
        string2 = this.handler.request.remote_addr;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%remote_addr%", string2);
        string2 = this.handler.request.server_name;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%server_name%", string2);
        string2 = this.handler.request.server_name;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%server_port%", string2);
        string2 = this.handler.request.request_method;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%request_method%", string2);
        string2 = this.handler.request.request_uri;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%request_uri%", string2);
        string2 = this.handler.request.query_string;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%query_string%", string2);
        string2 = this.handler.request.script_name;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%script_name%", string2);
        string2 = this.handler.request.server_protocol;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%server_protocol%", string2);
        string2 = this.handler.request.path_translated;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%path_translated%", string2);
        string2 = this.handler.request.local_addr;
        if (string2 == null) {
            string2 = "";
        }
        string = DString.replace(string, "%local_addr%", string2);
        return string;
    }

    protected void reset() {
        this.cookies.removeAllElements();
        this.headers.clear();
        this.headersSent = false;
        this.responseWriter = null;
        this.whichOutputStream = 0;
    }

    public void sendError(int n) throws IOException {
        this.sendMessage(n, null);
        this.responseOutputStream._flush();
    }

    public void sendError(int n, String string) throws IOException {
        this.sendMessage(n, string);
        this.responseOutputStream._flush();
    }

    protected void sendError(Throwable throwable) throws IOException {
        try {
            iws.logger.log(throwable);
        }
        catch (Exception exception) {}
        String string = throwable.toString();
        this.sendMessage(500, string);
        this.responseOutputStream._flush();
    }

    protected void sendHeaders() throws IOException {
        Object object;
        Object object2;
        if (this.handler.in_servlet_chain) {
            return;
        }
        if (this.headersSent) {
            return;
        }
        this.headersSent = true;
        this.responseOutputStream._print("HTTP/1.1 ");
        this.responseOutputStream._println(this.getHeaderMessage(this.iStatus));
        this.responseOutputStream._print("Server: ");
        this.responseOutputStream._println("Servertec-IWS/1.6");
        if (iws.keepAlive && this.handler.keepAlive) {
            object2 = this.headers.get("Connection");
            if (object2 != null && ((String)(object = (String)object2)).equalsIgnoreCase("close")) {
                this.handler.keepAlive = false;
            }
            if (this.handler.keepAlive) {
                object2 = this.headers.get("Content-Length");
                if (object2 == null) {
                    this.handler.keepAlive = false;
                } else {
                    try {
                        int n = Integer.parseInt((String)object2);
                        if (n < 0) {
                            this.handler.keepAlive = false;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.handler.keepAlive = false;
                    }
                }
            }
            if (this.handler.keepAlive) {
                this.setHeader("Connection", "Keep-Alive");
                object = new StringBuffer("timeout=");
                ((StringBuffer)object).append(iws.keepAliveTimeout);
                ((StringBuffer)object).append(", max=");
                ((StringBuffer)object).append(iws.keepAliveRequests);
                this.setHeader("Keep-Alive", ((StringBuffer)object).toString());
            } else {
                this.setHeader("Connection", "Close");
            }
        } else {
            this.setHeader("Connection", "Close");
        }
        object = this.headers.keys();
        while (object.hasMoreElements()) {
            object2 = (String)object.nextElement();
            this.responseOutputStream._print((String)object2);
            this.responseOutputStream._print(": ");
            this.responseOutputStream._println((String)this.headers.get(object2));
        }
        if (this.handler.request.session == null) {
            this.clearCookie(iws.sessionName);
            this.clearCookie("iwsServerID");
        } else if (!this.handler.request.session.isValid()) {
            this.clearCookie(iws.sessionName);
            this.clearCookie("iwsServerID");
        }
        object = this.cookies.elements();
        while (object.hasMoreElements()) {
            this.responseOutputStream._print("Set-Cookie: ");
            this.responseOutputStream._println(Utils.encodeCookie((Cookie)object.nextElement()));
        }
        this.responseOutputStream._println();
        this.responseOutputStream._flush();
    }

    private void sendMessage(int n, String string) throws IOException {
        Object object;
        if (this.handler.in_servlet_chain) {
            this.responseOutputStream.flush();
            this.handler.in_servlet_chain = false;
            this.headersSent = false;
            object = (ByteArrayOutputStream)this.responseOutputStream.getOutputStream();
            ((ByteArrayOutputStream)object).reset();
            this.responseOutputStream._init((OutputStream)object);
        }
        this.handler.keepAlive = false;
        object = new String(iws.messagesTemplate);
        String string2 = this.getErrorMessage(n);
        String string3 = string;
        int n2 = string2.indexOf(59);
        if (n2 == -1) {
            if (string == null) {
                string3 = string2;
            }
        } else {
            if (string == null) {
                string3 = string2.substring(n2 + 1);
            }
            string2 = string2.substring(0, n2);
        }
        object = DString.replace((String)object, "%error%", string2);
        object = DString.replace((String)object, "%message%", string3);
        this.setStatus(n);
        this.setContentType("text/html");
        this.setContentLength(((String)object).length());
        this.setDateHeader("Date", new Date().getTime());
        this.responseOutputStream.write(((String)object).getBytes());
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.handler.request.location = string;
        this.sendMessage(302, null);
    }

    public void setContentLength(int n) {
        this.headers.put("Content-Length", String.valueOf(n));
    }

    public void setContentType(String string) {
        this.headers.put("Content-Type", string);
    }

    public void setDateHeader(String string, long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        simpleDateFormat.setTimeZone(timeZone);
        this.headers.put(string, simpleDateFormat.format(new Date(l)));
    }

    public void setHeader(String string, String string2) {
        int n = string2.indexOf(10);
        if (n != -1) {
            char[] cArray = string2.toCharArray();
            cArray[n] = 32;
            while ((n = string2.indexOf(10, n + 1)) != -1) {
                cArray[n] = 32;
            }
            string2 = new String(cArray);
        }
        this.headers.put(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.headers.put(string, String.valueOf(n));
    }

    public void setStatus(int n) {
        this.setStatus(n, null);
    }

    public void setStatus(int n, String string) {
        this.iStatus = n;
        this.statusMessage = string;
    }
}

