/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import stec.iws.IOHandler;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.QuickSortStringArray;

public class ArchiveIOHandler
implements IOHandler {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private ZipFile zip_file;
    private ZipEntry zip_entry;
    protected String archive;
    protected String path;
    protected boolean isAbsolute;

    public ArchiveIOHandler(String string) throws IOException {
        if (Utils.isAbsolute(string)) {
            String string2 = Utils.getCanonicalPath(string);
            if (string2.startsWith(iws.basedir)) {
                string2 = string.substring(iws.basedir.length());
                this.init(iws.basedir, string2);
                return;
            }
            this.init(iws.basedir, string);
            return;
        }
        this.init(iws.basedir, string);
    }

    public ArchiveIOHandler(String string, String string2) throws IOException {
        this.init(string, string2);
    }

    public ArchiveIOHandler(IOHandler iOHandler, String string) throws IOException {
        String string2 = Utils.concatPaths(((ArchiveIOHandler)iOHandler).path, string);
        this.init(((ArchiveIOHandler)iOHandler).archive, string2);
    }

    public synchronized void destroy() {
        if (this.zip_file != null) {
            try {
                this.zip_file.close();
            }
            catch (Exception exception) {}
            this.zip_file = null;
        }
    }

    public boolean exists() {
        if (this.path.length() == 0) {
            return true;
        }
        return this.zip_entry != null;
    }

    public String getCanonicalPath() throws IOException {
        String string = Utils.getCanonicalPath(this.archive);
        if (this.zip_entry == null) {
            return Utils.concatPaths(string, this.path);
        }
        return Utils.concatPaths(string, this.zip_entry.getName());
    }

    public InputStream getInputStream() throws IOException {
        if (this.zip_entry == null) {
            throw new FileNotFoundException();
        }
        return this.zip_file.getInputStream(this.zip_entry);
    }

    public String getItem() throws IOException {
        if (this.zip_entry == null) {
            return null;
        }
        return Utils.getItem(this.getInputStream());
    }

    private void init(String string, String string2) throws IOException {
        boolean bl;
        this.archive = string;
        String string3 = string2.replace('\\', '/');
        this.isAbsolute = string3.length() == 0 ? true : string3.charAt(0) == '/';
        do {
            if (string3.length() == 0) {
                bl = false;
                continue;
            }
            if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
                bl = true;
                continue;
            }
            if (string3.startsWith("./")) {
                string3 = string3.substring(2);
                bl = true;
                continue;
            }
            if (string3.startsWith("../")) {
                string3 = string3.substring(3);
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        this.path = string3;
        File file = new File(this.archive);
        this.zip_file = new ZipFile(file);
        this.zip_entry = this.zip_file.getEntry(string3);
        if (this.zip_entry == null) {
            this.zip_entry = this.zip_file.getEntry(String.valueOf(string3) + "/");
            if (this.zip_entry != null) {
                this.path = String.valueOf(this.path) + "/";
            }
        }
    }

    public boolean isAbsolute() {
        return Utils.isAbsolute(this.path);
    }

    public boolean isDirectory() {
        if (this.path.length() == 0) {
            return true;
        }
        if (this.zip_entry == null) {
            return false;
        }
        return this.zip_entry.isDirectory();
    }

    public boolean isFile() {
        if (this.zip_entry == null) {
            return false;
        }
        return !this.zip_entry.isDirectory();
    }

    public long lastModified() {
        if (this.path.length() == 0) {
            File file = new File(this.archive);
            return file.lastModified();
        }
        if (this.zip_entry == null) {
            return -1L;
        }
        return this.zip_entry.getTime();
    }

    public long length() {
        if (this.path.length() == 0) {
            return 0L;
        }
        if (this.zip_entry == null) {
            return -1L;
        }
        return this.zip_entry.getSize();
    }

    public String[] list() {
        Vector<String> vector = new Vector<String>();
        String string = this.path.toLowerCase();
        Enumeration<? extends ZipEntry> enumeration = this.zip_file.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            String string3 = string2.toLowerCase();
            if (!string3.startsWith(string) || string3.length() <= string.length()) continue;
            int n = (string2 = string2.substring(string.length())).indexOf(47);
            if (n == -1) {
                vector.addElement(string2);
                continue;
            }
            if (n != string2.length() - 1) continue;
            vector.addElement(string2.substring(0, n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (objectArray.length > 0) {
            QuickSortStringArray quickSortStringArray = new QuickSortStringArray();
            objectArray = quickSortStringArray.sort((String[])objectArray);
        }
        return objectArray;
    }
}

