/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminWorkGroup {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayWorkGroup(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("workgroup");
        AdminUtils.displayList(adminContext);
    }

    protected static void displayWorkGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("workgroup_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("server_address");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%server_address%", (String)object);
        object = hashtable.get("port");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%port%", (String)object);
        object = hashtable.get("username");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%username%", (String)object);
        object = hashtable.get("password");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%password%", (String)object);
        string = DString.replace(string, "%vpassword%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void doWorkGroup(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("workgroup");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminWorkGroup.displayWorkGroupEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminWorkGroup.parseWorkGroupEntry(adminContext);
                AdminWorkGroup.displayWorkGroupEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static void doWorkGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("workgroup_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminWorkGroup.verifyWorkGroupEntry(adminContext)) {
                AdminWorkGroup.updateWorkGroupEntry(adminContext);
                adminContext.setForm("workgroup");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "workgroup", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminWorkGroup.verifyWorkGroupEntry(adminContext)) {
                    AdminWorkGroup.updateWorkGroupEntry(adminContext);
                    adminContext.setForm("workgroup");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("workgroup");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminWorkGroup.displayWorkGroupEntry(adminContext);
    }

    protected static Hashtable getWorkGroupEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        string = Utils.decodeURL(string);
        String string2 = DString.extract(string, ":", 0);
        if (string2 == null) {
            string2 = "";
        }
        hashtable.put("server_address", string2);
        string2 = DString.extract(string, ":", 1);
        if (string2 == null) {
            string2 = "";
        }
        hashtable.put("port", string2);
        String string3 = (String)hashtable.get("entry");
        string2 = DString.extract(string3, ",", 0);
        if (string2 == null) {
            string2 = "";
        }
        hashtable.put("username", string2);
        string2 = DString.extract(string3, ",", 1);
        if (string2 == null) {
            string2 = "";
        }
        hashtable.put("password", string2);
        return hashtable;
    }

    protected static void parseWorkGroupEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminWorkGroup.getWorkGroupEntry(adminContext, hashtable);
    }

    protected static void updateWorkGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("server_address");
        string = (string = String.valueOf(string) + ":" + (String)hashtable.get("port")) == null ? null : URLEncoder.encode(string);
        Object object = hashtable.get("username");
        if (object == null) {
            object = "";
        }
        String string2 = (String)object;
        object = hashtable.get("password");
        if (object == null) {
            object = "";
        }
        string2 = String.valueOf(string2) + "," + (String)object;
        hashtable = AdminUtils.getSessionData(adminContext, "workgroup");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "workgroup", hashtable);
    }

    protected static boolean verifyWorkGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        String string2;
        String string3;
        Hashtable hashtable;
        Hashtable hashtable2;
        block32: {
            hashtable2 = AdminWorkGroup.getWorkGroupEntry(adminContext, AdminUtils.getFormData(adminContext, "workgroup"));
            adminContext.error_message.setLength(0);
            hashtable = adminContext.data;
            string3 = "";
            string2 = adminContext.request.getParameter("key");
            if (string2 != null) {
                string3 = string2;
                hashtable.put("key", string3);
            }
            string = "";
            string2 = adminContext.request.getParameter("port");
            if (string2 == null) {
                adminContext.error_message.append("Port is required.<br>");
                string2 = hashtable2.get("port");
                if (string2 != null) {
                    hashtable.put("port", string2);
                }
            } else {
                try {
                    int n = Integer.parseInt(string2);
                    if (n < 1 || n > 65536) {
                        adminContext.error_message.append("Port is not valid.<br>");
                        string2 = hashtable2.get("port");
                        if (string2 != null) {
                            hashtable.put("port", string2);
                        }
                    } else {
                        string = string2;
                        hashtable.put("port", string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    adminContext.error_message.append("Port requires a numeric value.<br>");
                    string2 = hashtable2.get("port");
                    if (string2 == null) break block32;
                    hashtable.put("port", string2);
                }
            }
        }
        if ((string2 = adminContext.request.getParameter("server_address")) == null) {
            adminContext.error_message.append("Server Address is required.<br>");
            string2 = hashtable2.get("server_address");
            if (string2 != null) {
                hashtable.put("server_address", string2);
            }
        } else {
            String string4 = DString.trim(string2);
            if (string4.length() == 0) {
                adminContext.error_message.append("Server Address is required.<br>");
                string2 = hashtable2.get("server_address");
                if (string2 != null) {
                    hashtable.put("server_address", string2);
                }
            } else {
                String string5 = String.valueOf(string4) + ":" + string;
                String string6 = string5 = string5 == null ? null : URLEncoder.encode(string5);
                if (string3.equals(string5)) {
                    hashtable.put("server_address", string4);
                } else if (AdminUtils.getFormEntry(adminContext, "workgroup", string5) != null) {
                    adminContext.error_message.append("Server already exists.<br>");
                    string2 = hashtable2.get("server_address");
                    if (string2 != null) {
                        hashtable.put("server_address", string2);
                    }
                } else {
                    hashtable.put("server_address", string4);
                }
            }
        }
        if ((string2 = adminContext.request.getParameter("username")) == null) {
            string2 = "";
        }
        hashtable.put("username", string2);
        String string7 = null;
        string2 = adminContext.request.getParameter("password");
        if (string2 != null) {
            string7 = string2;
        }
        string2 = adminContext.request.getParameter("vpassword");
        if (string7 == null && string2 == null) {
            adminContext.error_message.append("Password is required.<br>");
        } else if (string7 == null || string2 == null) {
            adminContext.error_message.append("Password mismatch.<br>");
        } else {
            String string8 = string2;
            if (string7.length() == 0 && string8.length() == 0) {
                adminContext.error_message.append("Password is required.<br>");
            } else if (string7.length() == 0 || string8.length() == 0) {
                adminContext.error_message.append("Password mismatch.<br>");
            } else if (string7.equals(string8)) {
                hashtable.put("password", string7);
                hashtable.put("vpassword", string8);
            } else {
                adminContext.error_message.append("Password mismatch.<br>");
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

