/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminMimeTypes {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayMimeTypeEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("mimetype_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("extension");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%extension%", (String)object);
        object = hashtable.get("content_type");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%content_type%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayMimeTypes(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("mimetypes");
        AdminUtils.displayList(adminContext);
    }

    protected static void doMimeTypeEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("mimetype_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminMimeTypes.verifyMimeTypeEntry(adminContext)) {
                AdminMimeTypes.updateMimeTypeEntry(adminContext);
                adminContext.setForm("mimetypes");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "mimetypes", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminMimeTypes.verifyMimeTypeEntry(adminContext)) {
                    AdminMimeTypes.updateMimeTypeEntry(adminContext);
                    adminContext.setForm("mimetypes");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("mimetypes");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminMimeTypes.displayMimeTypeEntry(adminContext);
    }

    protected static void doMimeTypes(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("mimetypes");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminMimeTypes.displayMimeTypeEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminMimeTypes.parseMimeTypeEntry(adminContext);
                AdminMimeTypes.displayMimeTypeEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getMimeTypeEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("extension", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("content_type", string2);
        return hashtable;
    }

    protected static void parseMimeTypeEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminMimeTypes.getMimeTypeEntry(adminContext, hashtable);
    }

    protected static void updateMimeTypeEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("extension");
        String string2 = (String)hashtable.get("content_type");
        hashtable = AdminUtils.getSessionData(adminContext, "mimetypes");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "mimetypes", hashtable);
    }

    protected static boolean verifyMimeTypeEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminMimeTypes.getMimeTypeEntry(adminContext, AdminUtils.getFormData(adminContext, "mimetypes"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("extension")) == null) {
            adminContext.error_message.append("Extension is required.<br>");
            string3 = hashtable.get("extension");
            if (string3 != null) {
                hashtable2.put("extension", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Extension is required.<br>");
                string3 = hashtable.get("extension");
                if (string3 != null) {
                    hashtable2.put("extension", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("extension", string);
            } else if (AdminUtils.getFormEntry(adminContext, "mimetypes", string) != null) {
                adminContext.error_message.append("Mime Type already exists.<br>");
                string3 = hashtable.get("extension");
                if (string3 != null) {
                    hashtable2.put("extension", string3);
                }
            } else {
                hashtable2.put("extension", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("content_type")) == null) {
            adminContext.error_message.append("Content Type is required.<br>");
            string3 = hashtable.get("content_type");
            if (string3 != null) {
                hashtable2.put("content_type", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Content Type is required.<br>");
                string3 = hashtable.get("content_type");
                if (string3 != null) {
                    hashtable2.put("content_type", string3);
                }
            } else {
                hashtable2.put("content_type", string3);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

