/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminGroups {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("group_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("group");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%group%", (String)object);
        object = hashtable.get("users");
        if (object == null) {
            object = "";
        }
        String string2 = (String)object;
        StringBuffer stringBuffer = new StringBuffer();
        AdminContext adminContext2 = new AdminContext(adminContext.request, adminContext.response);
        adminContext2.setForm("users");
        Hashtable hashtable2 = AdminUtils.getSessionData(adminContext2, adminContext2.form);
        String[] stringArray = new String[hashtable2.size()];
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string3;
            if (string4.length() > 50) {
                string4 = string4.substring(0, 50);
            }
            int n = DString.find(string2, ",", 0, string3);
            stringBuffer.append("<option value = \"");
            stringBuffer.append(string3);
            if (n == -1) {
                stringBuffer.append("\">");
            } else {
                stringBuffer.append("\" SELECTED>");
            }
            stringBuffer.append(string4);
            stringArray = AdminUtils.insert(stringArray, stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append('\n');
            ++n;
        }
        string = DString.replace(string, "%users%", stringBuffer.toString());
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayGroups(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("groups");
        AdminUtils.displayList(adminContext);
    }

    protected static void doGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("group_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminGroups.verifyGroupEntry(adminContext)) {
                AdminGroups.updateGroupEntry(adminContext);
                adminContext.setForm("groups");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "groups", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminGroups.verifyGroupEntry(adminContext)) {
                    AdminGroups.updateGroupEntry(adminContext);
                    adminContext.setForm("groups");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("groups");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminGroups.displayGroupEntry(adminContext);
    }

    protected static void doGroups(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("groups");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminGroups.displayGroupEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminGroups.parseGroupEntry(adminContext);
                AdminGroups.displayGroupEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("change")) {
                AdminUtils.changeRealm(adminContext);
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getGroupEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("group", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("users", string2);
        return hashtable;
    }

    protected static void parseGroupEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminGroups.getGroupEntry(adminContext, hashtable);
    }

    protected static void updateGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("group");
        String string2 = (String)hashtable.get("users");
        hashtable = AdminUtils.getSessionData(adminContext, "groups");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "groups", hashtable);
    }

    protected static boolean verifyGroupEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminGroups.getGroupEntry(adminContext, AdminUtils.getFormData(adminContext, "groups"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        Object object = adminContext.request.getParameter("key");
        if (object != null) {
            string2 = object;
            hashtable2.put("key", string2);
        }
        if ((object = adminContext.request.getParameter("group")) == null) {
            adminContext.error_message.append("Group is required.<br>");
            object = hashtable.get("group");
            if (object != null) {
                hashtable2.put("group", object);
            }
        } else {
            string = DString.trim((String)object);
            if (string.length() == 0) {
                adminContext.error_message.append("Group is required.<br>");
                object = hashtable.get("group");
                if (object != null) {
                    hashtable2.put("group", (String)object);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("group", string);
            } else if (AdminUtils.getFormEntry(adminContext, "groups", string) != null) {
                adminContext.error_message.append("Group already exists.<br>");
                object = hashtable.get("group");
                if (object != null) {
                    hashtable2.put("group", (String)object);
                }
            } else {
                hashtable2.put("group", string);
            }
        }
        if ((object = adminContext.request.getParameterValues("users")) == null) {
            adminContext.error_message.append("Users are required.<br>");
            object = hashtable.get("users");
            if (object != null) {
                hashtable2.put("users", (String)object);
            }
        } else {
            String[] stringArray = object;
            if (stringArray.length == 0) {
                adminContext.error_message.append("Users are required.<br>");
                object = hashtable.get("users");
                if (object != null) {
                    hashtable2.put("users", (String)object);
                }
            } else {
                string = AdminUtils.array_to_string(stringArray);
                hashtable2.put("users", string);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

