/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminAliases {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayAliasEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("alias_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("alias");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%alias%", (String)object);
        object = hashtable.get("type");
        if (object == null) {
            object = "file";
        }
        if (((String)object).equalsIgnoreCase("servlet:")) {
            string = DString.replace(string, "%type_file%", "");
            string = DString.replace(string, "%type_filter%", "");
            string = DString.replace(string, "%type_mime%", "");
            string = DString.replace(string, "%type_servlet%", "CHECKED");
        } else if (((String)object).equalsIgnoreCase("filter:")) {
            string = DString.replace(string, "%type_file%", "");
            string = DString.replace(string, "%type_filter%", "CHECKED");
            string = DString.replace(string, "%type_mime%", "");
            string = DString.replace(string, "%type_servlet%", "");
        } else if (((String)object).equalsIgnoreCase("mime:")) {
            string = DString.replace(string, "%type_file%", "");
            string = DString.replace(string, "%type_filter%", "");
            string = DString.replace(string, "%type_mime%", "CHECKED");
            string = DString.replace(string, "%type_servlet%", "");
        } else {
            string = DString.replace(string, "%type_file%", "CHECKED");
            string = DString.replace(string, "%type_filter%", "");
            string = DString.replace(string, "%type_mime%", "");
            string = DString.replace(string, "%type_servlet%", "");
        }
        object = hashtable.get("resource");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%resource%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayAliases(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("aliases");
        AdminUtils.displayList(adminContext);
    }

    protected static void doAliasEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("alias_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminAliases.verifyAliasEntry(adminContext)) {
                AdminAliases.updateAliasEntry(adminContext);
                adminContext.setForm("aliases");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "aliases", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminAliases.verifyAliasEntry(adminContext)) {
                    AdminAliases.updateAliasEntry(adminContext);
                    adminContext.setForm("aliases");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("aliases");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminAliases.displayAliasEntry(adminContext);
    }

    protected static void doAliases(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("aliases");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminAliases.displayAliasEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminAliases.parseAliasEntry(adminContext);
                AdminAliases.displayAliasEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getAliasEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("alias", string);
        String string2 = (String)hashtable.get("entry");
        if (string2.startsWith("servlet:")) {
            hashtable.put("type", "servlet:");
            hashtable.put("resource", string2.substring("servlet:".length()));
        } else if (string2.startsWith("file:")) {
            hashtable.put("type", "file:");
            hashtable.put("resource", string2.substring("file:".length()));
        } else if (string2.startsWith("mime:")) {
            hashtable.put("type", "mime:");
            hashtable.put("resource", string2.substring("mime:".length()));
        } else if (string2.startsWith("filter:")) {
            hashtable.put("type", "filter:");
            hashtable.put("resource", string2.substring("filter:".length()));
        } else {
            hashtable.put("type", "file:");
            hashtable.put("resource", string2);
        }
        return hashtable;
    }

    protected static void parseAliasEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminAliases.getAliasEntry(adminContext, hashtable);
    }

    protected static void updateAliasEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("alias");
        String string2 = String.valueOf((String)hashtable.get("type")) + (String)hashtable.get("resource");
        hashtable = AdminUtils.getSessionData(adminContext, "aliases");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "aliases", hashtable);
    }

    protected static boolean verifyAliasEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminAliases.getAliasEntry(adminContext, AdminUtils.getFormData(adminContext, "aliases"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("alias")) == null) {
            adminContext.error_message.append("Alias is required.<br>");
            string3 = hashtable.get("alias");
            if (string3 != null) {
                hashtable2.put("alias", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Alias is required.<br>");
                string3 = hashtable.get("alias");
                if (string3 != null) {
                    hashtable2.put("alias", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("alias", string);
            } else if (AdminUtils.getFormEntry(adminContext, "aliases", string) != null) {
                adminContext.error_message.append("Alias already exists.<br>");
                string3 = hashtable.get("alias");
                if (string3 != null) {
                    hashtable2.put("alias", string3);
                }
            } else {
                hashtable2.put("alias", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("type")) == null) {
            adminContext.error_message.append("Type is required.<br>");
            string3 = hashtable.get("type");
            if (string3 != null) {
                hashtable2.put("type", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Type is required.<br>");
                string3 = hashtable.get("type");
                if (string3 != null) {
                    hashtable2.put("type", string3);
                }
            } else {
                hashtable2.put("type", string3);
            }
        }
        if ((string3 = adminContext.request.getParameter("resource")) == null) {
            adminContext.error_message.append("Resource is required.<br>");
            string3 = hashtable.get("resource");
            if (string3 != null) {
                hashtable2.put("resource", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Resource is required.<br>");
                string3 = hashtable.get("resource");
                if (string3 != null) {
                    hashtable2.put("resource", string3);
                }
            } else {
                hashtable2.put("resource", string3);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

