/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.ui.PopupWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.lang.reflect.Method;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public class VolumeDisplay
extends PopupWindow
implements GainChangeListener {
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    GainControl gain;
    float level;
    Display display;
    Thread takeDown;

    public VolumeDisplay(GainControl gain, Frame parent) {
        super(parent);
        this.gain = gain;
        this.level = gain.getLevel();
        gain.addGainChangeListener(this);
        ((Component)this).setBackground(new Color(130, 130, 130));
        this.getPanel().setBackgroundTile(AtomicComponent.fetchImage("texture2.gif"));
        this.getPanel().setLayout(new FlowLayout(1, 0, 0));
        this.display = new Display();
        this.getPanel().add(this.display);
        this.border = 1;
        ((Component)this).setSize(this.getPreferredSize());
    }

    public void showAt(int x, int y) {
        Dimension size = this.getSize();
        ((Component)this).setLocation(x - size.width / 2, y - size.height);
        if (!this.isVisible()) {
            ((Component)this).setVisible(true);
        }
        this.resetTakeDown(true);
    }

    protected synchronized void resetTakeDown(boolean restart) {
        Thread killIt = null;
        boolean permission = true;
        if (this.takeDown != null) {
            killIt = this.takeDown;
            if (!restart) {
                this.takeDown = null;
            }
            if (securityPrivelege) {
                if (jmfSecurity != null) {
                    try {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    }
                    catch (Exception e2) {
                        permission = false;
                    }
                }
            } else {
                permission = false;
            }
            if (permission) {
                killIt.interrupt();
            }
        } else if (restart) {
            this.takeDown = new 1();
            this.takeDown.start();
        }
    }

    public void gainChange(GainChangeEvent e2) {
        if (this.level != e2.getLevel()) {
            this.level = e2.getLevel();
            if (this.display != null) {
                this.display.repaint();
            }
        }
    }

    public void dispose() {
        this.resetTakeDown(false);
        this.gain.removeGainChangeListener(this);
        this.removeAll();
        super.dispose();
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    private final class 1
    extends Thread {
        public void run() {
            while (VolumeDisplay.this.takeDown != null) {
                try {
                    Thread.sleep(1000L);
                    ((Component)VolumeDisplay.this).setVisible(false);
                    VolumeDisplay.this.resetTakeDown(false);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /* synthetic */ 1() {
        }
    }

    class Display
    extends Component {
        protected final int ValueMargin = 2;
        protected final int Margin = 3;
        protected final int TroughHeight = 6;
        protected final int ValueHeight = 3;

        public void paint(Graphics g2) {
            Dimension size = this.getSize();
            int troughWidth = size.width - 6;
            int troughValueWidth = troughWidth - 4;
            int value = (int)(VolumeDisplay.this.level * (float)troughValueWidth);
            if (value <= 0) {
                value = 2;
            }
            int y = size.height / 2 - 3 - 1;
            g2.setColor(this.getBackground());
            g2.draw3DRect(3, y, troughWidth, 6, false);
            g2.setColor(Color.green);
            g2.fillRect(5, y += 2, value, 3);
        }

        public Dimension getPreferredSize() {
            return new Dimension(120, 16);
        }

        Display() {
            VolumeDisplay.this = VolumeDisplay.this;
        }
    }
}

