/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import com.sun.media.ui.PopupThread;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

class GainSlider
extends Window
implements GainChangeListener,
MouseListener,
MouseMotionListener,
FocusListener {
    private GainControl gainControl;
    private Image imageGrabber;
    private Dimension dimGrabber = new Dimension();
    private Button buttonFocus;
    private boolean boolFocus = false;
    private PopupThread threadPopup;
    private Image imageBackground;

    public GainSlider(GainControl gainControl) {
        this(gainControl, new Frame());
    }

    public GainSlider(GainControl gainControl, Frame frame) {
        super(frame);
        this.gainControl = gainControl;
        try {
            this.init();
        }
        catch (Exception exception) {}
    }

    private void init() throws Exception {
        this.gainControl.addGainChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(null);
        this.imageBackground = BasicComp.fetchImage("texture3.gif");
        this.buttonFocus = new Button("Focus");
        this.buttonFocus.setBounds(-100, -100, 80, 24);
        this.add(this.buttonFocus);
        this.buttonFocus.addFocusListener(this);
        this.imageGrabber = BasicComp.fetchImage("grabber.gif");
        ((Component)this).setBackground(Color.lightGray);
        ((Component)this).setSize(80, 20);
    }

    public void setVisible(boolean boolVisible) {
        super.setVisible(boolVisible);
        if (boolVisible) {
            this.buttonFocus.requestFocus();
            if (this.threadPopup != null) {
                this.threadPopup.stopNormaly();
            }
            this.threadPopup = new PopupThread(this);
            this.threadPopup.resetCounter(3);
            this.threadPopup.start();
        } else {
            this.threadPopup.stopNormaly();
        }
    }

    public void update(Graphics g2) {
        Rectangle rectClient = this.getBounds();
        Image image = this.createImage(rectClient.width, rectClient.height);
        Graphics graphics = image != null ? image.getGraphics() : g2;
        this.paint(graphics);
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        Dimension dimSize = this.getSize();
        graphics.setColor(((Component)this).getBackground());
        graphics.draw3DRect(0, 0, dimSize.width - 1, dimSize.height - 1, true);
        graphics.draw3DRect(4, dimSize.height / 2 - 2, dimSize.width - 9, 3, false);
        if (this.dimGrabber.width < 1) {
            this.dimGrabber.width = this.imageGrabber.getWidth(this);
        }
        if (this.dimGrabber.height < 1) {
            this.dimGrabber.height = this.imageGrabber.getHeight(this);
        }
        float levelGain = this.gainControl.getLevel();
        int x = (int)(2.0f + levelGain * (float)(dimSize.width - 5 - this.dimGrabber.width));
        int y = (dimSize.height - this.dimGrabber.height) / 2;
        graphics.drawImage(this.imageGrabber, x, y, this);
    }

    /*
     * Unable to fully structure code
     */
    private void paintBackground(Graphics graphics) {
        block4: {
            block3: {
                dimSize = this.getSize();
                if (this.imageBackground != null) break block3;
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimSize.width, dimSize.height);
                break block4;
            }
            rectTile = new Rectangle(0, 0, this.imageBackground.getWidth(this), this.imageBackground.getHeight(this));
            rectClip = graphics.getClipBounds();
            ** GOTO lbl18
            {
                if (rectClip == null || rectClip.intersects(rectTile)) {
                    graphics.drawImage(this.imageBackground, rectTile.x, rectTile.y, this);
                }
                rectTile.x += rectTile.width;
                do {
                    if (rectTile.x < dimSize.width) continue block0;
                    rectTile.x = 0;
                    rectTile.y += rectTile.height;
lbl18:
                    // 2 sources

                } while (rectTile.y < dimSize.height);
            }
        }
    }

    public void gainChange(GainChangeEvent event) {
        this.repaint();
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.threadPopup.resetCounter(3);
        Point pointMouse = event.getPoint();
        this.setLevelToMouse(pointMouse);
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mouseDragged(MouseEvent event) {
        this.threadPopup.resetCounter(3);
        Point pointMouse = event.getPoint();
        this.setLevelToMouse(pointMouse);
    }

    public void mouseMoved(MouseEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.boolFocus) {
            this.setVisible(false);
        }
        this.boolFocus = false;
    }

    public void focusGained(FocusEvent event) {
        this.boolFocus = true;
        this.threadPopup.stopNormaly();
    }

    private void setLevelToMouse(Point pointMouse) {
        int nPos = pointMouse.x - 2;
        Dimension dimSize = this.getSize();
        int nWidth = dimSize.width - 5;
        if (nPos > nWidth) {
            nPos = nWidth;
        }
        if (nPos < 0) {
            nPos = 0;
        }
        float levelGain = (float)nPos / (float)nWidth;
        this.gainControl.setMute(false);
        this.gainControl.setLevel(levelGain);
    }
}

