/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.util.LoopThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadAction;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;
import sun.audio.AudioStream;

public class SunAudioOutput
extends InputStream
implements AudioOutput {
    protected AudioStream audioStream;
    protected int bufLength;
    protected byte[] buffer;
    protected static int EOM = -1;
    protected boolean paused = false;
    protected boolean started = false;
    protected boolean flushing = false;
    private boolean startAfterWrite = false;
    protected boolean firstRead = false;
    protected AudioFormat format;
    private int SUN_MAGIC = 779316836;
    private int HDR_SIZE = 24;
    private int FILE_LENGTH;
    private int SAMPLE_RATE = 8000;
    private int ENCODING = 1;
    private int CHANNELS = 1;
    int in;
    int out;
    boolean eom = false;
    private int samplesPlayed;
    private boolean isMuted = false;
    private double gain;
    private byte[] silence;
    private static final int END_OF_MEDIA_PADDING_LENGTH = 800;
    private int endOfMediaPaddingLength;
    private byte[] conversionBuffer;
    private static final int SLEEP_TIME = 50;
    protected boolean internalDelayUpdate = false;
    private SunAudioPlayThread timeUpdatingThread;
    protected int sunAudioInitialCount;
    protected int sunAudioFinalCount;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    static /* synthetic */ Class class$com$sun$media$renderer$audio$device$SunAudioOutput$SunAudioPlayThread;

    public boolean initialize(AudioFormat format, int length) {
        this.format = format;
        this.bufLength = 12000;
        this.buffer = new byte[this.bufLength];
        this.silence = new byte[this.bufLength];
        int i2 = 0;
        while (i2 < this.bufLength) {
            this.silence[i2] = 127;
            ++i2;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12CreateThreadAction.cons;
                this.timeUpdatingThread = (SunAudioPlayThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$renderer$audio$device$SunAudioOutput$SunAudioPlayThread != null ? class$com$sun$media$renderer$audio$device$SunAudioOutput$SunAudioPlayThread : (class$com$sun$media$renderer$audio$device$SunAudioOutput$SunAudioPlayThread = SunAudioOutput.class$("com.sun.media.renderer.audio.device.SunAudioOutput$SunAudioPlayThread"))));
            }
            catch (Exception exception) {}
        } else {
            this.timeUpdatingThread = new SunAudioPlayThread();
        }
        this.setPaddingLength(800);
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        DataOutputStream tempData = new DataOutputStream(tempOut);
        try {
            tempData.writeInt(this.SUN_MAGIC);
            tempData.writeInt(this.HDR_SIZE);
            tempData.writeInt(this.FILE_LENGTH);
            tempData.writeInt(this.ENCODING);
            tempData.writeInt(this.SAMPLE_RATE);
            tempData.writeInt(this.CHANNELS);
        }
        catch (Exception exception) {}
        byte[] buf = tempOut.toByteArray();
        this.write(buf, 0, buf.length);
        String encoding = format.getEncoding();
        int sampleRate = (int)format.getSampleRate();
        if (format.getChannels() != 1 || sampleRate != 8000 || !encoding.equals("ULAW")) {
            System.out.println("AudioPlay:Unsupported Audio Format");
            return false;
        }
        try {
            this.audioStream = new AudioStream((InputStream)this);
        }
        catch (Exception e3) {
            System.err.println("Exception: " + e3);
            this.audioStream = null;
            return false;
        }
        return true;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void pause() {
        if (this.audioStream != null) {
            this.timeUpdatingThread.pause();
            AudioPlayer.player.stop((InputStream)this.audioStream);
        }
        this.paused = true;
    }

    public synchronized void resume() {
        if (this.audioStream != null && (!this.started || this.paused)) {
            this.started = true;
            AudioPlayer.player.start((InputStream)this.audioStream);
            this.timeUpdatingThread.start();
        }
        this.paused = false;
    }

    public synchronized void dispose() {
        if (this.audioStream != null) {
            this.timeUpdatingThread.kill();
            AudioPlayer.player.stop((InputStream)this.audioStream);
        }
        this.buffer = null;
    }

    public void drain() {
        SunAudioOutput sunAudioOutput = this;
        synchronized (sunAudioOutput) {
            int remain = this.endOfMediaPaddingLength;
            while (remain > 0) {
                int len = this.write(this.silence, 0, remain);
                remain -= len;
            }
            while (this.in != this.out && !this.paused) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public synchronized void flush() {
        this.in = 0;
        this.out = 0;
        this.sunAudioInitialCount = this.sunAudioFinalCount = this.samplesPlayed;
        this.flushing = true;
        this.notifyAll();
    }

    public long getMediaNanoseconds() {
        return this.audioStream == null ? 0L : (long)this.samplesPlayed * 125000L;
    }

    public void setMute(boolean m2) {
        this.isMuted = m2;
    }

    public boolean getMute() {
        return this.isMuted;
    }

    public void setGain(double g2) {
    }

    public double getGain() {
        return 0.0;
    }

    public float setRate(float r2) {
        return 1.0f;
    }

    public float getRate() {
        return 1.0f;
    }

    public int dataAvailable() {
        if (this.in == this.out) {
            return 0;
        }
        if (this.in > this.out) {
            return this.in - this.out;
        }
        return this.bufLength - (this.out - this.in);
    }

    public int bufferAvailable() {
        return this.bufLength - this.dataAvailable() - 1;
    }

    public synchronized int read() {
        while (this.in == this.out) {
            if (this.eom) {
                this.eom = false;
                return EOM;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        int ret = this.buffer[this.out++] & 0xFF;
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        return ret;
    }

    public synchronized int read(byte[] b2, int off, int len) {
        int inputLength = len;
        if (len <= 0) {
            return -1;
        }
        if (len > 4 && !this.internalDelayUpdate) {
            this.internalDelayUpdate = true;
            this.timeUpdatingThread.setInternalDelay(len);
        }
        if (this.dataAvailable() == 0) {
            System.arraycopy(this.silence, 0, b2, off, inputLength);
            return inputLength;
        }
        int c2 = this.read();
        if (c2 < 0) {
            return -1;
        }
        b2[off] = (byte)c2;
        int rlen = 1;
        if (this.in != this.out) {
            --len;
            if (this.out < this.in) {
                int avail = this.in - this.out;
                if (avail > len) {
                    avail = len;
                }
                System.arraycopy(this.buffer, this.out, b2, off + 1, avail);
                this.out += avail;
                rlen += avail;
            } else if (this.out > this.in) {
                int avail = this.bufLength - this.out;
                if (avail >= len) {
                    avail = len;
                    System.arraycopy(this.buffer, this.out, b2, off + 1, avail);
                    this.out += avail;
                    if (this.out >= this.bufLength) {
                        this.out = 0;
                    }
                    rlen += avail;
                } else {
                    System.arraycopy(this.buffer, this.out, b2, off + 1, avail);
                    this.out += avail;
                    if (this.out >= this.bufLength) {
                        this.out = 0;
                    }
                    int copied = avail;
                    rlen += avail;
                    int need = len - avail;
                    int size = need <= (avail = this.in - this.out) ? need : avail;
                    System.arraycopy(this.buffer, 0, b2, off + 1 + copied, size);
                    this.out += size;
                    rlen += size;
                }
            }
        }
        if (this.isMuted) {
            System.arraycopy(this.silence, 0, b2, off, inputLength);
        } else if (rlen < inputLength) {
            System.arraycopy(this.silence, 0, b2, off + rlen, inputLength - rlen);
        }
        this.timeUpdatingThread.resetSampleCountTime();
        this.sunAudioInitialCount = this.sunAudioFinalCount;
        this.sunAudioFinalCount += rlen;
        this.notifyAll();
        return inputLength;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int write(byte[] data, int off, int len) {
        this.flushing = false;
        if (len > 0) ** GOTO lbl8
        return 0;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException v0) {}
lbl8:
            // 3 sources

            ** while ((this.in + 1) % this.buffer.length == this.out)
        }
lbl9:
        // 1 sources

        if (this.flushing) {
            return 0;
        }
        wlen = 0;
        if (this.in < this.out) {
            canWrite = this.out - this.in - 1;
            actualWrite = canWrite < len ? canWrite : len;
            System.arraycopy(data, off, this.buffer, this.in, actualWrite);
            this.in += actualWrite;
            wlen += actualWrite;
        } else {
            length1 = this.out == 0 ? this.bufLength - this.in - 1 : this.bufLength - this.in;
            if (length1 >= len) {
                actualWrite = len;
                System.arraycopy(data, off, this.buffer, this.in, actualWrite);
                this.in += actualWrite;
                if (this.in >= this.bufLength) {
                    this.in = 0;
                }
                wlen += actualWrite;
            } else {
                actualWrite = length1;
                System.arraycopy(data, off, this.buffer, this.in, actualWrite);
                this.in += actualWrite;
                if (this.in >= this.bufLength) {
                    this.in = 0;
                }
                wlen += actualWrite;
                len -= actualWrite;
                actualWrite1 = actualWrite;
                if (this.out > 0) {
                    canWrite = this.out - this.in - 1;
                    actualWrite = canWrite < len ? canWrite : len;
                    System.arraycopy(data, off + actualWrite1, this.buffer, 0, actualWrite);
                    wlen += actualWrite;
                    this.in = actualWrite;
                }
            }
        }
        this.notifyAll();
        return wlen;
    }

    protected void setPaddingLength(int paddingLength) {
        this.endOfMediaPaddingLength = paddingLength;
        if (this.endOfMediaPaddingLength > this.silence.length) {
            this.endOfMediaPaddingLength = this.silence.length;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static /* synthetic */ int access$0() {
        return 50;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    class SunAudioPlayThread
    extends LoopThread {
        long initialTime;
        long currentTime;
        int samplesUpdated;
        int sunAudioInternalDelay = -1;

        SunAudioPlayThread() {
            SunAudioOutput.this = SunAudioOutput.this;
            this.setName(String.valueOf(this.getName()) + ": " + this);
        }

        public void resetSampleCountTime() {
            this.initialTime = System.currentTimeMillis();
        }

        public synchronized void start() {
            this.currentTime = System.currentTimeMillis();
            super.start();
        }

        public void setInternalDelay(int delay) {
            if (delay >= 0) {
                this.sunAudioInternalDelay = delay;
            }
            SunAudioOutput.this.setPaddingLength(this.sunAudioInternalDelay * 2);
        }

        protected boolean process() {
            try {
                Thread.sleep(SunAudioOutput.access$0());
            }
            catch (InterruptedException interruptedException) {}
            if (this.sunAudioInternalDelay >= 0) {
                int tmpSamplesPlayed;
                this.currentTime = System.currentTimeMillis();
                this.samplesUpdated = (int)((this.currentTime - this.initialTime) * 8L);
                if (this.samplesUpdated >= 0 && !SunAudioOutput.this.paused && (tmpSamplesPlayed = SunAudioOutput.this.sunAudioInitialCount + this.samplesUpdated) > SunAudioOutput.this.samplesPlayed && tmpSamplesPlayed <= SunAudioOutput.this.sunAudioFinalCount && tmpSamplesPlayed - this.sunAudioInternalDelay > SunAudioOutput.this.samplesPlayed) {
                    SunAudioOutput.this.samplesPlayed = tmpSamplesPlayed - this.sunAudioInternalDelay;
                }
            }
            return true;
        }
    }
}

