/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.rtp;

import com.sun.media.BasicPlayer;
import com.sun.media.MediaEngine;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicPlayer
implements ReceiveStreamListener {
    protected MediaEngine engine;
    SessionManager mgr;
    String address;
    int port = -1;
    int ttl = 1;
    String media;
    Player newplayer;
    boolean datareceived = false;
    Object data = new Integer(0);
    PlayerListener listener;
    Player mplayer;
    Component visualComp;
    DataSource rtpsource;
    TimeBase timebase;
    Integer stateLock = new Integer(0);
    private boolean payloadchange = false;
    private boolean closed = false;
    private boolean stateReached = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private Format oldFormat;
    private Format newFormat;

    public Handler() {
        this.listener = new PlayerListener();
        this.framePositioning = false;
    }

    protected synchronized boolean doRealize() {
        super.doRealize();
        try {
            this.mgr = this.source instanceof RTPSocket ? new RTPSessionMgr((RTPSocket)this.source) : new RTPSessionMgr((com.sun.media.protocol.rtp.DataSource)this.source);
            if (this.mgr == null) {
                return false;
            }
            this.mgr.addReceiveStreamListener(this);
            if (!(this.source instanceof RTPSocket)) {
                InetAddress destaddr = InetAddress.getByName(this.address);
                SessionAddress sessaddr = new SessionAddress(destaddr, this.port, destaddr, this.port + 1);
                this.mgr.startSession(sessaddr, this.ttl, null);
            }
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
            return false;
        }
        return true;
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    protected void completeRealize() {
        try {
            Object object = this.data;
            synchronized (object) {
                while (!this.datareceived) {
                    this.data.wait();
                }
            }
        }
        catch (Exception exception) {}
        super.completeRealize();
        try {
            if (this.newplayer != null) {
                this.timebase = this.newplayer.getTimeBase();
            }
            this.mplayer.setTimeBase(this.timebase);
            this.mplayer.addController(this.newplayer);
        }
        catch (Exception e2) {
            e2.getMessage();
        }
    }

    public void update(ReceiveStreamEvent event) {
        if (event instanceof RemotePayloadChangeEvent) {
            System.out.println("Received a PayloadChangeEvent");
            System.out.println("Please wait till new player is created....");
            RTPControl ctl = (RTPControl)this.rtpsource.getControl("javax.media.rtp.RTPControl");
            if (ctl != null) {
                this.newFormat = ctl.getFormat();
            }
            this.payloadchange = true;
            if (this.newplayer != null) {
                this.waitForStop(this.mplayer);
                this.mplayer.removeController(this.newplayer);
                this.newplayer.close();
                Integer n2 = this.stateLock;
                synchronized (n2) {
                    try {
                        while (!this.closed) {
                            this.stateLock.wait();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            try {
                this.rtpsource.connect();
                this.newplayer = Manager.createPlayer(this.rtpsource);
                if (this.newplayer == null) {
                    System.err.println("Could not create player for new payload");
                    return;
                }
                this.newplayer.addControllerListener(this.listener);
                this.newplayer.realize();
                this.closed = false;
                this.stateReached = false;
            }
            catch (Exception exception) {
                System.err.println("could not create player for new payload");
            }
        }
        if (event instanceof NewReceiveStreamEvent) {
            String cname = "Java Media Player";
            ReceiveStream stream = null;
            if (this.newplayer != null) {
                return;
            }
            try {
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                Participant part = stream.getParticipant();
                if (part != null) {
                    cname = part.getCNAME();
                }
                this.rtpsource = stream.getDataSource();
                RTPControl ctl = (RTPControl)this.rtpsource.getControl("javax.media.rtp.RTPControl");
                if (ctl != null) {
                    this.oldFormat = ctl.getFormat();
                    if (this.oldFormat instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.oldFormat instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.rtpsource);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.rtpsource);
                }
                this.newplayer = Manager.createPlayer(this.rtpsource);
                if (this.newplayer == null) {
                    return;
                }
                this.newplayer.addControllerListener(this.listener);
                this.newplayer.realize();
                this.mplayer = this;
            }
            catch (Exception e3) {
                System.err.println("NewReceiveStreamEvent exception " + e3.getMessage());
                return;
            }
        }
    }

    private synchronized boolean waitForStop(Player p2) {
        StateListener t = null;
        if (p2.getState() != 600) {
            return true;
        }
        t = new StateListener();
        p2.addControllerListener(t);
        p2.stop();
        Integer n2 = this.stateLock;
        synchronized (n2) {
            while (!this.stateReached) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        p2.removeControllerListener(t);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        if (source instanceof com.sun.media.protocol.rtp.DataSource) {
            MediaLocator ml = source.getLocator();
            try {
                RTPMediaLocator mrl = new RTPMediaLocator(ml.toString());
                this.address = mrl.getSessionAddress();
                this.port = mrl.getSessionPort();
                this.ttl = mrl.getTTL();
                this.media = mrl.getContentType();
                RTPControl ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl");
                if (ctl == null) return;
                ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
                return;
            }
            catch (Exception exception) {
                throw new IncompatibleSourceException();
            }
        } else {
            if (!(source instanceof RTPSocket)) throw new IncompatibleSourceException();
            RTPControl ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl");
            if (ctl == null) return;
            ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.visualComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        if (this.newplayer != null) {
            return this.newplayer.getVisualComponent();
        }
        return this.visualComp;
    }

    protected TimeBase getMasterTimeBase() {
        return this.timebase;
    }

    public void updateStats() {
        if (this.newplayer != null) {
            ((BasicPlayer)this.newplayer).updateStats();
        }
    }

    static /* synthetic */ boolean access$8(Handler $0) {
        return $0.closed;
    }

    static /* synthetic */ boolean access$10(Handler $0) {
        return $0.stateReached;
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof StopEvent) {
                Integer n2 = Handler.this.stateLock;
                synchronized (n2) {
                    Handler.this.stateReached = true;
                    Handler.this.stateLock.notifyAll();
                }
            }
        }

        StateListener() {
            Handler.this = Handler.this;
        }
    }

    public class PlayerListener
    implements ControllerListener {
        public synchronized void controllerUpdate(ControllerEvent ce) {
            Object object;
            Player p2 = (Player)ce.getSourceController();
            if (ce instanceof RealizeCompleteEvent) {
                Handler.this.visualComp = p2.getVisualComponent();
                object = Handler.this.data;
                synchronized (object) {
                    Handler.this.datareceived = true;
                    Handler.this.data.notifyAll();
                }
                if (Handler.this.payloadchange) {
                    try {
                        if (p2 != null) {
                            Handler.this.timebase = p2.getTimeBase();
                        }
                        Handler.this.mplayer.setTimeBase(Handler.this.timebase);
                        Handler.this.mplayer.addController(p2);
                        ((Handler)Handler.this.mplayer).invalidateComp();
                        FormatChangeEvent f2 = new FormatChangeEvent(Handler.this.mplayer, Handler.this.oldFormat, Handler.this.newFormat);
                        ((Handler)Handler.this.mplayer).sendMyEvent(f2);
                        Handler.this.oldFormat = Handler.this.newFormat;
                        Handler.this.newFormat = null;
                        Handler.this.payloadchange = false;
                        Handler.this.mplayer.start();
                    }
                    catch (Exception e2) {
                        e2.getMessage();
                    }
                }
            }
            if (ce instanceof ControllerErrorEvent) {
                Handler.this.visualComp = null;
                Handler.this.newplayer.removeControllerListener(this);
                if (Handler.this.mplayer.getState() > 300) {
                    Handler.this.mplayer.removeController(Handler.this.newplayer);
                }
                Handler.this.newplayer.close();
                Handler.this.newplayer = null;
            }
            if (ce instanceof ControllerClosedEvent) {
                Handler.this.newplayer = null;
                object = Handler.this.stateLock;
                synchronized (object) {
                    Handler.this.closed = true;
                    Handler.this.stateLock.notifyAll();
                }
                System.gc();
                System.runFinalization();
            }
        }

        public PlayerListener() {
            Handler.this = Handler.this;
        }
    }
}

