/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vh263;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends VideoCodec {
    private int nativeData;
    private int pictureDesc;
    private int PBFrameCap = 1;
    private int bsStart;
    private int nextGOB;
    private int pendingFrame;
    static final int[] widths;
    static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    private boolean FormatSizeInitFlag = false;
    private int payloadLength = 4;

    private static native boolean initNativeDecoderClass();

    private native boolean initNativeDecoder(int var1, int var2);

    private native boolean decodeFrameNative(Buffer var1, Buffer var2);

    private native boolean decodePacketNative(byte[] var1, int var2, int var3, byte[] var4, byte[] var5, int var6, int var7);

    private native boolean closeNativeDecoder();

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new YUVFormat()};
        this.PLUGIN_NAME = "H.263 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int inMaxDataLength = ivf.getMaxDataLength();
        if (ivf.getEncoding().equals("h263/rtp")) {
            int outNumOfPixels = this.videoWidth * this.videoHeight;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        } else {
            Dimension outSize = this.movieSizeTo263Size(inSize);
            int outNumOfPixels = outSize.width * outSize.height;
            this.videoWidth = outSize.width;
            this.videoHeight = outSize.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(inSize, outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, outSize.width, outSize.width >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        }
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmvh263");
            NativeDecoder.initNativeDecoderClass();
            this.initDecoder();
            return;
        }
        catch (Throwable e2) {
            System.out.println(e2);
            throw new ResourceUnavailableException("could not load jmvh263");
        }
    }

    public void close() {
        this.closeNativeDecoder();
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        this.close();
        this.initNativeDecoder(this.videoWidth, this.videoHeight);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        boolean rtpData = false;
        boolean ret = false;
        Object rtpHeader = null;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        int inputOffset = inputBuffer.getOffset();
        byte[] inData = (byte[])inputBuffer.getData();
        if (ivf.getEncoding().equals("h263/rtp")) {
            rtpData = true;
            this.payloadLength = this.getPayloadHeaderLength(inData, inputOffset);
            if (inData[inputOffset + this.payloadLength] == 0 && inData[inputOffset + this.payloadLength + 1] == 0 && (inData[inputOffset + this.payloadLength + 2] & 0xFC) == 128) {
                int s = inData[inputOffset + this.payloadLength + 4] >> 2 & 7;
                if (this.videoWidth != widths[s] || this.videoHeight != heights[s]) {
                    this.videoWidth = widths[s];
                    this.videoHeight = heights[s];
                    int outNumOfPixels = this.videoWidth * this.videoHeight;
                    this.outputFormat = new YUVFormat(new Dimension(this.videoWidth, this.videoHeight), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.videoWidth, this.videoWidth >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2));
                    outMaxLength = this.videoWidth * this.videoHeight;
                    this.videoResized();
                }
                this.FormatSizeInitFlag = true;
            }
            if (!this.FormatSizeInitFlag) {
                return 1;
            }
        }
        byte[] outData = this.validateByteArraySize(outputBuffer, outMaxLength);
        if (inLength + 8 + inputOffset > inData.length) {
            System.out.println("allocating more data for H.263");
            int newLength = inLength > inMaxLength ? inLength : inMaxLength;
            byte[] tempArray = new byte[inputOffset + newLength + 8];
            System.arraycopy(inData, 0, tempArray, 0, inLength + inputOffset);
            inData = tempArray;
            inputBuffer.setData(tempArray);
        }
        inData[inputOffset + inLength] = 0;
        inData[inputOffset + inLength + 1] = 0;
        inData[inputOffset + inLength + 2] = -4;
        inputBuffer.setLength(inLength += 3);
        if (rtpData) {
            inLength -= this.payloadLength;
            int marker = 0;
            if ((inputBuffer.getFlags() & 0x400) != 0) {
                marker = 1;
            }
            ret = this.decodePacketNative(inData, inputOffset + this.payloadLength, inLength, outData, inData, inputOffset, marker);
        } else {
            ret = this.decodeFrameNative(inputBuffer, outputBuffer);
        }
        if (ret) {
            if (rtpData) {
                outputBuffer.setTimeStamp(0L);
            }
            this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
            return 0;
        }
        return 4;
    }

    private Dimension movieSizeTo263Size(Dimension movieSize) {
        int width = movieSize.width + 15 & 0xFFFFFFF0;
        int height = movieSize.height + 15 & 0xFFFFFFF0;
        int formatCap = width * height >> 8;
        if (formatCap <= 48) {
            return new Dimension(128, 96);
        }
        if (formatCap <= 99) {
            return new Dimension(176, 144);
        }
        if (formatCap <= 396) {
            return new Dimension(352, 288);
        }
        if (formatCap <= 1584) {
            return new Dimension(704, 576);
        }
        if (formatCap <= 6336) {
            return new Dimension(1408, 1152);
        }
        return new Dimension(0, 0);
    }

    private int getPayloadHeaderLength(byte[] input, int offset) {
        int l2 = 0;
        byte b2 = input[offset];
        l2 = (b2 & 0x80) != 0 ? ((b2 & 0x40) != 0 ? 12 : 8) : 4;
        return l2;
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h263/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        heights = nArray2;
    }
}

