/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.protocol;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;

public class CloneableSourceStreamAdapter
implements Runnable {
    SourceStream master;
    SourceStream adapter;
    Vector slaves = new Vector();
    Thread notifyingThread;

    CloneableSourceStreamAdapter(SourceStream master) {
        this.master = master;
        if (master instanceof PullSourceStream) {
            this.adapter = new PullSourceStreamAdapter();
        }
        if (master instanceof PullBufferStream) {
            this.adapter = new PullBufferStreamAdapter();
        }
        if (master instanceof PushSourceStream) {
            this.adapter = new PushSourceStreamAdapter();
        }
        if (master instanceof PushBufferStream) {
            this.adapter = new PushBufferStreamAdapter();
        }
        this.notifyingThread = new Thread(this);
        this.notifyingThread.start();
    }

    SourceStream getAdapter() {
        return this.adapter;
    }

    SourceStream createSlave() {
        SourceStreamAdapter slave = null;
        if (this.master instanceof PullSourceStream || this.master instanceof PushSourceStream) {
            slave = new PushSourceStreamSlave();
        }
        if (this.master instanceof PullBufferStream || this.master instanceof PushBufferStream) {
            slave = new PushBufferStreamSlave();
        }
        this.slaves.addElement(slave);
        return slave;
    }

    void copyAndRead(Buffer b2) throws IOException {
        if (this.master instanceof PullBufferStream) {
            ((PullBufferStream)this.master).read(b2);
        }
        if (this.master instanceof PushBufferStream) {
            ((PushBufferStream)this.master).read(b2);
        }
        Enumeration e2 = this.slaves.elements();
        while (e2.hasMoreElements()) {
            Object stream = e2.nextElement();
            Buffer copyBuffer = new Buffer();
            copyBuffer.setFormat(b2.getFormat());
            copyBuffer.setFlags(b2.getFlags());
            copyBuffer.setEOM(b2.isEOM());
            copyBuffer.setDiscard(b2.isDiscard());
            byte[] data = (byte[])b2.getData();
            if (data != null) {
                copyBuffer.setData(data.clone());
            } else {
                copyBuffer.setData(null);
            }
            byte[] header = (byte[])b2.getHeader();
            if (header != null) {
                copyBuffer.setHeader(header.clone());
            } else {
                copyBuffer.setHeader(null);
            }
            copyBuffer.setLength(b2.getLength());
            copyBuffer.setOffset(b2.getOffset());
            copyBuffer.setTimeStamp(b2.getTimeStamp());
            copyBuffer.setSequenceNumber(b2.getSequenceNumber());
            ((PushBufferStreamSlave)stream).setBuffer(copyBuffer);
        }
        CloneableSourceStreamAdapter cloneableSourceStreamAdapter = this;
        synchronized (cloneableSourceStreamAdapter) {
            this.notify();
        }
    }

    int copyAndRead(byte[] buffer, int offset, int length) throws IOException {
        int totalRead = 0;
        if (this.master instanceof PullSourceStream) {
            totalRead = ((PullSourceStream)this.master).read(buffer, offset, length);
        }
        if (this.master instanceof PushSourceStream) {
            totalRead = ((PushSourceStream)this.master).read(buffer, offset, length);
        }
        Enumeration e2 = this.slaves.elements();
        while (e2.hasMoreElements()) {
            Object stream = e2.nextElement();
            byte[] copyBuffer = new byte[totalRead];
            System.arraycopy(buffer, offset, copyBuffer, 0, totalRead);
            ((PushSourceStreamSlave)stream).setBuffer(copyBuffer);
        }
        CloneableSourceStreamAdapter cloneableSourceStreamAdapter = this;
        synchronized (cloneableSourceStreamAdapter) {
            this.notify();
        }
        return totalRead;
    }

    public void run() {
        while (!this.master.endOfStream()) {
            try {
                CloneableSourceStreamAdapter cloneableSourceStreamAdapter = this;
                synchronized (cloneableSourceStreamAdapter) {
                    this.wait();
                }
            }
            catch (InterruptedException e2) {
                System.out.println("Exception: " + e2);
            }
            Enumeration e3 = this.slaves.elements();
            while (e3.hasMoreElements()) {
                Object handler;
                Object stream = e3.nextElement();
                if (stream instanceof PushSourceStreamSlave) {
                    handler = ((PushSourceStreamSlave)stream).getTransferHandler();
                    handler.transferData((PushSourceStreamSlave)stream);
                    continue;
                }
                handler = ((PushBufferStreamSlave)stream).getTransferHandler();
                handler.transferData((PushBufferStream)stream);
            }
        }
    }

    class SourceStreamAdapter
    implements SourceStream {
        public ContentDescriptor getContentDescriptor() {
            return CloneableSourceStreamAdapter.this.master.getContentDescriptor();
        }

        public long getContentLength() {
            return CloneableSourceStreamAdapter.this.master.getContentLength();
        }

        public boolean endOfStream() {
            return CloneableSourceStreamAdapter.this.master.endOfStream();
        }

        public Object[] getControls() {
            return CloneableSourceStreamAdapter.this.master.getControls();
        }

        public Object getControl(String controlType) {
            return CloneableSourceStreamAdapter.this.master.getControl(controlType);
        }

        SourceStreamAdapter() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PushSourceStreamSlave
    extends SourceStreamAdapter
    implements PushSourceStream {
        SourceTransferHandler handler;
        private byte[] buffer;

        void setBuffer(byte[] buffer) {
            this.buffer = buffer;
        }

        /*
         * Unable to fully structure code
         */
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (length + offset <= buffer.length) ** GOTO lbl8
            throw new IOException("buffer is too small");
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    System.out.println("Exception: " + e);
                }
lbl8:
                // 3 sources

                ** while (this.buffer == null)
            }
lbl9:
            // 1 sources

            copyLength = length > this.buffer.length ? this.buffer.length : length;
            System.arraycopy(this.buffer, 0, buffer, offset, copyLength);
            this.buffer = null;
            return copyLength;
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(SourceTransferHandler transferHandler) {
            this.handler = transferHandler;
        }

        SourceTransferHandler getTransferHandler() {
            return this.handler;
        }

        PushSourceStreamSlave() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PushBufferStreamSlave
    extends SourceStreamAdapter
    implements PushBufferStream {
        BufferTransferHandler handler;
        private Buffer b;

        void setBuffer(Buffer b2) {
            this.b = b2;
        }

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            while (this.b == null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    System.out.println("Exception: " + e2);
                }
            }
            buffer.setFormat(this.b.getFormat());
            buffer.setFlags(this.b.getFlags());
            buffer.setEOM(this.b.isEOM());
            buffer.setDiscard(this.b.isDiscard());
            buffer.setData(this.b.getData());
            buffer.setHeader(this.b.getHeader());
            buffer.setLength(this.b.getLength());
            buffer.setOffset(this.b.getOffset());
            buffer.setTimeStamp(this.b.getTimeStamp());
            buffer.setSequenceNumber(this.b.getSequenceNumber());
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.handler = transferHandler;
        }

        BufferTransferHandler getTransferHandler() {
            return this.handler;
        }

        PushBufferStreamSlave() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PullSourceStreamAdapter
    extends SourceStreamAdapter
    implements PullSourceStream {
        public boolean willReadBlock() {
            return ((PullSourceStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(buffer, offset, length);
        }

        PullSourceStreamAdapter() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PullBufferStreamAdapter
    extends SourceStreamAdapter
    implements PullBufferStream {
        public boolean willReadBlock() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).willReadBlock();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public Format getFormat() {
            return ((PullBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        PullBufferStreamAdapter() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PushSourceStreamAdapter
    extends SourceStreamAdapter
    implements PushSourceStream,
    SourceTransferHandler {
        SourceTransferHandler handler;

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return CloneableSourceStreamAdapter.this.copyAndRead(buffer, offset, length);
        }

        public int getMinimumTransferSize() {
            return ((PushSourceStream)CloneableSourceStreamAdapter.this.master).getMinimumTransferSize();
        }

        public void setTransferHandler(SourceTransferHandler transferHandler) {
            this.handler = transferHandler;
            ((PushSourceStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushSourceStream stream) {
            this.handler.transferData(this);
        }

        PushSourceStreamAdapter() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }

    class PushBufferStreamAdapter
    extends SourceStreamAdapter
    implements PushBufferStream,
    BufferTransferHandler {
        BufferTransferHandler handler;

        public Format getFormat() {
            return ((PushBufferStream)CloneableSourceStreamAdapter.this.master).getFormat();
        }

        public void read(Buffer buffer) throws IOException {
            CloneableSourceStreamAdapter.this.copyAndRead(buffer);
        }

        public void setTransferHandler(BufferTransferHandler transferHandler) {
            this.handler = transferHandler;
            ((PushBufferStream)CloneableSourceStreamAdapter.this.master).setTransferHandler(this);
        }

        public void transferData(PushBufferStream stream) {
            this.handler.transferData(this);
        }

        PushBufferStreamAdapter() {
            CloneableSourceStreamAdapter.this = CloneableSourceStreamAdapter.this;
        }
    }
}

