/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.mpegenc;

import com.ibm.media.codec.audio.AudioCodec;
import com.ibm.media.codec.audio.mpegenc.MpegAudioControlAdapter;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.VFlowLayout;
import java.awt.Frame;
import java.awt.Label;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeEncoder
extends AudioCodec {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    Control[] controls;
    static final int MAX_MPEG_STREAM_FRAME_SIZE = 1728;
    static final int MAX_PCM_FRAME_SIZE = 2304;
    static final int ENCD_MAX_FRAMES = 9;
    static final int MAX_INPUT_SIZE = 41472;
    static final int MAX_OUTPUT_SIZE = 15552;
    static final int MPEG_NOERROR = 0;
    static final int MPEG_ERROR = 1;
    static final int MPEG_FALSE = 0;
    static final int MPEG_TRUE = 1;
    static final int MPEG_STEREO = 0;
    static final int MPEG_JOINT_STEREO = 1;
    static final int MPEG_DUAL_CHANNEL = 2;
    static final int MPEG_SINGLE_CHANNEL = 3;
    static final int[] layer1BitRate_mono = new int[]{32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448};
    static final int[] layer1BitRate_stereo = new int[]{64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448};
    static final int[] layer2BitRate_mono = new int[]{32, 48, 56, 64, 80, 96, 112, 128, 160, 192};
    static final int[] layer2BitRate_stereo = new int[]{64, 96, 112, 128, 160, 192, 224, 256, 320, 384};
    private int[] pdata = new int[1];
    private int[] psetup = new int[1];
    private int layer;
    private int encodingType;
    private int bitrate;
    private int samplingFrequency;
    private int endianess;
    private int copyright;
    private int original;
    private int errorProtect;
    private int nChannels;
    private int[] in_bytes = new int[1];
    private int[] out_bytes = new int[1];
    boolean isStarted;
    byte[] history = new byte[41472];
    int historyLength;
    static /* synthetic */ Class array$B;

    public NativeEncoder() {
        int[] SamplingFrequencies = new int[]{32000, 44100, 48000};
        this.supportedInputFormats = new AudioFormat[3];
        int i2 = 0;
        while (i2 < 3) {
            this.supportedInputFormats[i2] = new AudioFormat("LINEAR", SamplingFrequencies[i2], 16, -1, 0, 1, -1, -1.0, array$B != null ? array$B : NativeEncoder.class$("[B"));
            ++i2;
        }
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("mpegaudio")};
        this.PLUGIN_NAME = "MPEG Audio Encoder";
    }

    private static native int nativeOpen(int[] var0, int[] var1);

    private static native int nativeInit(int[] var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native int nativeGetBytesToRead(int[] var0, int[] var1);

    private static native int nativeEncode(int[] var0, int[] var1, byte[] var2, int var3, int var4, byte[] var5, int var6, int var7, int[] var8, int[] var9);

    private static native int nativeHandleEOM(int[] var0, int[] var1, byte[] var2, int var3, int[] var4);

    private static native int nativeClose(int[] var0, int[] var1);

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("mpegaudio", af.getSampleRate(), -1, af.getChannels(), -1, -1, -1, -1.0, array$B != null ? array$B : (array$B = NativeEncoder.class$("[B")))};
        return this.supportedOutputFormats;
    }

    public Format setInputFormat(Format format) {
        AudioFormat af = (AudioFormat)super.setInputFormat(format);
        if (af == null) {
            return null;
        }
        this.nChannels = af.getChannels();
        this.samplingFrequency = (int)af.getSampleRate();
        this.endianess = af.getEndian() == 1 ? 1 : 0;
        this.bitrate = 128 * this.nChannels;
        this.layer = 2;
        this.encodingType = this.nChannels == 1 ? 3 : 0;
        this.copyright = 0;
        this.original = 0;
        this.errorProtect = 0;
        return af;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmmpegenc");
            NativeEncoder.nativeOpen(this.pdata, this.psetup);
            this.reset();
            this.openControlPanel();
            return;
        }
        catch (Throwable t) {
            String errMsg = "Unable to load " + this.PLUGIN_NAME + "\n" + t;
            t.printStackTrace();
            System.err.println(errMsg);
            throw new ResourceUnavailableException(errMsg);
        }
    }

    private void openControlPanel() {
        Frame controlFrame = new Frame(String.valueOf(this.getName()) + "  Control");
        controlFrame.setLayout(new VFlowLayout(1));
        controlFrame.add(new Label(String.valueOf(this.getName()) + "  Control", 1));
        controlFrame.add(new Label(" "));
        Control[] c2 = (Control[])this.getControls();
        int i2 = 0;
        while (i2 < c2.length) {
            controlFrame.add(c2[i2].getControlComponent());
            ++i2;
        }
        controlFrame.pack();
        controlFrame.show();
    }

    public void reset() {
        int rc = NativeEncoder.nativeInit(this.pdata, this.psetup, this.layer, this.encodingType, this.bitrate, this.samplingFrequency, this.endianess, this.copyright, this.original, this.errorProtect);
        if (rc != 0) {
            throw new RuntimeException("MPEG encoder setting failed. rc=" + rc);
        }
        this.historyLength = 0;
        this.isStarted = false;
    }

    public void close() {
        NativeEncoder.nativeClose(this.pdata, this.psetup);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        this.isStarted = true;
        int inpLength = inputBuffer.getLength();
        boolean returnResult = false;
        boolean fullFrame = true;
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, 15552);
        int inOffset = inputBuffer.getOffset();
        int outOffset = outputBuffer.getOffset();
        int neededinput = NativeEncoder.nativeGetBytesToRead(this.pdata, this.psetup);
        int inpBytes = neededinput - this.historyLength;
        if (inpBytes > inpLength) {
            inpBytes = inpLength;
            fullFrame = false;
        }
        System.arraycopy(inpData, inOffset, this.history, this.historyLength, inpBytes);
        this.historyLength += inpBytes;
        inputBuffer.setOffset(inOffset += inpBytes);
        inputBuffer.setLength(inpLength -= inpBytes);
        if (!fullFrame) {
            if (inputBuffer.isEOM()) {
                NativeEncoder.nativeHandleEOM(this.pdata, this.psetup, outData, outOffset, this.out_bytes);
                int outLength = this.out_bytes[0];
                this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
                return 0;
            }
            return 4;
        }
        int rc = NativeEncoder.nativeEncode(this.pdata, this.psetup, this.history, 0, neededinput, outData, outOffset, outData.length, this.in_bytes, this.out_bytes);
        this.historyLength = 0;
        if (rc != 0) {
            System.out.println("MPEG Audio process error " + rc);
            return 1;
        }
        int outLength = this.out_bytes[0];
        int readInput = this.in_bytes[0];
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 2;
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new MpegAudioControlAdapter(this, this.layer, this.samplingFrequency, this.nChannels, this.bitrate, 0, 0, 0, 0);
        }
        return this.controls;
    }

    boolean setOriginal(int new_original) {
        this.original = new_original;
        this.reset();
        return true;
    }

    boolean setErrorProtect(int new_errorProtect) {
        this.errorProtect = new_errorProtect;
        this.reset();
        return true;
    }

    boolean setCopyright(int new_copyRight) {
        this.copyright = new_copyRight;
        this.reset();
        return true;
    }

    boolean setBitrate(int new_bitrate) {
        this.bitrate = new_bitrate;
        this.reset();
        return true;
    }

    boolean setLayer(int new_layer) {
        this.layer = new_layer;
        this.reset();
        return true;
    }

    boolean SetEncodingType(int new_encodingType) {
        this.encodingType = new_encodingType;
        this.reset();
        return true;
    }

    boolean isControlValid() {
        if (this.original != 0 && this.original != 1) {
            return false;
        }
        if (this.errorProtect != 0 && this.errorProtect != 1) {
            return false;
        }
        if (this.copyright != 0 && this.copyright != 1) {
            return false;
        }
        if (this.endianess != 0 && this.endianess != 1) {
            return false;
        }
        if (this.samplingFrequency != 32000 && this.samplingFrequency != 44100 && this.samplingFrequency != 48000) {
            return false;
        }
        if (this.layer != 1 && this.layer != 2) {
            return false;
        }
        if (this.nChannels != 1 && this.nChannels != 2) {
            return false;
        }
        if (this.encodingType == 2) {
            return false;
        }
        if (this.encodingType == 3 && this.nChannels != 1) {
            return false;
        }
        if ((this.encodingType == 0 || this.encodingType == 1) && this.nChannels != 2) {
            return false;
        }
        if (this.layer == 1) {
            if (this.nChannels == 1) {
                int i2 = 0;
                while (i2 < layer1BitRate_mono.length) {
                    if (this.bitrate == layer1BitRate_mono[i2]) {
                        return true;
                    }
                    ++i2;
                }
                return false;
            }
            int i3 = 0;
            while (i3 < layer1BitRate_stereo.length) {
                if (this.bitrate == layer1BitRate_stereo[i3]) {
                    return true;
                }
                ++i3;
            }
            return false;
        }
        if (this.nChannels == 1) {
            int i4 = 0;
            while (i4 < layer2BitRate_mono.length) {
                if (this.bitrate == layer2BitRate_mono[i4]) {
                    return true;
                }
                ++i4;
            }
            return false;
        }
        int i5 = 0;
        while (i5 < layer2BitRate_stereo.length) {
            if (this.bitrate == layer2BitRate_stereo[i5]) {
                return true;
            }
            ++i5;
        }
        return false;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

