/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.DTMsgBox;
import com.ibm.media.bean.multiplayer.JMFUtil;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;

public class LinksArrayEditor
extends PropertyEditorSupport
implements PropertyEditor,
Serializable,
ActionListener,
ItemListener {
    PropertyChangeSupport support = new PropertyChangeSupport(this);
    Panel linksPanel = new Panel();
    transient String[] oldValue;
    transient String[] newValue;
    List mediaGroup = new List(5);
    List related = new List(5);
    List start = new List(5);
    List stop = new List(5);
    TextField relatedField = new TextField(20);
    TextField startField = new TextField(3);
    TextField stopField = new TextField(3);
    TextField mediaNumField = new TextField(3);
    Button addLink = new Button(JMFUtil.getBIString("ADD"));
    Button delLink = new Button(JMFUtil.getBIString("DELETE"));
    Label mediaLabel = new Label(JMFUtil.getBIString("MEDIA_GROUP"));
    Label linkLabel = new Label(JMFUtil.getBIString("RELATED_LINK_URL"));
    Label startLabel = new Label(JMFUtil.getBIString("START_TIME"));
    Label stopLabel = new Label(JMFUtil.getBIString("STOP_TIME"));
    Panel pan;
    String addLinkC = "addLink";
    String delLinkC = "delLink";

    public Component getCustomEditor() {
        if (this.pan == null) {
            this.pan = this.createGuiPanel();
        }
        return this.pan;
    }

    public void paintValue(Graphics g2, Rectangle r2) {
        g2.setColor(Color.black);
        g2.draw3DRect(1, 1, r2.width - 2, r2.height - 2, true);
        g2.setColor(Color.black);
        g2.setFont(new Font("Helevetica", 1, 9));
        g2.drawString(this.getAsText(), 5, r2.height / 2 + 5);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setAsText(String s) {
        this.setValue(JMFUtil.parseStringIntoArray(s));
    }

    public String getAsText() {
        return JMFUtil.parseArrayIntoString(this.newValue);
    }

    public String getJavaInitializationString() {
        StringBuffer initString = new StringBuffer("");
        if (this.newValue == null) {
            return "null";
        }
        initString = new StringBuffer("new String[] {\"");
        int i2 = 0;
        while (i2 < this.newValue.length) {
            initString.append(JMFUtil.convertString(this.newValue[i2]));
            if (i2 + 1 != this.newValue.length) {
                initString.append("\",\"");
            }
            ++i2;
        }
        initString.append("\"}");
        return initString.toString();
    }

    public boolean isPaintable() {
        return true;
    }

    public void setValue(Object val) {
        this.oldValue = this.newValue;
        this.newValue = val instanceof String ? JMFUtil.parseStringIntoArray((String)val) : (String[])val;
        this.firePropertyChange();
        this.support.firePropertyChange("links", null, this.newValue);
    }

    public Object getValue() {
        return this.newValue;
    }

    public Panel createGuiPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        this.linksPanel.setLayout(gridbag);
        this.linksPanel.setBackground(Color.lightGray);
        this.linksPanel.setForeground(Color.black);
        this.delLink.setEnabled(false);
        this.linksPanel.setLayout(gridbag);
        this.refreshLists();
        c2.gridx = 1;
        c2.gridy = 1;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.anchor = 17;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.mediaLabel, c2);
        c2.gridx = 2;
        c2.gridy = 1;
        c2.gridwidth = 3;
        c2.gridheight = 1;
        c2.anchor = 17;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.linkLabel, c2);
        c2.gridx = 5;
        c2.gridy = 1;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.anchor = 17;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.startLabel, c2);
        c2.gridx = 6;
        c2.gridy = 1;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.anchor = 17;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.stopLabel, c2);
        c2.gridx = 1;
        c2.gridy = 2;
        c2.gridwidth = 1;
        c2.gridheight = 5;
        c2.anchor = 17;
        c2.fill = 3;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        this.mediaGroup.addItemListener(this);
        this.linksPanel.add((Component)this.mediaGroup, c2);
        c2.gridx = 2;
        c2.gridy = 2;
        c2.gridwidth = 3;
        c2.gridheight = 5;
        c2.anchor = 17;
        c2.fill = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        this.related.addItemListener(this);
        this.linksPanel.add((Component)this.related, c2);
        c2.gridx = 5;
        c2.gridy = 2;
        c2.gridwidth = 1;
        c2.gridheight = 5;
        c2.anchor = 17;
        c2.fill = 3;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        this.start.addItemListener(this);
        this.linksPanel.add((Component)this.start, c2);
        c2.gridx = 6;
        c2.gridy = 2;
        c2.gridwidth = 1;
        c2.gridheight = 5;
        c2.anchor = 17;
        c2.fill = 3;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        this.stop.addItemListener(this);
        this.linksPanel.add((Component)this.stop, c2);
        c2.gridx = 1;
        c2.gridy = 7;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.mediaNumField, c2);
        c2.gridx = 2;
        c2.gridy = 7;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 17;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)new Label("http://"), c2);
        c2.gridx = 3;
        c2.gridy = 7;
        c2.gridwidth = 2;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 2;
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        this.linksPanel.add((Component)this.relatedField, c2);
        c2.gridx = 5;
        c2.gridy = 7;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.startField, c2);
        c2.gridx = 6;
        c2.gridy = 7;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.linksPanel.add((Component)this.stopField, c2);
        c2.gridx = 1;
        c2.gridy = 9;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.addLink.addActionListener(this);
        this.addLink.setActionCommand(this.addLinkC);
        this.linksPanel.add((Component)this.addLink, c2);
        c2.gridx = 2;
        c2.gridy = 9;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.insets = new Insets(1, 1, 1, 1);
        c2.anchor = 10;
        c2.fill = 0;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        this.delLink.addActionListener(this);
        this.delLink.setActionCommand(this.delLinkC);
        this.linksPanel.add((Component)this.delLink, c2);
        return this.linksPanel;
    }

    private void refreshLists() {
        this.mediaGroup.removeAll();
        this.related.removeAll();
        this.start.removeAll();
        this.stop.removeAll();
        if (this.newValue != null) {
            int i2 = 0;
            while (i2 < this.newValue.length) {
                this.mediaGroup.add(this.newValue[i2]);
                this.related.add(this.newValue[i2 + 1]);
                this.start.add(this.newValue[i2 + 2]);
                this.stop.add(this.newValue[i2 + 3]);
                i2 += 4;
            }
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals(this.addLinkC)) {
            this.processAdd();
        } else if (e2.getActionCommand().equals(this.delLinkC)) {
            this.deleteLink();
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        ItemSelectable o1 = e2.getItemSelectable();
        if (o1 instanceof List) {
            List l1 = (List)o1;
            int i2 = (Integer)e2.getItem();
            int state = e2.getStateChange();
            if (l1 == this.related || l1 == this.start || l1 == this.stop || l1 == this.mediaGroup) {
                l1 = this.related;
                List l2 = this.start;
                List l3 = this.stop;
                List l4 = this.mediaGroup;
                if (state == 1) {
                    l1.select(i2);
                    l2.select(i2);
                    l3.select(i2);
                    l4.select(i2);
                    this.delLink.setEnabled(true);
                } else if (state == 2) {
                    l1.deselect(i2);
                    l2.deselect(i2);
                    l3.deselect(i2);
                    l4.deselect(i2);
                    this.delLink.setEnabled(false);
                }
            }
        }
    }

    private void processAdd() {
        int mediaIndex;
        long stopTime;
        long startTime;
        StringBuffer relatedBuffer = new StringBuffer("http://");
        String mString = this.mediaNumField.getText();
        String rString = this.relatedField.getText();
        String startString = this.startField.getText();
        String stopString = this.stopField.getText();
        if (startString.equals("") && stopString.equals("")) {
            startString = new String("0");
            stopString = new String("0");
        }
        if (mString.equals("") || rString.equals("") || startString.equals("") || stopString.equals("")) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), JMFUtil.getBIString("NOVALUE"));
            return;
        }
        try {
            startTime = Long.parseLong(startString);
            stopTime = Long.parseLong(stopString);
        }
        catch (NumberFormatException numberFormatException) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("TIMES")) + ": " + JMFUtil.getBIString("0orGreater"));
            return;
        }
        try {
            mediaIndex = Integer.parseInt(mString);
        }
        catch (NumberFormatException numberFormatException) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("INDEX")) + ": " + JMFUtil.getBIString("1orGreater"));
            return;
        }
        if (startTime < 0L || stopTime < 0L) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("TIMES")) + ": " + JMFUtil.getBIString("0orGreater"));
            return;
        }
        if (mediaIndex < 1) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), String.valueOf(JMFUtil.getBIString("INDEX")) + ": " + JMFUtil.getBIString("1orGreater"));
            return;
        }
        relatedBuffer.append(rString);
        if (this.duplicate(mString, relatedBuffer.toString(), startString, stopString)) {
            DTMsgBox.createAndGo(JMFUtil.getBIString("JMF_MultiPlayer"), JMFUtil.getBIString("DUPLICATE_LINK"));
            return;
        }
        int l2 = 0;
        if (this.newValue != null) {
            l2 = this.newValue.length;
        }
        String[] temp = new String[l2 + 4];
        JMFUtil.copyStringArray(this.newValue, temp);
        temp[l2] = mString;
        temp[l2 + 1] = relatedBuffer.toString();
        temp[l2 + 2] = startString;
        temp[l2 + 3] = stopString;
        this.mediaGroup.add(temp[l2]);
        this.related.add(temp[l2 + 1]);
        this.start.add(temp[l2 + 2]);
        this.stop.add(temp[l2 + 3]);
        ((TextComponent)this.mediaNumField).setText("");
        ((TextComponent)this.relatedField).setText("");
        ((TextComponent)this.startField).setText("");
        ((TextComponent)this.stopField).setText("");
        this.setValue(temp);
    }

    private boolean duplicate(String media, String relatedS, String startS, String stopS) {
        int i2 = 0;
        while (i2 < this.mediaGroup.getItemCount()) {
            if (media.equals(this.mediaGroup.getItem(i2)) & relatedS.equals(this.related.getItem(i2)) & startS.equals(this.start.getItem(i2)) & stopS.equals(this.stop.getItem(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private void deleteLink() {
        String[] temp = null;
        int j2 = this.mediaGroup.getSelectedIndex();
        int index = j2 * 4;
        int newSize = 0;
        if (this.newValue != null && (newSize = this.newValue.length - 4) > 4) {
            temp = new String[newSize];
            JMFUtil.copyShortenStringArray(this.newValue, temp, index, 4);
        }
        this.mediaGroup.remove(j2);
        this.related.remove(j2);
        this.start.remove(j2);
        this.stop.remove(j2);
        this.delLink.setEnabled(false);
        this.setValue(temp);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

