/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

class MessageArea
extends Canvas {
    private String strMessage;
    private Insets insets = new Insets(4, 8, 4, 8);

    public MessageArea(String strMessage) {
        this.strMessage = strMessage;
    }

    public void setMessage(String strMessage) {
        this.strMessage = strMessage;
    }

    public void paint(Graphics g2) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        byte[] arrBytes = this.strMessage.getBytes();
        int nStrLength = arrBytes.length;
        int x = this.insets.left;
        int y = this.insets.top + fontMetrics.getHeight() - fontMetrics.getDescent();
        int nStart = 0;
        while (nStart < nStrLength) {
            int nEnd = nStart;
            while (nEnd < nStrLength && arrBytes[nEnd] != 13) {
                ++nEnd;
            }
            String strLine = this.strMessage.substring(nStart, nEnd);
            g2.drawString(strLine, x, y);
            y += fontMetrics.getHeight() + 3;
            nStart = nEnd + 1;
        }
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dim = new Dimension();
        if (this.strMessage != null) {
            byte[] arrBytes = this.strMessage.getBytes();
            int nStrLength = arrBytes.length;
            int nLines = 0;
            int nStart = 0;
            while (nStart < nStrLength) {
                int nEnd = nStart;
                while (nEnd < nStrLength && arrBytes[nEnd] != 13) {
                    ++nEnd;
                }
                String strLine = this.strMessage.substring(nStart, nEnd);
                int nWidth = fontMetrics.stringWidth(strLine);
                dim.width = Math.max(dim.width, nWidth);
                nStart = nEnd + 1;
                ++nLines;
            }
            dim.height = nLines * (fontMetrics.getHeight() + 3);
        }
        dim.width += this.insets.left + this.insets.right;
        dim.height += this.insets.top + this.insets.bottom;
        return dim;
    }

    public Insets getInsets() {
        return this.insets;
    }
}

