/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.controls.ControlChangeEvent;
import com.sun.media.controls.ControlChangeListener;
import com.sun.media.controls.NumericControl;
import com.sun.media.ui.AtomicComponent;
import com.sun.media.ui.SliderComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;

public class SliderComponent
extends AtomicComponent
implements ControlChangeListener {
    Image sliderWin;
    Image sliderGrab;
    int width;
    int height;
    PopupSlider popup;
    Image imageNormal;
    Image imageActive;
    Image imageDown;
    Image imageDisabled;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public SliderComponent(String imgNormal, String imgActive, String imgDown, String imgDisabled, String tip) {
        super(tip);
        this.sliderWin = AtomicComponent.fetchImage("sliderwin.gif");
        this.sliderGrab = AtomicComponent.fetchImage("slidergrab.gif");
        this.imageNormal = AtomicComponent.fetchImage(imgNormal);
        this.imageActive = AtomicComponent.fetchImage(imgActive);
        this.imageDown = AtomicComponent.fetchImage(imgDown);
        this.imageDisabled = AtomicComponent.fetchImage(imgDisabled);
        this.width = this.imageNormal.getWidth(this);
        this.height = this.imageNormal.getHeight(this);
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.addMouseListener(new 1());
    }

    public void setControl(NumericControl nc) {
        super.setControl(nc);
        nc.addControlChangeListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void paint(Graphics g2) {
        g2.setColor(Color.blue);
        Rectangle bounds = this.getBounds();
        g2.fillRect(0, 0, bounds.width, bounds.height);
    }

    public void clicked(MouseEvent e2) {
        if (this.popup == null) {
            if (securityPrivelege && jmfSecurity != null) {
                try {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 256);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                }
                catch (Exception ex) {
                    securityPrivelege = false;
                }
            }
            this.popup = new PopupSlider(this.getFrame(), this.sliderWin, this.sliderGrab);
        }
        Point p2 = this.getLocationOnScreen();
        int x = p2.x;
        int y = p2.y;
        this.popup.showAt(x += e2.getX(), y += e2.getY());
    }

    public Frame getFrame() {
        Component frame = this;
        while (!(frame instanceof Frame) && frame != null) {
            frame = frame.getParent();
        }
        if (frame == null) {
            System.out.println("No frame found in hierarchy");
            System.exit(0);
        }
        return (Frame)frame;
    }

    public void controlChanged(ControlChangeEvent e2) {
        this.repaint();
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e2) {
            SliderComponent.this.clicked(e2);
        }

        /* synthetic */ 1() {
        }
    }

    class PopupSlider
    extends Window {
        int width;
        int height;
        int inner;
        int borderY;
        int y;
        Image win;
        Image grab;

        PopupSlider(Frame parent, Image win, Image grab) {
            super(parent);
            SliderComponent.this = SliderComponent.this;
            this.win = win;
            this.grab = grab;
            this.height = 96;
            this.width = 23;
            this.borderY = 6;
            this.inner = 96 - this.borderY * 2;
            ((Component)this).setSize(this.width, this.height);
            this.addMouseListener(new 2(this));
        }

        void showAt(int x, int y) {
            this.controlToY();
            ((Component)this).setBounds(x - this.width / 2, y - this.height / 2, this.width, this.height);
            ((Component)this).setVisible(true);
            this.repaint();
        }

        void controlToY() {
            float min = ((NumericControl)SliderComponent.this.control).getLowerLimit();
            float max = ((NumericControl)SliderComponent.this.control).getUpperLimit();
            float range = max - min;
            float pos = (((NumericControl)SliderComponent.this.control).getValue() - min) / range;
            this.y = this.inner - (int)(pos * (float)this.inner);
        }

        void yToControl() {
            float min = ((NumericControl)SliderComponent.this.control).getLowerLimit();
            float max = ((NumericControl)SliderComponent.this.control).getUpperLimit();
            float range = max - min;
            float pos = (float)(this.inner - this.y) / (float)this.inner * range + min;
            ((NumericControl)SliderComponent.this.control).setValue(pos);
        }

        void selected(MouseEvent e2) {
            this.y = e2.getY() - this.borderY;
            if (this.y < 0) {
                this.y = 0;
            }
            if (this.y > this.inner) {
                this.y = this.inner;
            }
            this.repaint();
            this.yToControl();
        }

        void gone() {
            ((Component)this).setVisible(false);
        }

        public void paint(Graphics g2) {
            g2.drawImage(this.win, 0, 0, this);
            g2.drawImage(this.grab, 0, this.y - 4 + this.borderY, this);
        }
    }
}

