/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTPRawSender;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.RTPPacket;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.media.Buffer;

public class RTPTransmitter {
    RTPRawSender sender;
    SSRCCache cache;

    public RTPTransmitter(SSRCCache cache) {
        this.cache = cache;
    }

    public RTPTransmitter(SSRCCache cache, RTPRawSender sender) {
        this(cache);
        this.setSender(sender);
    }

    public RTPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address));
    }

    public RTPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTPRawSender(port, address, sender));
    }

    public void setSender(RTPRawSender s) {
        this.sender = s;
    }

    public RTPRawSender getSender() {
        return this.sender;
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    protected void transmit(RTPPacket p2) {
        try {
            this.sender.sendTo(p2);
        }
        catch (IOException iOException) {
            ++this.cache.sm.transstats.transmit_failed;
        }
    }

    public void TransmitPacket(Buffer b2, SendSSRCInfo info) {
        RTPPacket p2 = this.MakeRTPPacket(b2, info);
        if (p2 == null) {
            return;
        }
        this.transmit(p2);
        ++info.stats.total_pdu;
        info.stats.total_bytes += b2.getLength();
        ++this.cache.sm.transstats.rtp_sent;
        this.cache.sm.transstats.bytes_sent += b2.getLength();
    }

    protected RTPPacket MakeRTPPacket(Buffer b2, SendSSRCInfo info) {
        byte[] data = (byte[])b2.getData();
        if (data == null) {
            return null;
        }
        Packet p2 = new Packet();
        p2.data = data;
        p2.offset = 0;
        p2.length = data.length;
        p2.received = false;
        RTPPacket rtp = new RTPPacket(p2);
        rtp.marker = (b2.getFlags() & 0x400) != 0 ? 1 : 0;
        info.packetsize += b2.getLength();
        rtp.payloadType = info.payloadType;
        rtp.seqnum = (int)info.getSequenceNumber(b2);
        rtp.timestamp = info.getTimeStamp(b2);
        rtp.ssrc = info.ssrc;
        rtp.payloadoffset = b2.getOffset();
        rtp.payloadlength = b2.getLength();
        info.bytesreceived += b2.getLength();
        ++info.maxseq;
        info.lasttimestamp = rtp.timestamp;
        return rtp;
    }
}

