/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.processor.rtp;

import com.sun.media.BasicProcessor;
import com.sun.media.rtp.RTPMediaLocator;
import com.sun.media.rtp.RTPSessionMgr;
import java.awt.Component;
import java.io.IOException;
import java.net.InetAddress;
import javax.media.ConfigureCompleteEvent;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.StopEvent;
import javax.media.TimeBase;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.FormatChangeEvent;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPSocket;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicProcessor
implements ReceiveStreamListener {
    SessionManager mgr;
    String address;
    int port = -1;
    int ttl = 1;
    String media;
    Processor newProcessor;
    ProcessorListener listener;
    Handler mprocessor;
    Component visualComp;
    DataSource rtpsource;
    TimeBase timebase;
    Object dataLock = new Object();
    Object stateLock = new Object();
    private boolean payloadChanged = false;
    private boolean dataReceived = false;
    private boolean closed = false;
    private boolean realized = false;
    private boolean stateReached = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private Format oldFormat;
    private Format newFormat;

    public Handler() {
        this.listener = new ProcessorListener();
        this.framePositioning = false;
    }

    protected synchronized boolean doConfigure() {
        super.doConfigure();
        try {
            this.mgr = this.source instanceof RTPSocket ? new RTPSessionMgr((RTPSocket)this.source) : new RTPSessionMgr((com.sun.media.protocol.rtp.DataSource)this.source);
            if (this.mgr == null) {
                return false;
            }
            this.mgr.addReceiveStreamListener(this);
            if (!(this.source instanceof RTPSocket)) {
                InetAddress destaddr = InetAddress.getByName(this.address);
                SessionAddress sessaddr = new SessionAddress(destaddr, this.port, destaddr, this.port + 1);
                this.mgr.startSession(sessaddr, this.ttl, null);
            }
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
            return false;
        }
        return true;
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    protected void completeConfigure() {
        try {
            Object object = this.dataLock;
            synchronized (object) {
                while (!this.dataReceived) {
                    this.dataLock.wait();
                }
            }
        }
        catch (Exception exception) {}
        if (this.newProcessor != null) {
            this.manageController(this.newProcessor);
        }
        super.completeConfigure();
    }

    protected void completeRealize() {
        block9: {
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    while (!this.realized) {
                        this.stateLock.wait();
                    }
                }
            }
            catch (Exception exception) {}
            super.completeRealize();
            if (this.newProcessor == null) break block9;
            try {
                this.timebase = this.newProcessor.getTimeBase();
                this.mprocessor.setTimeBase(this.timebase);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {}
        }
    }

    public void update(ReceiveStreamEvent event) {
        if (event instanceof RemotePayloadChangeEvent) {
            System.out.println("Received a PayloadChangeEvent");
            System.out.println("Please wait till new player is created....");
            RTPControl ctl = (RTPControl)this.rtpsource.getControl("javax.media.rtp.RTPControl");
            if (ctl != null) {
                this.newFormat = ctl.getFormat();
            }
            this.payloadChanged = true;
            if (this.newProcessor != null) {
                this.waitForStop(this.mprocessor);
                this.unmanageController(this.newProcessor);
                this.newProcessor.close();
                Object object = this.stateLock;
                synchronized (object) {
                    try {
                        while (!this.closed) {
                            this.stateLock.wait();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            try {
                this.rtpsource.connect();
                this.newProcessor = Manager.createProcessor(this.rtpsource);
                if (this.newProcessor == null) {
                    System.err.println("Could not create player for new payload");
                    return;
                }
                this.newProcessor.addControllerListener(this.listener);
                this.newProcessor.configure();
                this.closed = false;
                this.stateReached = false;
            }
            catch (Exception exception) {
                System.err.println("could not create player for new payload");
            }
        }
        if (event instanceof NewReceiveStreamEvent) {
            String cname = "Java Media Processor";
            ReceiveStream stream = null;
            if (this.newProcessor != null) {
                return;
            }
            try {
                stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                Participant part = stream.getParticipant();
                if (part != null) {
                    cname = part.getCNAME();
                }
                this.rtpsource = stream.getDataSource();
                RTPControl ctl = (RTPControl)this.rtpsource.getControl("javax.media.rtp.RTPControl");
                if (ctl != null) {
                    this.oldFormat = ctl.getFormat();
                    if (this.oldFormat instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.oldFormat instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                if (this.source instanceof RTPSocket) {
                    ((RTPSocket)this.source).setChild(this.rtpsource);
                } else {
                    ((com.sun.media.protocol.rtp.DataSource)this.source).setChild((com.sun.media.protocol.rtp.DataSource)this.rtpsource);
                }
                this.newProcessor = Manager.createProcessor(this.rtpsource);
                if (this.newProcessor == null) {
                    return;
                }
                this.newProcessor.addControllerListener(this.listener);
                this.newProcessor.configure();
                this.mprocessor = this;
            }
            catch (Exception e3) {
                System.err.println("NewReceiveStreamEvent exception " + e3.getMessage());
                return;
            }
        }
    }

    private synchronized boolean waitForStop(Processor p2) {
        StateListener t = null;
        if (p2.getState() != 600) {
            return true;
        }
        t = new StateListener();
        p2.addControllerListener(t);
        p2.stop();
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.stateReached) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        p2.removeControllerListener(t);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        if (source instanceof com.sun.media.protocol.rtp.DataSource) {
            MediaLocator ml = source.getLocator();
            try {
                RTPMediaLocator mrl = new RTPMediaLocator(ml.toString());
                this.address = mrl.getSessionAddress();
                this.port = mrl.getSessionPort();
                this.ttl = mrl.getTTL();
                this.media = mrl.getContentType();
                RTPControl ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl");
                if (ctl == null) return;
                ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
                return;
            }
            catch (Exception exception) {
                throw new IncompatibleSourceException();
            }
        } else {
            if (!(source instanceof RTPSocket)) throw new IncompatibleSourceException();
            RTPControl ctl = (RTPControl)source.getControl("javax.media.rtp.RTPControl");
            if (ctl == null) return;
            ctl.addFormat(new AudioFormat("dvi/rtp", 44100.0, 4, 1), 18);
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.visualComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        if (this.newProcessor != null) {
            return this.newProcessor.getVisualComponent();
        }
        return this.visualComp;
    }

    protected TimeBase getMasterTimeBase() {
        return this.timebase;
    }

    public void updateStats() {
        if (this.newProcessor != null) {
            ((BasicProcessor)this.newProcessor).updateStats();
        }
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        super.getTrackControls();
        return this.newProcessor.getTrackControls();
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        super.getSupportedContentDescriptors();
        return this.newProcessor.getSupportedContentDescriptors();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor ocd) throws NotConfiguredError {
        super.setContentDescriptor(ocd);
        return this.newProcessor.setContentDescriptor(ocd);
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        super.getContentDescriptor();
        return this.newProcessor.getContentDescriptor();
    }

    public DataSource getDataOutput() throws NotRealizedError {
        super.getDataOutput();
        return this.newProcessor.getDataOutput();
    }

    protected void foo(Controller c2) {
        super.unmanageController(c2);
    }

    static /* synthetic */ boolean access$0(Handler $0) {
        return $0.dataReceived;
    }

    static /* synthetic */ boolean access$10(Handler $0) {
        return $0.realized;
    }

    static /* synthetic */ boolean access$12(Handler $0) {
        return $0.closed;
    }

    static /* synthetic */ boolean access$14(Handler $0) {
        return $0.stateReached;
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof StopEvent) {
                Object object = Handler.this.stateLock;
                synchronized (object) {
                    Handler.this.stateReached = true;
                    Handler.this.stateLock.notifyAll();
                }
            }
        }

        StateListener() {
            Handler.this = Handler.this;
        }
    }

    public class ProcessorListener
    implements ControllerListener {
        public synchronized void controllerUpdate(ControllerEvent ce) {
            Object object;
            Processor p2 = (Processor)ce.getSourceController();
            if (ce instanceof ConfigureCompleteEvent) {
                object = Handler.this.dataLock;
                synchronized (object) {
                    Handler.this.dataReceived = true;
                    Handler.this.dataLock.notifyAll();
                }
            }
            if (ce instanceof RealizeCompleteEvent) {
                Handler.this.visualComp = p2.getVisualComponent();
                if (Handler.this.payloadChanged) {
                    try {
                        if (Handler.this.mprocessor.getState() > 300) {
                            Handler.this.timebase = p2.getTimeBase();
                            Handler.this.mprocessor.setTimeBase(Handler.this.timebase);
                        }
                        Handler.this.mprocessor.invalidateComp();
                        FormatChangeEvent f2 = new FormatChangeEvent(Handler.this.mprocessor, Handler.this.oldFormat, Handler.this.newFormat);
                        Handler.this.mprocessor.sendMyEvent(f2);
                        Handler.this.oldFormat = Handler.this.newFormat;
                        Handler.this.newFormat = null;
                        Handler.this.payloadChanged = false;
                    }
                    catch (Exception e2) {
                        e2.getMessage();
                    }
                }
                object = Handler.this.stateLock;
                synchronized (object) {
                    Handler.this.realized = true;
                    Handler.this.stateLock.notifyAll();
                }
            }
            if (ce instanceof ControllerErrorEvent) {
                Handler.this.visualComp = null;
                Handler.this.newProcessor.removeControllerListener(this);
                if (Handler.this.mprocessor.getState() > 300) {
                    Handler.this.mprocessor.foo(Handler.this.newProcessor);
                }
                Handler.this.newProcessor.close();
                Handler.this.newProcessor = null;
            }
            if (ce instanceof ControllerClosedEvent) {
                Handler.this.newProcessor = null;
                object = Handler.this.stateLock;
                synchronized (object) {
                    Handler.this.closed = true;
                    Handler.this.stateLock.notifyAll();
                }
                System.gc();
                System.runFinalization();
            }
        }

        public ProcessorListener() {
            Handler.this = Handler.this;
        }
    }
}

