/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.video;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.util.SettableTime;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class QuicktimeParser
extends BasicPullParser {
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("video.quicktime")};
    private PullSourceStream stream;
    private Track[] tracks;
    private Seekable seekableStream;
    private boolean mdatAtomPresent = false;
    private boolean moovAtomPresent = false;
    public static final int MVHD_ATOM_SIZE = 100;
    public static final int TKHD_ATOM_SIZE = 84;
    public static final int MDHD_ATOM_SIZE = 24;
    public static final int MIN_HDLR_ATOM_SIZE = 24;
    public static final int MIN_STSD_ATOM_SIZE = 8;
    public static final int MIN_STTS_ATOM_SIZE = 8;
    public static final int MIN_STSC_ATOM_SIZE = 8;
    public static final int MIN_STSZ_ATOM_SIZE = 8;
    public static final int MIN_STCO_ATOM_SIZE = 8;
    public static final int MIN_STSS_ATOM_SIZE = 8;
    public static final int MIN_VIDEO_SAMPLE_DATA_SIZE = 70;
    public static final int MIN_AUDIO_SAMPLE_DATA_SIZE = 20;
    public static final int TRACK_ENABLED = 1;
    public static final int TRACK_IN_MOVIE = 2;
    public static final int TRACK_IN_PREVIEW = 4;
    public static final int TRACK_IN_POSTER = 8;
    public static final String VIDEO = "vide";
    public static final String AUDIO = "soun";
    private static final int DATA_SELF_REFERENCE_FLAG = 1;
    private MovieHeader movieHeader = new MovieHeader();
    private int numTracks;
    private int numSupportedTracks;
    private static int MAX_TRACKS_SUPPORTED = 100;
    private TrakList[] trakList = new TrakList[MAX_TRACKS_SUPPORTED];
    private TrakList currentTrack;
    private int keyFrameTrack = -1;
    private SettableTime mediaTime = new SettableTime(0L);
    private Object seekSync = new Object();

    protected boolean supports(SourceStream[] s) {
        return this.seekable;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        this.stream = (PullSourceStream)this.streams[0];
        this.seekableStream = (Seekable)((Object)this.streams[0]);
    }

    private CachedStream getCacheStream() {
        return this.cacheStream;
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks != null) {
            return this.tracks;
        }
        if (this.seekableStream == null) {
            return new Track[0];
        }
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.tracks = new Track[this.numSupportedTracks];
        int i2 = 0;
        while (i2 < this.tracks.length) {
            TrakList trakInfo = this.trakList[i2];
            if (trakInfo.trackType.equals(AUDIO)) {
                this.tracks[i2] = new AudioTrack(trakInfo);
            } else if (trakInfo.trackType.equals(VIDEO)) {
                this.tracks[i2] = new VideoTrack(trakInfo);
            }
            ++i2;
        }
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        while (this.parseAtom()) {
        }
        if (!this.moovAtomPresent) {
            throw new BadHeaderException("moov atom not present");
        }
        if (!this.mdatAtomPresent) {
            throw new BadHeaderException("mdat atom not present");
        }
        int i2 = 0;
        while (i2 < this.numSupportedTracks) {
            TrakList trak = this.trakList[i2];
            if (trak.buildSyncTable()) {
                this.keyFrameTrack = i2;
            }
            trak.buildSamplePerChunkTable();
            if (trak.trackType.equals(VIDEO)) {
                float frameRate;
                trak.buildSampleOffsetTable();
                trak.buildStartTimeAndDurationTable();
                ((Video)trak.media).frameRate = frameRate = (float)((double)trak.numberOfSamples / trak.duration.getSeconds());
            }
            trak.buildCumulativeSamplePerChunkTable();
            trak.media.createFormat();
            ++i2;
        }
    }

    public Time setPosition(Time where, int rounding) {
        double time = where.getSeconds();
        if (this.keyFrameTrack != -1) {
            int syncIndex;
            TrakList trakInfo = this.trakList[this.keyFrameTrack];
            int index = trakInfo.time2Index(time);
            if (index >= trakInfo.syncSampleMapping.length) {
                index = trakInfo.syncSampleMapping.length - 1;
            }
            if (trakInfo.syncSampleMapping != null) {
                double newtime;
                syncIndex = trakInfo.syncSampleMapping[index];
                time = newtime = trakInfo.index2TimeAndDuration((int)syncIndex).startTime;
            } else {
                syncIndex = index;
            }
            ((MediaTrack)this.tracks[this.keyFrameTrack]).setSampleIndex(syncIndex);
        }
        int i2 = 0;
        while (i2 < this.numSupportedTracks) {
            if (i2 != this.keyFrameTrack) {
                TrakList trakInfo = this.trakList[i2];
                int index = trakInfo.time2Index(time);
                if (trakInfo.trackType.equals(VIDEO)) {
                    int syncIndex = trakInfo.syncSampleMapping != null ? trakInfo.syncSampleMapping[index] : index;
                    ((MediaTrack)this.tracks[i2]).setSampleIndex(syncIndex);
                } else {
                    ((MediaTrack)this.tracks[i2]).setSampleIndex(index);
                    int chunkNumber = trakInfo.index2Chunk(index);
                    int sampleOffsetInChunk = chunkNumber != 0 ? (trakInfo.constantSamplesPerChunk == -1 ? index - trakInfo.samplesPerChunk[chunkNumber - 1] : index - chunkNumber * trakInfo.constantSamplesPerChunk) : index;
                    ((AudioTrack)this.tracks[i2]).setChunkNumberAndSampleOffset(chunkNumber, sampleOffsetInChunk);
                }
            }
            ++i2;
        }
        if (this.cacheStream != null) {
            QuicktimeParser quicktimeParser = this;
            synchronized (quicktimeParser) {
                this.cacheStream.abortRead();
            }
        }
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set(time);
        }
        return this.mediaTime;
    }

    public Time getMediaTime() {
        return null;
    }

    public Time getDuration() {
        return this.movieHeader.duration;
    }

    public String getName() {
        return "Parser for quicktime file format";
    }

    private boolean parseAtom() throws BadHeaderException {
        boolean readSizeField = false;
        try {
            int atomSize = this.readInt(this.stream);
            readSizeField = true;
            String atom = this.readString(this.stream);
            if (atomSize < 8) {
                throw new BadHeaderException(String.valueOf(atom) + ": Bad Atom size " + atomSize);
            }
            if (atom.equals("moov")) {
                return this.parseMOOV(atomSize - 8);
            }
            if (atom.equals("mdat")) {
                return this.parseMDAT(atomSize - 8);
            }
            this.skipAtom(String.valueOf(atom) + " [not implemented]", atomSize - 8);
            return true;
        }
        catch (IOException iOException) {
            if (!readSizeField) {
                return false;
            }
            throw new BadHeaderException("Unexpected End of Media");
        }
    }

    private void skipAtom(String atom, int size) throws IOException {
        this.skip(this.stream, size);
    }

    private boolean parseMOOV(int moovSize) throws BadHeaderException {
        boolean trakAtomPresent = false;
        try {
            this.moovAtomPresent = true;
            long moovMax = this.getLocation(this.stream) + (long)moovSize;
            int remainingSize = moovSize;
            int atomSize = this.readInt(this.stream);
            String atom = this.readString(this.stream);
            if (atomSize < 8) {
                throw new BadHeaderException(String.valueOf(atom) + ": Bad Atom size " + atomSize);
            }
            if (!atom.equals("mvhd")) {
                throw new BadHeaderException("Expected mvhd atom but got " + atom);
            }
            this.parseMVHD(atomSize - 8);
            remainingSize -= atomSize;
            while (remainingSize > 0) {
                atomSize = this.readInt(this.stream);
                atom = this.readString(this.stream);
                if (atom.equals("trak")) {
                    if (this.trakList[this.numSupportedTracks] == null) {
                        this.trakList[this.numSupportedTracks] = this.currentTrack = new TrakList();
                    }
                    if (this.parseTRAK(atomSize - 8)) {
                        ++this.numSupportedTracks;
                    }
                    trakAtomPresent = true;
                    ++this.numTracks;
                } else if (atom.equals("ctab")) {
                    this.parseCTAB(atomSize - 8);
                } else {
                    this.skipAtom(String.valueOf(atom) + " [atom in moov: not implemented]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
            if (!trakAtomPresent) {
                throw new BadHeaderException("trak atom not present in trak atom container");
            }
            return !this.mdatAtomPresent;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing the header");
        }
    }

    private boolean parseMDAT(int size) throws BadHeaderException {
        try {
            this.mdatAtomPresent = true;
            this.movieHeader.mdatStart = this.getLocation(this.stream);
            this.movieHeader.mdatSize = size;
            if (!this.moovAtomPresent) {
                this.skip(this.stream, size);
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDAT atom");
        }
    }

    private void parseMVHD(int size) throws BadHeaderException {
        try {
            if (size != 100) {
                throw new BadHeaderException("mvhd atom: header size is incorrect");
            }
            this.skip(this.stream, 12);
            this.movieHeader.timeScale = this.readInt(this.stream);
            int duration = this.readInt(this.stream);
            this.movieHeader.duration = new Time((double)duration / (double)this.movieHeader.timeScale);
            int preferredRate = this.readInt(this.stream);
            int preferredVolume = this.readShort(this.stream);
            this.skip(this.stream, 10);
            this.skip(this.stream, 36);
            int previewTime = this.readInt(this.stream);
            int previewDuration = this.readInt(this.stream);
            int posterTime = this.readInt(this.stream);
            int selectionTime = this.readInt(this.stream);
            int selectionDuration = this.readInt(this.stream);
            int currentTime = this.readInt(this.stream);
            int nextTrackID = this.readInt(this.stream);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MVHD atom");
        }
    }

    private boolean parseTRAK(int trakSize) throws BadHeaderException {
        boolean mdiaAtomPresent = false;
        boolean supported = false;
        try {
            int remainingSize = trakSize;
            int atomSize = this.readInt(this.stream);
            String atom = this.readString(this.stream);
            if (atomSize < 8) {
                throw new BadHeaderException(String.valueOf(atom) + ": Bad Atom size " + atomSize);
            }
            if (!atom.equals("tkhd")) {
                throw new BadHeaderException("Expected tkhd atom but got " + atom);
            }
            this.parseTKHD(atomSize - 8);
            remainingSize -= atomSize;
            while (remainingSize > 0) {
                atomSize = this.readInt(this.stream);
                atom = this.readString(this.stream);
                if (atom.equals("mdia")) {
                    supported = this.parseMDIA(atomSize - 8);
                    mdiaAtomPresent = true;
                } else {
                    this.skipAtom(String.valueOf(atom) + " [atom in trak: not implemented]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past TRAK atom");
        }
        if (!mdiaAtomPresent) {
            throw new BadHeaderException("mdia atom not present in trak atom container");
        }
        if (supported && this.currentTrack.media == null) {
            supported = false;
        }
        return supported;
    }

    private void parseCTAB(int ctabSize) throws BadHeaderException {
        try {
            this.skip(this.stream, ctabSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("....");
        }
    }

    private void parseTKHD(int tkhdSize) throws BadHeaderException {
        try {
            if (tkhdSize != 84) {
                throw new BadHeaderException("mvhd atom: header size is incorrect");
            }
            int iVersionPlusFlag = this.readInt(this.stream);
            this.currentTrack.flag = iVersionPlusFlag & 0xFFFFFF;
            this.skip(this.stream, 8);
            this.currentTrack.id = this.readInt(this.stream);
            this.skip(this.stream, 4);
            int duration = this.readInt(this.stream);
            this.currentTrack.duration = new Time((double)duration / (double)this.movieHeader.timeScale);
            this.skip(this.stream, tkhdSize - 4 - 8 - 4 - 4 - 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past TKHD atom");
        }
    }

    private boolean parseMDIA(int mdiaSize) throws BadHeaderException {
        boolean hdlrAtomPresent = false;
        boolean minfAtomPresent = false;
        try {
            this.currentTrack.trackType = null;
            int remainingSize = mdiaSize;
            int atomSize = this.readInt(this.stream);
            String atom = this.readString(this.stream);
            if (atomSize < 8) {
                throw new BadHeaderException(String.valueOf(atom) + ": Bad Atom size " + atomSize);
            }
            if (!atom.equals("mdhd")) {
                throw new BadHeaderException("Expected mdhd atom but got " + atom);
            }
            this.parseMDHD(atomSize - 8);
            remainingSize -= atomSize;
            while (remainingSize > 0) {
                atomSize = this.readInt(this.stream);
                atom = this.readString(this.stream);
                if (atom.equals("hdlr")) {
                    this.parseHDLR(atomSize - 8);
                    hdlrAtomPresent = true;
                } else if (atom.equals("minf")) {
                    if (this.currentTrack.trackType == null) {
                        throw new BadHeaderException("In MDIA atom container minf atom appears before hdlr");
                    }
                    if (this.currentTrack.supported) {
                        this.parseMINF(atomSize - 8);
                    } else {
                        this.skipAtom(String.valueOf(atom) + " [atom in mdia] as trackType " + this.currentTrack.trackType + " is not supported", atomSize - 8);
                    }
                    minfAtomPresent = true;
                } else {
                    this.skipAtom(String.valueOf(atom) + " [atom in mdia: not implemented]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
            if (!hdlrAtomPresent) {
                throw new BadHeaderException("hdlr atom not present in mdia atom container");
            }
            if (!minfAtomPresent) {
                throw new BadHeaderException("minf atom not present in mdia atom container");
            }
            return this.currentTrack.supported;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDIA atom");
        }
    }

    private void parseMDHD(int mdhdSize) throws BadHeaderException {
        try {
            if (mdhdSize != 24) {
                throw new BadHeaderException("mdhd atom: header size is incorrect");
            }
            this.skip(this.stream, 12);
            int timeScale = this.readInt(this.stream);
            int duration = this.readInt(this.stream);
            this.currentTrack.mediaDuration = new Time((double)duration / (double)timeScale);
            this.currentTrack.mediaTimeScale = timeScale;
            this.skip(this.stream, 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MDHD atom");
        }
    }

    private void parseHDLR(int hdlrSize) throws BadHeaderException {
        try {
            if (hdlrSize < 24) {
                throw new BadHeaderException("hdlr atom: header size is incorrect");
            }
            this.skip(this.stream, 8);
            this.currentTrack.trackType = this.readString(this.stream);
            this.currentTrack.supported = this.isSupported(this.currentTrack.trackType);
            this.skip(this.stream, hdlrSize - 8 - 4);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past HDLR atom");
        }
    }

    private void parseMINF(int minfSize) throws BadHeaderException {
        boolean hdlrAtomPresent = false;
        try {
            int remainingSize = minfSize;
            int atomSize = this.readInt(this.stream);
            String atom = this.readString(this.stream);
            if (atomSize < 8) {
                throw new BadHeaderException(String.valueOf(atom) + ": Bad Atom size " + atomSize);
            }
            if (!atom.endsWith("hd")) {
                throw new BadHeaderException("Expected media information header atom but got " + atom);
            }
            this.skipAtom(String.valueOf(atom) + " [atom in minf: not implemented]", atomSize - 8);
            remainingSize -= atomSize;
            while (remainingSize > 0) {
                atomSize = this.readInt(this.stream);
                atom = this.readString(this.stream);
                if (atom.equals("hdlr")) {
                    this.skipAtom(String.valueOf(atom) + " [atom in minf: not implemented]", atomSize - 8);
                    hdlrAtomPresent = true;
                } else if (atom.equals("dinf")) {
                    this.parseDINF(atomSize - 8);
                } else if (atom.equals("stbl")) {
                    this.parseSTBL(atomSize - 8);
                } else {
                    this.skipAtom(String.valueOf(atom) + " [atom in minf: not implemented]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
            if (!hdlrAtomPresent) {
                throw new BadHeaderException("hdlr atom not present in minf atom container");
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past MINF atom");
        }
    }

    private void parseDINF(int dinfSize) throws BadHeaderException {
        try {
            int remainingSize = dinfSize;
            while (remainingSize > 0) {
                int atomSize = this.readInt(this.stream);
                String atom = this.readString(this.stream);
                if (atom.equals("dref")) {
                    this.parseDREF(atomSize - 8);
                } else {
                    this.skipAtom(String.valueOf(atom) + " [Unknown atom in dinf]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past DIMF atom");
        }
    }

    private void parseDREF(int drefSize) throws BadHeaderException {
        try {
            this.skip(this.stream, 4);
            int numEntries = this.readInt(this.stream);
            int i2 = 0;
            while (i2 < numEntries) {
                int drefEntrySize = this.readInt(this.stream);
                int type = this.readInt(this.stream);
                int versionPlusFlag = this.readInt(this.stream);
                this.skip(this.stream, drefEntrySize - 12);
                if ((versionPlusFlag & 1) <= 0) {
                    throw new BadHeaderException("Only self contained Quicktime movies are supported");
                }
                ++i2;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past DREF atom");
        }
    }

    private void parseSTBL(int stblSize) throws BadHeaderException {
        try {
            int remainingSize = stblSize;
            while (remainingSize > 0) {
                int atomSize = this.readInt(this.stream);
                String atom = this.readString(this.stream);
                if (atom.equals("stsd")) {
                    this.parseSTSD(atomSize - 8);
                } else if (atom.equals("stts")) {
                    this.parseSTTS(atomSize - 8);
                } else if (atom.equals("stss")) {
                    this.parseSTSS(atomSize - 8);
                } else if (atom.equals("stsc")) {
                    this.parseSTSC(atomSize - 8);
                } else if (atom.equals("stsz")) {
                    this.parseSTSZ(atomSize - 8);
                } else if (atom.equals("stco")) {
                    this.parseSTCO(atomSize - 8);
                } else if (atom.equals("stsh")) {
                    this.skipAtom(String.valueOf(atom) + " [not implemented]", atomSize - 8);
                } else {
                    this.skipAtom(String.valueOf(atom) + " [UNKNOWN atom in stbl: ignored]", atomSize - 8);
                }
                remainingSize -= atomSize;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STBL atom");
        }
    }

    private void parseSTSD(int stsdSize) throws BadHeaderException {
        try {
            if (stsdSize < 8) {
                throw new BadHeaderException("stsd atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int numEntries = this.readInt(this.stream);
            if (numEntries > 1) {
                System.err.println("Multiple formats in a track not supported");
            }
            int i2 = 0;
            while (i2 < numEntries) {
                int sampleDescriptionSize = this.readInt(this.stream);
                String encoding = this.readString(this.stream);
                if (i2 != 0) {
                    this.skip(this.stream, sampleDescriptionSize - 8);
                } else {
                    this.skip(this.stream, 8);
                    if (this.currentTrack.trackType.equals(VIDEO)) {
                        this.currentTrack.media = this.parseVideoSampleData(encoding, sampleDescriptionSize - 4 - 4 - 8);
                    } else if (this.currentTrack.trackType.equals(AUDIO)) {
                        this.currentTrack.media = this.parseAudioSampleData(encoding, sampleDescriptionSize - 4 - 4 - 8);
                    } else {
                        this.skip(this.stream, sampleDescriptionSize - 4 - 4 - 8);
                    }
                }
                ++i2;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSD atom");
        }
    }

    private Video parseVideoSampleData(String encoding, int dataSize) throws IOException, BadHeaderException {
        this.skip(this.stream, 16);
        Video video = new Video();
        video.encoding = encoding;
        video.width = this.readShort(this.stream);
        video.height = this.readShort(this.stream);
        this.skip(this.stream, 14);
        this.skip(this.stream, 32);
        video.pixelDepth = this.readShort(this.stream);
        video.colorTableID = this.readShort(this.stream);
        int colorTableSize = 0;
        if (video.colorTableID == 0) {
            colorTableSize = this.readInt(this.stream);
            this.skip(this.stream, colorTableSize - 4);
        }
        this.skip(this.stream, dataSize - 70 - -colorTableSize);
        return video;
    }

    private Audio parseAudioSampleData(String encoding, int dataSize) throws IOException, BadHeaderException {
        this.skip(this.stream, 8);
        Audio audio = new Audio();
        audio.encoding = encoding;
        audio.channels = this.readShort(this.stream);
        audio.bitsPerSample = this.readShort(this.stream);
        this.skip(this.stream, 4);
        int sampleRate = this.readInt(this.stream);
        audio.sampleRate = this.currentTrack.mediaTimeScale;
        this.skip(this.stream, dataSize - 20);
        return audio;
    }

    private void parseSTTS(int sttsSize) throws BadHeaderException {
        try {
            if (sttsSize < 8) {
                throw new BadHeaderException("stts atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int numEntries = this.readInt(this.stream);
            int requiredSize = sttsSize - 8 - numEntries * 8;
            if (requiredSize < 0) {
                throw new BadHeaderException("stts atom: inconsistent number_of_entries field");
            }
            int totalNumSamples = 0;
            double timeScaleFactor = 1.0 / (double)this.currentTrack.mediaTimeScale;
            if (numEntries == 1) {
                totalNumSamples = this.readInt(this.stream);
                this.currentTrack.durationOfSamples = (double)this.readInt(this.stream) * timeScaleFactor;
            } else {
                int[] timeToSampleIndices = new int[numEntries];
                double[] durations = new double[numEntries];
                timeToSampleIndices[0] = this.readInt(this.stream);
                totalNumSamples += timeToSampleIndices[0];
                durations[0] = (double)this.readInt(this.stream) * timeScaleFactor * (double)timeToSampleIndices[0];
                int i2 = 1;
                while (i2 < numEntries) {
                    timeToSampleIndices[i2] = this.readInt(this.stream);
                    int n2 = i2;
                    durations[n2] = durations[n2] + ((double)this.readInt(this.stream) * timeScaleFactor * (double)timeToSampleIndices[i2] + durations[i2 - 1]);
                    timeToSampleIndices[i2] = totalNumSamples += timeToSampleIndices[i2];
                    ++i2;
                }
                this.currentTrack.timeToSampleIndices = timeToSampleIndices;
                this.currentTrack.cumulativeDurationOfSamples = durations;
            }
            if (this.currentTrack.numberOfSamples == 0) {
                this.currentTrack.numberOfSamples = totalNumSamples;
            }
            this.skip(this.stream, requiredSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STTS atom");
        }
    }

    private void parseSTSC(int stscSize) throws BadHeaderException {
        try {
            if (stscSize < 8) {
                throw new BadHeaderException("stsc atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int numEntries = this.readInt(this.stream);
            int requiredSize = stscSize - 8 - numEntries * 12;
            if (requiredSize < 0) {
                throw new BadHeaderException("stsc atom: inconsistent number_of_entries field");
            }
            int[] compactSamplesChunkNum = new int[numEntries];
            int[] compactSamplesPerChunk = new int[numEntries];
            int i2 = 0;
            while (i2 < numEntries) {
                compactSamplesChunkNum[i2] = this.readInt(this.stream);
                compactSamplesPerChunk[i2] = this.readInt(this.stream);
                int sampleDescriptionId = this.readInt(this.stream);
                ++i2;
            }
            this.currentTrack.compactSamplesChunkNum = compactSamplesChunkNum;
            this.currentTrack.compactSamplesPerChunk = compactSamplesPerChunk;
            this.skip(this.stream, requiredSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSC atom");
        }
    }

    private void parseSTSZ(int stszSize) throws BadHeaderException {
        try {
            int requiredSize;
            if (stszSize < 8) {
                throw new BadHeaderException("stsz atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            this.currentTrack.sampleSize = this.readInt(this.stream);
            if (this.currentTrack.sampleSize != 0) {
                this.skip(this.stream, stszSize - 8);
                this.currentTrack.media.maxSampleSize = this.currentTrack.sampleSize;
                return;
            }
            if (stszSize - 8 < 4) {
                throw new BadHeaderException("stsz atom: incorrect atom size");
            }
            int numEntries = this.readInt(this.stream);
            if (this.currentTrack.numberOfSamples == 0) {
                this.currentTrack.numberOfSamples = numEntries;
            }
            if ((requiredSize = stszSize - 8 - 4 - numEntries * 4) < 0) {
                throw new BadHeaderException("stsz atom: inconsistent number_of_entries field");
            }
            int[] sampleSizeArray = new int[numEntries];
            int maxSampleSize = Integer.MIN_VALUE;
            int i2 = 0;
            while (i2 < numEntries) {
                int value = this.readInt(this.stream);
                if (value > maxSampleSize) {
                    maxSampleSize = value;
                }
                sampleSizeArray[i2] = value;
                ++i2;
            }
            this.currentTrack.sampleSizeArray = sampleSizeArray;
            this.currentTrack.media.maxSampleSize = maxSampleSize;
            this.skip(this.stream, requiredSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSZ atom");
        }
    }

    private void parseSTCO(int stcoSize) throws BadHeaderException {
        try {
            int numEntries;
            if (stcoSize < 8) {
                throw new BadHeaderException("stco atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            this.currentTrack.numberOfChunks = numEntries = this.readInt(this.stream);
            int[] chunkOffsets = new int[numEntries];
            int requiredSize = stcoSize - 8 - numEntries * 4;
            if (requiredSize < 0) {
                throw new BadHeaderException("stco atom: inconsistent number_of_entries field");
            }
            int i2 = 0;
            while (i2 < numEntries) {
                chunkOffsets[i2] = this.readInt(this.stream);
                ++i2;
            }
            this.currentTrack.chunkOffsets = chunkOffsets;
            this.skip(this.stream, requiredSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STCO atom");
        }
    }

    private void parseSTSS(int stssSize) throws BadHeaderException {
        try {
            if (stssSize < 8) {
                throw new BadHeaderException("stss atom: header size is incorrect");
            }
            this.skip(this.stream, 4);
            int numEntries = this.readInt(this.stream);
            int requiredSize = stssSize - 8 - numEntries * 4;
            if (requiredSize < 0) {
                throw new BadHeaderException("stss atom: inconsistent number_of_entries field");
            }
            if (numEntries < 1) {
                this.skip(this.stream, requiredSize);
                return;
            }
            int[] syncSamples = new int[numEntries];
            int i2 = 0;
            while (i2 < numEntries) {
                syncSamples[i2] = this.readInt(this.stream);
                ++i2;
            }
            this.currentTrack.syncSamples = syncSamples;
            this.skip(this.stream, requiredSize);
        }
        catch (IOException iOException) {
            throw new BadHeaderException("Got IOException when seeking past STSS atom");
        }
    }

    private boolean isSupported(String trackType) {
        return trackType.equals(VIDEO) || trackType.equals(AUDIO);
    }

    static /* synthetic */ CachedStream access$0(QuicktimeParser $0) {
        return $0.getCacheStream();
    }

    private class MovieHeader {
        int timeScale;
        Time duration = Duration.DURATION_UNKNOWN;
        long mdatStart;
        long mdatSize;

        MovieHeader() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }

    private abstract class Media {
        String encoding;
        int maxSampleSize;

        abstract Format createFormat();

        Media() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }

    private class Audio
    extends Media {
        int channels;
        int bitsPerSample;
        int sampleRate;
        AudioFormat format;
        int frameSizeInBits;
        int samplesPerBlock = 1;

        public String toString() {
            String info = "Audio: " + this.format + "\n";
            info = String.valueOf(info) + "encoding is " + this.encoding + "\n";
            info = String.valueOf(info) + "Number of channels " + this.channels + "\n";
            info = String.valueOf(info) + "Bits per sample " + this.bitsPerSample + "\n";
            info = String.valueOf(info) + "sampleRate " + this.sampleRate + "\n";
            return info;
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String encodingString = null;
            boolean signed = true;
            boolean bigEndian = true;
            if (this.encoding.equals("ulaw") || this.encoding.equals("alaw")) {
                this.bitsPerSample = 8;
            }
            this.frameSizeInBits = this.channels * this.bitsPerSample;
            if (this.encoding.equals("ulaw")) {
                encodingString = "ULAW";
                signed = false;
            } else if (this.encoding.equals("alaw")) {
                encodingString = "alaw";
                signed = false;
            } else if (this.encoding.equals("twos")) {
                encodingString = "LINEAR";
            } else if (this.encoding.equals("ima4")) {
                encodingString = "ima4";
                this.samplesPerBlock = 64;
                this.frameSizeInBits = 34 * this.channels * 8;
            } else if (this.encoding.equals("raw ")) {
                encodingString = "LINEAR";
                signed = false;
            } else if (this.encoding.equals("agsm")) {
                encodingString = "gsm";
                this.samplesPerBlock = 33;
                this.frameSizeInBits = 264;
            } else {
                encodingString = this.encoding.equals("mac3") ? "MAC3" : (this.encoding.equals("mac6") ? "MAC6" : this.encoding);
            }
            this.format = new AudioFormat(encodingString, this.sampleRate, this.bitsPerSample, this.channels, bigEndian ? 1 : 0, signed ? 1 : 0, this.frameSizeInBits, -1.0, Format.byteArray);
            return this.format;
        }

        Audio() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }

    private class Video
    extends Media {
        int width;
        int height;
        int pixelDepth;
        int colorTableID;
        VideoFormat format;
        float frameRate;

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            if (this.encoding.toLowerCase().startsWith("raw")) {
                this.encoding = "rgb";
                if (this.pixelDepth == 24) {
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 0, 1, 2, 3, 3, this.width * 3, 0, 0);
                } else if (this.pixelDepth == 16) {
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 0, 31744, 992, 31, 2, this.width * 2, 0, 0);
                } else if (this.pixelDepth == 32) {
                    this.encoding = "rgb";
                    this.format = new RGBFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, this.pixelDepth, 0, 2, 3, 4, 4, this.width * 4, 0, 0);
                }
            } else {
                this.format = this.encoding.toLowerCase().equals("8bps") ? new VideoFormat(this.encoding, new Dimension(this.width, this.height), this.maxSampleSize, Format.byteArray, this.frameRate) : (this.encoding.toLowerCase().equals("yuv2") ? new YUVFormat(new Dimension(this.width, this.height), -1, Format.byteArray, this.frameRate, 96, this.width * 2, this.width * 2, 0, 1, 3) : new VideoFormat(this.encoding, new Dimension(this.width, this.height), this.maxSampleSize, Format.byteArray, this.frameRate));
            }
            return this.format;
        }

        public String toString() {
            String info = "Video: " + this.format + "\n";
            info = String.valueOf(info) + "encoding is " + this.encoding + "\n";
            info = String.valueOf(info) + "pixelDepth is " + this.pixelDepth + "\n";
            return info;
        }

        Video() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }

    private class TrakList {
        int flag;
        int id;
        Time duration = Duration.DURATION_UNKNOWN;
        int mediaTimeScale;
        Time mediaDuration = Duration.DURATION_UNKNOWN;
        String trackType;
        int numberOfSamples;
        int sampleSize;
        int[] sampleSizeArray;
        boolean supported;
        Media media;
        int numberOfChunks;
        int[] chunkOffsets = new int[0];
        int[] compactSamplesChunkNum = new int[0];
        int[] compactSamplesPerChunk = new int[0];
        int constantSamplesPerChunk = -1;
        int[] samplesPerChunk;
        double durationOfSamples = -1.0;
        int[] timeToSampleIndices = new int[0];
        double[] cumulativeDurationOfSamples = new double[0];
        double[] startTimeOfSampleArray = new double[0];
        double[] durationOfSampleArray = new double[0];
        long[] sampleOffsetTable;
        int[] syncSamples;
        int[] syncSampleMapping;
        TimeAndDuration timeAndDuration = new TimeAndDuration();

        void buildSamplePerChunkTable() {
            if (this.numberOfChunks <= 0) {
                return;
            }
            if (this.compactSamplesPerChunk.length == 1) {
                this.constantSamplesPerChunk = this.compactSamplesPerChunk[0];
                return;
            }
            this.samplesPerChunk = new int[this.numberOfChunks];
            int i2 = 1;
            int j2 = 0;
            while (j2 < this.compactSamplesChunkNum.length - 1) {
                int numSamples = this.compactSamplesPerChunk[j2];
                while (i2 != this.compactSamplesChunkNum[j2 + 1]) {
                    this.samplesPerChunk[i2 - 1] = numSamples;
                    ++i2;
                }
                ++j2;
            }
            while (i2 <= this.numberOfChunks) {
                this.samplesPerChunk[i2 - 1] = this.compactSamplesPerChunk[j2];
                ++i2;
            }
        }

        void buildCumulativeSamplePerChunkTable() {
            if (this.constantSamplesPerChunk == -1) {
                int i2 = 1;
                while (i2 < this.numberOfChunks) {
                    int n2 = i2;
                    this.samplesPerChunk[n2] = this.samplesPerChunk[n2] + this.samplesPerChunk[i2 - 1];
                    ++i2;
                }
            }
        }

        void buildSampleOffsetTable() {
            this.sampleOffsetTable = new long[this.numberOfSamples];
            int index = 0;
            if (this.sampleSize != 0) {
                if (this.constantSamplesPerChunk != -1) {
                    int i2 = 0;
                    while (i2 < this.numberOfChunks) {
                        long offset = this.chunkOffsets[i2];
                        int j2 = 0;
                        while (j2 < this.constantSamplesPerChunk) {
                            this.sampleOffsetTable[index++] = offset + (long)(j2 * this.sampleSize);
                            ++j2;
                        }
                        ++i2;
                    }
                } else {
                    int i3 = 0;
                    while (i3 < this.numberOfChunks) {
                        long offset = this.chunkOffsets[i3];
                        int j3 = 0;
                        while (j3 < this.samplesPerChunk[i3]) {
                            this.sampleOffsetTable[index++] = offset + (long)(j3 * this.sampleSize);
                            ++j3;
                        }
                        ++i3;
                    }
                }
            } else {
                int numSamplesInChunk = 0;
                if (this.constantSamplesPerChunk != -1) {
                    numSamplesInChunk = this.constantSamplesPerChunk;
                }
                int i4 = 0;
                while (i4 < this.numberOfChunks) {
                    long offset;
                    this.sampleOffsetTable[index] = offset = (long)this.chunkOffsets[i4];
                    ++index;
                    if (this.constantSamplesPerChunk == -1) {
                        numSamplesInChunk = this.samplesPerChunk[i4];
                    }
                    int j4 = 1;
                    while (j4 < numSamplesInChunk) {
                        this.sampleOffsetTable[index] = this.sampleOffsetTable[index - 1] + (long)this.sampleSizeArray[index - 1];
                        ++index;
                        ++j4;
                    }
                    ++i4;
                }
            }
        }

        boolean buildSyncTable() {
            int previous;
            if (this.syncSamples == null) {
                return false;
            }
            if (!this.trackType.equals(QuicktimeParser.VIDEO)) {
                return false;
            }
            int numEntries = this.syncSamples.length;
            if (numEntries == this.numberOfSamples) {
                this.syncSamples = null;
                return false;
            }
            this.syncSampleMapping = new int[this.numberOfSamples];
            int index = 0;
            if (this.syncSamples[0] != 1) {
                this.syncSampleMapping[0] = 0;
                previous = 0;
            } else {
                this.syncSampleMapping[0] = 0;
                previous = 0;
                ++index;
            }
            while (index < this.syncSamples.length) {
                int next;
                this.syncSampleMapping[next] = next = this.syncSamples[index] - 1;
                int range = next - previous - 1;
                int j2 = previous + 1;
                while (j2 < next) {
                    this.syncSampleMapping[j2] = previous;
                    ++j2;
                }
                previous = next;
                ++index;
            }
            int lastSyncFrame = this.syncSamples[this.syncSamples.length - 1] - 1;
            index = lastSyncFrame + 1;
            while (index < this.numberOfSamples) {
                this.syncSampleMapping[index] = lastSyncFrame;
                ++index;
            }
            return true;
        }

        int time2Index(double time) {
            double duration;
            int samples;
            int sampleIndex;
            int foundIndex;
            int length = this.timeToSampleIndices.length;
            if (length == 0) {
                int sampleIndex2 = (int)(time / this.mediaDuration.getSeconds() * (double)this.numberOfSamples + 0.5);
                if (sampleIndex2 >= this.numberOfSamples) {
                    sampleIndex2 = this.numberOfSamples - 1;
                }
                return sampleIndex2;
            }
            int approxLocation = (int)(time / this.mediaDuration.getSeconds() * (double)length);
            if (approxLocation == length) {
                --approxLocation;
            }
            if (this.cumulativeDurationOfSamples[approxLocation] < time) {
                int i2 = approxLocation + 1;
                while (i2 < length) {
                    if (this.cumulativeDurationOfSamples[i2] >= time) break;
                    ++i2;
                }
                foundIndex = i2;
            } else if (this.cumulativeDurationOfSamples[approxLocation] > time) {
                int i3 = approxLocation - 1;
                while (i3 >= 0) {
                    if (this.cumulativeDurationOfSamples[i3] < time) break;
                    --i3;
                }
                foundIndex = i3 + 1;
            } else {
                foundIndex = approxLocation;
            }
            if (foundIndex == length) {
                --foundIndex;
            }
            double delta = this.cumulativeDurationOfSamples[foundIndex] - time;
            if (foundIndex == 0) {
                samples = sampleIndex = this.timeToSampleIndices[foundIndex];
                duration = this.cumulativeDurationOfSamples[foundIndex];
            } else {
                sampleIndex = this.timeToSampleIndices[foundIndex];
                samples = sampleIndex - this.timeToSampleIndices[foundIndex - 1];
                duration = this.cumulativeDurationOfSamples[foundIndex] - this.cumulativeDurationOfSamples[foundIndex - 1];
            }
            double fraction = delta / duration;
            sampleIndex = (int)((double)sampleIndex - (double)samples * fraction);
            return sampleIndex;
        }

        TimeAndDuration index2TimeAndDuration(int index) {
            double startTime = 0.0;
            double duration = 0.0;
            try {
                if (index < 0) {
                    index = 0;
                } else if (index >= this.numberOfSamples) {
                    index = this.numberOfSamples - 1;
                }
                int length = this.timeToSampleIndices.length;
                if (length == 0) {
                    duration = this.durationOfSamples;
                    startTime = duration * (double)index;
                } else if (this.startTimeOfSampleArray.length >= index) {
                    duration = this.durationOfSampleArray[index];
                    startTime = this.startTimeOfSampleArray[index];
                } else {
                    float factor = (float)length / (float)this.numberOfSamples;
                    int location = (int)((float)index * factor);
                    duration = 0.0;
                    startTime = 0.0;
                }
            }
            catch (Throwable throwable) {}
            TimeAndDuration timeAndDuration = this.timeAndDuration;
            synchronized (timeAndDuration) {
                this.timeAndDuration.startTime = startTime;
                this.timeAndDuration.duration = duration;
                TimeAndDuration timeAndDuration2 = this.timeAndDuration;
                Object var8_9 = null;
                return timeAndDuration2;
            }
        }

        int index2Chunk(int index) {
            int chunk;
            if (this.constantSamplesPerChunk != -1) {
                int chunk2 = index / this.constantSamplesPerChunk;
                return chunk2;
            }
            int length = this.samplesPerChunk.length;
            int approxChunk = (int)((float)(index / this.numberOfSamples) * (float)length);
            if (approxChunk == length) {
                --approxChunk;
            }
            if (this.samplesPerChunk[approxChunk] < index) {
                int i2 = approxChunk + 1;
                while (i2 < length) {
                    if (this.samplesPerChunk[i2] >= index) break;
                    ++i2;
                }
                chunk = i2;
            } else if (this.samplesPerChunk[approxChunk] > index) {
                int i3 = approxChunk - 1;
                while (i3 >= 0) {
                    if (this.samplesPerChunk[i3] < index) break;
                    --i3;
                }
                chunk = i3 + 1;
            } else {
                chunk = approxChunk;
            }
            return chunk;
        }

        long index2Offset(int index) {
            int start;
            int sampleNumInChunk;
            int chunk = this.index2Chunk(index);
            long offset = this.chunkOffsets[chunk];
            if (this.constantSamplesPerChunk != -1) {
                sampleNumInChunk = index % this.constantSamplesPerChunk;
                start = chunk * this.constantSamplesPerChunk;
            } else {
                start = chunk == 0 ? 0 : this.samplesPerChunk[chunk - 1];
                sampleNumInChunk = index - start;
            }
            if (this.sampleSize != 0) {
                offset += (long)(this.sampleSize * sampleNumInChunk);
            } else {
                int i2 = 0;
                while (i2 < sampleNumInChunk) {
                    offset += (long)this.sampleSizeArray[start++];
                    ++i2;
                }
            }
            return offset;
        }

        void buildStartTimeAndDurationTable() {
            int length = this.timeToSampleIndices.length;
            if (length == 0) {
                return;
            }
            this.startTimeOfSampleArray = new double[this.numberOfSamples];
            this.durationOfSampleArray = new double[this.numberOfSamples];
            int previousSamples = 0;
            double previousDuration = 0.0;
            double time = 0.0;
            int index = 0;
            int i2 = 0;
            while (i2 < length) {
                int numSamples = this.timeToSampleIndices[i2];
                double duration = (this.cumulativeDurationOfSamples[i2] - previousDuration) / (double)(numSamples - previousSamples);
                int j2 = 0;
                while (j2 < numSamples - previousSamples) {
                    this.startTimeOfSampleArray[index] = time;
                    this.durationOfSampleArray[index] = duration;
                    ++index;
                    time += duration;
                    ++j2;
                }
                previousSamples = numSamples;
                previousDuration = this.cumulativeDurationOfSamples[i2];
                ++i2;
            }
        }

        public String toString() {
            String info = "";
            info = String.valueOf(info) + "duration itrack is " + this.duration.getSeconds() + "\n";
            info = String.valueOf(info) + "duration of media is " + this.mediaDuration.getSeconds() + "\n";
            info = String.valueOf(info) + "trackType is " + this.trackType + "\n";
            info = String.valueOf(info) + this.media;
            return info;
        }

        TrakList() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }

    private abstract class MediaTrack
    implements Track {
        TrakList trakInfo;
        boolean enabled = true;
        int numBuffers = 4;
        Format format;
        long sequenceNumber;
        int chunkNumber;
        int sampleIndex;
        int useChunkNumber;
        int useSampleIndex;
        QuicktimeParser parser = QuicktimeParser.this;
        CachedStream cacheStream = QuicktimeParser.access$0(this.parser);
        int constantSamplesPerChunk;
        int[] samplesPerChunk;
        protected TrackListener listener;

        MediaTrack(TrakList trakInfo) {
            QuicktimeParser.this = QuicktimeParser.this;
            this.trakInfo = trakInfo;
            this.enabled = (trakInfo.flag & 1) != 0;
            this.format = trakInfo.media.createFormat();
            this.samplesPerChunk = trakInfo.samplesPerChunk;
            this.constantSamplesPerChunk = trakInfo.constantSamplesPerChunk;
        }

        public void setTrackListener(TrackListener l2) {
            this.listener = l2;
        }

        public Format getFormat() {
            return this.format;
        }

        public void setEnabled(boolean t) {
            this.enabled = t;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time getDuration() {
            return this.trakInfo.duration;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        synchronized void setSampleIndex(int index) {
            this.sampleIndex = index;
        }

        synchronized void setChunkNumber(int number) {
            this.chunkNumber = number;
        }

        public void readFrame(Buffer buffer) {
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            MediaTrack mediaTrack = this;
            synchronized (mediaTrack) {
                this.useChunkNumber = this.chunkNumber;
                this.useSampleIndex = this.sampleIndex;
            }
            if (this.useChunkNumber >= this.trakInfo.numberOfChunks || this.useChunkNumber < 0) {
                buffer.setEOM(true);
                return;
            }
            buffer.setFormat(this.format);
            this.doReadFrame(buffer);
        }

        abstract void doReadFrame(Buffer var1);

        public int mapTimeToFrame(Time t) {
            return 0;
        }

        public Time mapFrameToTime(int frameNumber) {
            return null;
        }
    }

    private class AudioTrack
    extends MediaTrack {
        String encoding;
        int channels;
        int sampleOffsetInChunk = -1;
        int useSampleOffsetInChunk;
        int frameSizeInBytes;
        int samplesPerBlock;
        int sampleRate;

        AudioTrack(TrakList trakInfo) {
            super(trakInfo);
            QuicktimeParser.this = QuicktimeParser.this;
            this.channels = ((Audio)trakInfo.media).channels;
            this.encoding = trakInfo.media.encoding;
            this.frameSizeInBytes = ((Audio)trakInfo.media).frameSizeInBits / 8;
            this.samplesPerBlock = ((Audio)trakInfo.media).samplesPerBlock;
            this.sampleRate = ((Audio)trakInfo.media).sampleRate;
        }

        synchronized void setChunkNumberAndSampleOffset(int number, int offset) {
            this.chunkNumber = number;
            this.sampleOffsetInChunk = offset;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] data;
            int byteOffsetFromSampleOffset;
            long samplesPlayed;
            int samples;
            AudioTrack audioTrack = this;
            synchronized (audioTrack) {
                if (this.sampleOffsetInChunk == -1) {
                    this.useSampleOffsetInChunk = 0;
                } else {
                    this.useSampleOffsetInChunk = this.sampleOffsetInChunk;
                    this.sampleOffsetInChunk = -1;
                }
            }
            if (this.constantSamplesPerChunk != -1) {
                samples = this.constantSamplesPerChunk;
                samplesPlayed = this.constantSamplesPerChunk * this.useChunkNumber;
            } else if (this.useChunkNumber > 0) {
                samples = this.samplesPerChunk[this.useChunkNumber] - this.samplesPerChunk[this.useChunkNumber - 1];
                samplesPlayed = this.samplesPerChunk[this.useChunkNumber];
            } else {
                samples = this.samplesPerChunk[this.useChunkNumber];
                samplesPlayed = 0L;
            }
            if (this.samplesPerBlock > 1) {
                int skipBlocks = this.useSampleOffsetInChunk / this.samplesPerBlock;
                this.useSampleOffsetInChunk = skipBlocks * this.samplesPerBlock;
                byteOffsetFromSampleOffset = this.frameSizeInBytes * skipBlocks;
            } else {
                byteOffsetFromSampleOffset = this.useSampleOffsetInChunk * this.frameSizeInBytes;
            }
            samplesPlayed += (long)this.useSampleOffsetInChunk;
            int needBufferSize = this.encoding.equals("ima4") ? samples / this.samplesPerBlock * 34 * this.channels : (this.encoding.equals("agsm") ? samples / 160 * this.samplesPerBlock : (samples -= this.useSampleOffsetInChunk) * ((AudioFormat)this.format).getSampleSizeInBits() / 8 * this.channels);
            Object obj = buffer.getData();
            if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < needBufferSize) {
                data = new byte[needBufferSize];
                buffer.setData(data);
            } else {
                data = (byte[])obj;
            }
            try {
                int actualBytesRead;
                Object object = QuicktimeParser.this.seekSync;
                synchronized (object) {
                    long pos;
                    int offset = this.trakInfo.chunkOffsets[this.useChunkNumber];
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(offset + byteOffsetFromSampleOffset, needBufferSize)) {
                        this.listener.readHasBlocked(this);
                    }
                    if ((pos = QuicktimeParser.this.seekableStream.seek(offset + byteOffsetFromSampleOffset)) == -2L) {
                        buffer.setDiscard(true);
                        return;
                    }
                    actualBytesRead = this.parser.readBytes(QuicktimeParser.this.stream, data, needBufferSize);
                    if (actualBytesRead == -2) {
                        buffer.setDiscard(true);
                        return;
                    }
                }
                buffer.setLength(actualBytesRead);
                buffer.setSequenceNumber(++this.sequenceNumber);
                if (this.sampleRate > 0) {
                    long timeStamp = samplesPlayed * 1000000000L / (long)this.sampleRate;
                    buffer.setTimeStamp(timeStamp);
                }
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            AudioTrack audioTrack2 = this;
            synchronized (audioTrack2) {
                if (this.chunkNumber != this.useChunkNumber) return;
                ++this.chunkNumber;
                return;
            }
        }
    }

    private class VideoTrack
    extends MediaTrack {
        int needBufferSize;
        boolean variableSampleSize = true;

        VideoTrack(TrakList trakInfo) {
            super(trakInfo);
            QuicktimeParser.this = QuicktimeParser.this;
            if (trakInfo.sampleSize != 0) {
                this.variableSampleSize = false;
                this.needBufferSize = trakInfo.sampleSize;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doReadFrame(Buffer buffer) {
            byte[] data;
            if (this.useSampleIndex >= this.trakInfo.numberOfSamples) {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
            if (this.variableSampleSize) {
                this.needBufferSize = this.trakInfo.sampleSizeArray[this.useSampleIndex];
            }
            long offset = this.trakInfo.sampleOffsetTable[this.useSampleIndex];
            Object obj = buffer.getData();
            if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < this.needBufferSize) {
                data = new byte[this.needBufferSize];
                buffer.setData(data);
            } else {
                data = (byte[])obj;
            }
            try {
                int actualBytesRead;
                Object object = QuicktimeParser.this.seekSync;
                synchronized (object) {
                    long pos;
                    if (this.sampleIndex != this.useSampleIndex) {
                        buffer.setDiscard(true);
                        return;
                    }
                    if (this.cacheStream != null && this.listener != null && this.cacheStream.willReadBytesBlock(offset, this.needBufferSize)) {
                        this.listener.readHasBlocked(this);
                    }
                    if ((pos = QuicktimeParser.this.seekableStream.seek(offset)) == -2L) {
                        buffer.setDiscard(true);
                        return;
                    }
                    actualBytesRead = this.parser.readBytes(QuicktimeParser.this.stream, data, this.needBufferSize);
                    if (actualBytesRead == -2) {
                        buffer.setDiscard(true);
                        return;
                    }
                }
                buffer.setLength(actualBytesRead);
                int[] syncSampleMapping = this.trakInfo.syncSampleMapping;
                boolean keyFrame = true;
                if (syncSampleMapping != null) {
                    boolean bl = keyFrame = syncSampleMapping[this.useSampleIndex] == this.useSampleIndex;
                }
                if (keyFrame) {
                    buffer.setFlags(buffer.getFlags() | 0x10);
                }
                buffer.setSequenceNumber(++this.sequenceNumber);
                TimeAndDuration td = this.trakInfo.index2TimeAndDuration(this.useSampleIndex);
                buffer.setTimeStamp((long)(td.startTime * 1.0E9));
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            VideoTrack videoTrack = this;
            synchronized (videoTrack) {
                if (this.sampleIndex != this.useSampleIndex) return;
                ++this.sampleIndex;
                return;
            }
        }
    }

    private class TimeAndDuration {
        double startTime;
        double duration;

        TimeAndDuration() {
            QuicktimeParser.this = QuicktimeParser.this;
        }
    }
}

