/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;

public class GSMMux
extends BasicMux {
    public GSMMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat("gsm");
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new ContentDescriptor("audio.x_gsm");
    }

    public String getName() {
        return "GSM Multiplexer";
    }

    public Format setInputFormat(Format input, int trackID) {
        if (!(input instanceof AudioFormat)) {
            return null;
        }
        AudioFormat format = (AudioFormat)input;
        double sampleRate = format.getSampleRate();
        String reason = null;
        double epsilon = 0.25;
        if (!format.getEncoding().equalsIgnoreCase("gsm")) {
            reason = "Encoding has to be GSM";
        } else if (Math.abs(sampleRate - 8000.0) > epsilon) {
            reason = "Sample rate should be 8000. Cannot handle sample rate " + sampleRate;
        } else if (format.getFrameSizeInBits() != 264) {
            reason = "framesize should be 33 bytes";
        } else if (format.getChannels() != 1) {
            reason = "Number of channels should be 1";
        }
        if (reason != null) {
            return null;
        }
        this.inputs[0] = format;
        return format;
    }
}

