/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.video.h263;

import com.ibm.media.codec.video.VideoCodec;
import com.ibm.media.codec.video.h263.FrameBuffer;
import com.ibm.media.codec.video.h263.H263Decoder;
import com.ibm.media.codec.video.h263.YCbCrToRGB;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class JavaDecoder
extends VideoCodec {
    private static final int rMask = 255;
    private static final int gMask = 65280;
    private static final int bMask = 0xFF0000;
    private static final boolean DEBUG = false;
    private H263Decoder javaDecoder;
    private FrameBuffer outputFrame;
    public static final int[] widths;
    public static final int[] heights;
    private int videoWidth = 176;
    private int videoHeight = 144;
    private boolean FormatSizeInitFlag = false;
    private int payloadLength = 4;
    static /* synthetic */ Class array$I;

    public JavaDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h263"), new VideoFormat("h263/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat()};
        this.PLUGIN_NAME = "H.263 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int maxDataLength = ivf.getMaxDataLength();
        this.supportedOutputFormats = ivf.getEncoding().equals("h263/rtp") ? new VideoFormat[]{new RGBFormat(new Dimension(this.videoWidth, this.videoHeight), this.videoWidth * this.videoHeight, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), ivf.getFrameRate(), 32, 1, 255, 65280, 0xFF0000, 1, this.videoWidth, 0, -1)} : new VideoFormat[]{new RGBFormat(new Dimension(inSize), inSize.width * inSize.height, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), ivf.getFrameRate(), 32, 1, 255, 65280, 0xFF0000, 1, inSize.width, 0, -1)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.initDecoder();
    }

    public void close() {
        this.javaDecoder = null;
    }

    public void reset() {
        this.initDecoder();
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        this.javaDecoder = new H263Decoder(true);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        boolean ret;
        boolean rtpData = false;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        int inputOffset = inputBuffer.getOffset();
        byte[] inData = (byte[])inputBuffer.getData();
        if (ivf.getEncoding().equals("h263/rtp")) {
            rtpData = true;
            this.payloadLength = JavaDecoder.getPayloadHeaderLength(inData, inputOffset);
            if (inData[inputOffset + this.payloadLength] == 0 && inData[inputOffset + this.payloadLength + 1] == 0 && (inData[inputOffset + this.payloadLength + 2] & 0xFC) == 128) {
                int s = inData[inputOffset + this.payloadLength + 4] >> 2 & 7;
                if (this.videoWidth != widths[s] || this.videoHeight != heights[s]) {
                    this.videoWidth = widths[s];
                    this.videoHeight = heights[s];
                    this.outputFormat = new RGBFormat(new Dimension(this.videoWidth, this.videoHeight), this.videoWidth * this.videoHeight, array$I != null ? array$I : (array$I = JavaDecoder.class$("[I")), ivf.getFrameRate(), 32, 1, 255, 65280, 0xFF0000, 1, this.videoWidth, 0, -1);
                    outMaxLength = this.videoWidth * this.videoHeight;
                    if (this.FormatSizeInitFlag) {
                        this.videoResized();
                    }
                }
                this.FormatSizeInitFlag = true;
            }
            if (!this.FormatSizeInitFlag) {
                return 1;
            }
        }
        int[] outData = this.validateIntArraySize(outputBuffer, outMaxLength);
        if (inLength + 8 + inputOffset > inData.length) {
            int newLength = inLength > inMaxLength ? inLength : inMaxLength;
            byte[] tempArray = new byte[inputOffset + newLength + 8];
            System.arraycopy(inData, 0, tempArray, 0, inLength + inputOffset);
            inData = tempArray;
            inputBuffer.setData(tempArray);
        }
        inData[inputOffset + inLength] = 0;
        inData[inputOffset + inLength + 1] = 0;
        inData[inputOffset + inLength + 2] = -4;
        inputBuffer.setLength(inLength += 3);
        if (rtpData) {
            inLength -= this.payloadLength;
        }
        if (ret = this.decodeData(inputBuffer, inLength, outputBuffer, rtpData)) {
            if (rtpData) {
                outputBuffer.setTimeStamp(0L);
            }
            this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
            return 0;
        }
        return 4;
    }

    boolean decodeData(Buffer inputBuffer, int inputLength, Buffer outputBuffer, boolean rtpData) {
        int ret;
        int[] outData = (int[])outputBuffer.getData();
        byte[] inputData = (byte[])inputBuffer.getData();
        if (inputLength <= 0) {
            return false;
        }
        this.javaDecoder.initBitstream();
        int inputOffset = inputBuffer.getOffset();
        if (rtpData) {
            ret = this.javaDecoder.DecodeRtpPacket(inputData, inputOffset + this.payloadLength, inputLength, inputData, inputOffset, inputBuffer.getTimeStamp());
            if (ret == 3) {
                return false;
            }
        } else {
            ret = this.javaDecoder.DecodePicture(inputData, inputOffset, true);
        }
        if (ret == 2) {
            throw new RuntimeException("Currently this picture format is not supported!");
        }
        if (ret == 1) {
            int outWidth = this.outputFormat.getSize().width;
            int outHeight = this.outputFormat.getSize().height;
            this.outputFrame = this.javaDecoder.CurrentFrame;
            YCbCrToRGB.convert(this.outputFrame.Y, this.outputFrame.Cb, this.outputFrame.Cr, outData, this.outputFrame.width, this.outputFrame.height, outWidth, outHeight, 255, 4);
            return true;
        }
        return false;
    }

    public static int getPayloadHeaderLength(byte[] input, int offset) {
        int l2 = 0;
        byte b2 = input[offset];
        l2 = (b2 & 0x80) != 0 ? ((b2 & 0x40) != 0 ? 12 : 8) : 4;
        return l2;
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h263/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        int[] nArray = new int[8];
        nArray[1] = 128;
        nArray[2] = 176;
        nArray[3] = 352;
        nArray[4] = 704;
        nArray[5] = 1408;
        widths = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 96;
        nArray2[2] = 144;
        nArray2[3] = 288;
        nArray2[4] = 576;
        nArray2[5] = 1152;
        heights = nArray2;
    }
}

