/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class WizardDialog
extends Dialog
implements WindowListener,
ActionListener {
    public static final String ACTION_FINISH = "Finish";
    public static final String ACTION_CANCEL = "Cancel";
    public static final String ACTION_NEXT = "Next >>";
    public static final String ACTION_BACK = "<< Back";
    private String strResultAction = "Cancel";
    private String strImage;
    private BorderedPanel panelPages;
    private Button buttonBack;
    private Button buttonNext;
    private Button buttonFinish;
    private Button buttonCancel;
    private Vector vectorPages;
    private Panel panelCurPage;
    private CardLayout layoutCard;

    public WizardDialog(Frame frameOwner, String strTitle, boolean boolModal, String strImage) {
        this(frameOwner, strTitle, boolModal, strImage, null);
    }

    public WizardDialog(Frame frameOwner, String strTitle, boolean boolModal, String strImage, Panel[] arrPages) {
        super(frameOwner, strTitle, boolModal);
        this.strImage = strImage;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setPages(arrPages);
    }

    public String getAction() {
        return this.strResultAction;
    }

    public Panel getCurrentPage() {
        return this.panelCurPage;
    }

    public void setPages(Panel[] arrPages) {
        if (arrPages != null) {
            this.panelCurPage = null;
            int nCount = arrPages.length;
            this.vectorPages = new Vector();
            int i2 = 0;
            while (i2 < nCount) {
                this.vectorPages.addElement(arrPages[i2]);
                ++i2;
            }
        }
        this.setNextPage();
    }

    protected void init() throws Exception {
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(6, 6));
        this.setResizable(false);
        this.addWindowListener(this);
        Panel panelContent = new Panel(new BorderLayout(6, 6));
        panelContent.setBackground(Color.lightGray);
        this.add((Component)panelContent, "Center");
        if (this.strImage != null) {
            Image image = MessageDialog.loadImage(this.strImage, this, true);
            ImageArea imageArea = new ImageArea(image);
            imageArea.setInsets(12, 12, 12, 12);
            panelContent.add((Component)imageArea, "West");
        }
        this.layoutCard = new CardLayout(6, 6);
        this.panelPages = new BorderedPanel(this.layoutCard);
        this.panelPages.setEmptyBorder(6, 6, 6, 6);
        panelContent.add((Component)this.panelPages, "Center");
        Panel panel = this.createPanelButtons();
        panelContent.add((Component)panel, "South");
    }

    private Panel createPanelButtons() {
        Panel panelButtons = new Panel(new FlowLayout(2));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonBack = new Button(ACTION_BACK);
        this.buttonBack.addActionListener(this);
        panel.add(this.buttonBack);
        this.buttonNext = new Button(ACTION_NEXT);
        this.buttonNext.addActionListener(this);
        panel.add(this.buttonNext);
        this.buttonFinish = new Button(ACTION_FINISH);
        this.buttonFinish.addActionListener(this);
        panel.add(this.buttonFinish);
        this.buttonCancel = new Button(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this);
        panel.add(this.buttonCancel);
        return panelButtons;
    }

    private void setNextPage() {
        Panel panelPage = this.getNextPage(this.panelCurPage);
        this.setPage(panelPage);
    }

    private void setPrevPage() {
        Panel panelPage = this.getPrevPage(this.panelCurPage);
        this.setPage(panelPage);
    }

    private void setPage(Panel panelPage) {
        if (panelPage == null) {
            return;
        }
        if (!this.onPageDone(this.panelCurPage)) {
            return;
        }
        this.panelCurPage = panelPage;
        this.onPageActivate(this.panelCurPage);
        this.panelPages.add((Component)this.panelCurPage, this.panelCurPage.getName());
        this.layoutCard.show(this.panelPages, this.panelCurPage.getName());
        if (this.isFirstPage(this.panelCurPage)) {
            this.buttonBack.setEnabled(false);
            if (this.getFocusOwner() == this.buttonBack) {
                this.buttonNext.requestFocus();
            }
        } else {
            this.buttonBack.setEnabled(true);
        }
        if (this.isLastPage(this.panelCurPage)) {
            this.buttonNext.setEnabled(false);
            this.buttonFinish.setEnabled(true);
            if (this.getFocusOwner() == this.buttonNext) {
                this.buttonFinish.requestFocus();
            }
        } else {
            this.buttonNext.setEnabled(true);
            this.buttonFinish.setEnabled(false);
        }
        this.validate();
        this.panelCurPage.validate();
    }

    protected boolean onPageDone(Panel panelPage) {
        return true;
    }

    protected boolean onPageActivate(Panel panelPage) {
        return true;
    }

    protected boolean onFinish() {
        return true;
    }

    protected Panel getFirstPage() {
        Panel panelPage = null;
        if (this.vectorPages != null && !this.vectorPages.isEmpty()) {
            panelPage = (Panel)this.vectorPages.firstElement();
        }
        return panelPage;
    }

    protected Panel getLastPage() {
        Panel panelPage = null;
        if (this.vectorPages != null && !this.vectorPages.isEmpty()) {
            panelPage = (Panel)this.vectorPages.lastElement();
        }
        return panelPage;
    }

    protected Panel getNextPage(Panel panelPage) {
        int nIndex;
        Panel panelPageNext = null;
        if (panelPage == null) {
            panelPageNext = this.getFirstPage();
        } else if (this.vectorPages != null && !this.vectorPages.isEmpty() && (nIndex = this.vectorPages.indexOf(panelPage)) >= 0 && nIndex < this.vectorPages.size() - 1) {
            panelPageNext = (Panel)this.vectorPages.elementAt(nIndex + 1);
        }
        return panelPageNext;
    }

    protected Panel getPrevPage(Panel panelPage) {
        int nIndex;
        Panel panelPagePrev = null;
        if (panelPage == null) {
            panelPagePrev = this.getLastPage();
        } else if (this.vectorPages != null && !this.vectorPages.isEmpty() && (nIndex = this.vectorPages.indexOf(panelPage)) > 0 && nIndex < this.vectorPages.size()) {
            panelPagePrev = (Panel)this.vectorPages.elementAt(nIndex - 1);
        }
        return panelPagePrev;
    }

    protected boolean isFirstPage(Panel panelPage) {
        boolean boolResult = panelPage == this.getFirstPage();
        return boolResult;
    }

    protected boolean isLastPage(Panel panelPage) {
        boolean boolResult = panelPage == this.getLastPage();
        return boolResult;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(ACTION_FINISH) || strCmd.equals(ACTION_CANCEL)) {
            if (strCmd.equals(ACTION_FINISH)) {
                if (!this.onPageDone(this.panelCurPage)) {
                    return;
                }
                if (!this.onFinish()) {
                    this.setPage(this.getFirstPage());
                    return;
                }
            }
            this.strResultAction = strCmd;
            this.dispose();
        } else if (strCmd.equals(ACTION_BACK)) {
            this.setPrevPage();
        } else if (strCmd.equals(ACTION_NEXT)) {
            this.setNextPage();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }
}

