/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VectorPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    VectorEditor editor;
    int code;
    Dimension preferredSize = new Dimension(320, 260);
    JTextField textAdd;
    JPanel westPanel;
    JButton buttonAdd;
    Vector values;
    JList listBox;
    JScrollPane scrollPane;
    JButton buttonUp;
    JButton buttonDown;
    JButton buttonRemove;
    JButton buttonRestore;
    JButton buttonCommit;
    JLabel label;

    public VectorPanel(String title, VectorEditor ve, int code) {
        this.editor = ve;
        this.code = code;
        int second = 208;
        int h1 = 32;
        this.setLayout(null);
        this.label = new JLabel(title);
        this.add(this.label);
        this.label.setLocation(0, 5);
        this.label.setSize(this.label.getPreferredSize());
        this.textAdd = new JTextField(20);
        this.add(this.textAdd);
        this.textAdd.setLocation(0, 30);
        this.textAdd.setSize(200, this.textAdd.getPreferredSize().height);
        this.values = this.editor.getList(code);
        this.listBox = new JList(this.values);
        this.scrollPane = new 1(this.listBox);
        this.listBox.setSelectionMode(0);
        this.add(this.scrollPane);
        this.scrollPane.setLocation(0, 60);
        this.scrollPane.setSize(this.scrollPane.getPreferredSize());
        this.buttonAdd = new JButton("Add");
        this.buttonUp = new JButton("Move Up");
        this.buttonDown = new JButton("Move Down");
        this.buttonRemove = new JButton("Remove");
        this.buttonRestore = new JButton("Restore");
        this.buttonCommit = new JButton("Commit");
        this.add(this.buttonAdd);
        this.add(this.buttonUp);
        this.add(this.buttonDown);
        this.add(this.buttonRemove);
        this.add(this.buttonRestore);
        this.add(this.buttonCommit);
        this.buttonUp.setEnabled(false);
        this.buttonDown.setEnabled(false);
        this.buttonRemove.setEnabled(false);
        this.buttonAdd.setLocation(second, 28);
        this.buttonAdd.setSize(this.buttonAdd.getPreferredSize());
        this.buttonUp.setLocation(second, 80);
        this.buttonUp.setSize(this.buttonUp.getPreferredSize());
        this.buttonDown.setLocation(second, 80 + h1);
        this.buttonDown.setSize(this.buttonDown.getPreferredSize());
        this.buttonRemove.setLocation(second, 80 + h1 + h1);
        this.buttonRemove.setSize(this.buttonRemove.getPreferredSize());
        this.buttonRestore.setLocation(second, 80 + h1 + h1 + h1 + 20);
        this.buttonRestore.setSize(this.buttonRestore.getPreferredSize());
        this.buttonCommit.setLocation(second, 80 + h1 + h1 + h1 + h1 + 20);
        this.buttonCommit.setSize(this.buttonCommit.getPreferredSize());
        this.listBox.addListSelectionListener(this);
        this.invalidate();
        this.validate();
        this.buttonAdd.addActionListener(this);
        this.buttonUp.addActionListener(this);
        this.buttonDown.addActionListener(this);
        this.buttonRemove.addActionListener(this);
        this.buttonRestore.addActionListener(this);
        this.buttonCommit.addActionListener(this);
        this.textAdd.addActionListener(this);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private void refresh() {
        this.listBox.setListData(this.values);
        this.scrollPane.invalidate();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    private void addNew() {
        String value = this.textAdd.getText();
        if (value != null && value.length() > 0 && this.editor.addToList(this.code, value)) {
            this.values.addElement(value);
            this.refresh();
        } else {
            JOptionPane.showMessageDialog(null, "Could not add item", "JMF Registry", 1);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.textAdd || source == this.buttonAdd) {
            this.addNew();
        } else if (source == this.buttonUp) {
            this.moveUp();
        } else if (source == this.buttonDown) {
            this.moveDown();
        } else if (source == this.buttonRemove) {
            this.remove();
        } else if (source == this.buttonRestore) {
            this.restore();
        } else if (source == this.buttonCommit) {
            this.commit();
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        int index = this.listBox.getSelectedIndex();
        if (index < 0) {
            this.buttonUp.setEnabled(false);
            this.buttonDown.setEnabled(false);
            this.buttonRemove.setEnabled(false);
        } else {
            this.buttonUp.setEnabled(true);
            this.buttonDown.setEnabled(true);
            this.buttonRemove.setEnabled(true);
            if (index == 0) {
                this.buttonUp.setEnabled(false);
            } else if (index == this.listBox.getModel().getSize() - 1) {
                this.buttonDown.setEnabled(false);
            }
            this.editor.selectedIndex(this.code, index);
        }
    }

    public void moveUp() {
        int index = this.listBox.getSelectedIndex();
        Object element = this.values.elementAt(index);
        this.values.removeElementAt(index);
        this.values.insertElementAt(element, index - 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.setSelectedIndex(index - 1);
    }

    public void moveDown() {
        int index = this.listBox.getSelectedIndex();
        Object element = this.values.elementAt(index);
        this.values.removeElementAt(index);
        this.values.insertElementAt(element, index + 1);
        this.refresh();
        this.editor.setList(this.code, this.values);
        this.listBox.setSelectedIndex(index + 1);
    }

    public void remove() {
        int index = this.listBox.getSelectedIndex();
        this.values.removeElementAt(index);
        this.editor.setList(this.code, this.values);
        this.refresh();
    }

    public void restore() {
        System.err.println("restoring");
        this.values = this.editor.getList(this.code);
        System.err.println("value = " + this.values);
        this.refresh();
    }

    public void commit() {
        this.editor.commit(this.code);
    }

    private final class 1
    extends JScrollPane {
        public Dimension getPreferredSize() {
            return new Dimension(200, 200);
        }

        /* synthetic */ 1(JList $0) {
            super($0);
        }
    }
}

