/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WindowsBorders {

    public static class ComboBoxBorder
    implements Border,
    UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;

        public ComboBoxBorder(Color color, Color color2, Color color3) {
            this.shadow = color;
            this.darkShadow = color2;
            this.highlight = color3;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 2, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = component.getBounds();
            BasicGraphicsUtils.drawEtchedRect(graphics, 0, 0, rectangle.width, rectangle.height, component.getBackground(), this.shadow, this.darkShadow, this.highlight);
        }
    }

    public static class ProgressBarBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color highlight;

        public ProgressBarBorder(Color color, Color color2) {
            this.highlight = color2;
            this.shadow = color;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n, n2, n3 - 1, n2);
            graphics.drawLine(n, n2, n, n4 - 1);
            graphics.setColor(this.highlight);
            graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        }
    }
}

