/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.AddressBookFrame;
import addressbook.AddressBookResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rogatkin.BaseController;
import rogatkin.GranulatedLayout;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class OptionsFrame
extends JFrame
implements ActionListener,
Persistable {
    public static final String OPTIONS = "DataBookOptions";
    public static final String LOCATION = "Location";
    public static final String ACCESS = "Access";
    public static final String LOGIN = "Login";
    public static final String PASSWORD = "Password";
    public static final String SHARE = "Share";
    public static final String SYNCHRO = "Synchronize";
    public static final String AUTH = "Authentication";
    public static final String ENCRYPT = "Encryption";
    public static final String LOCALE = "DataBookLocale";
    public static final String LANG = "Language";
    public static final String COUNTRY = "Country";
    BaseController controller;
    JTabbedPane tabbedpane;

    OptionsFrame(BaseController baseController) {
        super("Options");
        this.controller = baseController;
        Container container = this.getContentPane();
        this.tabbedpane = new JTabbedPane(1);
        this.tabbedpane.insertTab("Storage", null, new StorageTab(), "Provide storage location of the address book source", 0);
        container.add((Component)this.tabbedpane, "Center");
        container.add((Component)AddressBookFrame.createButtonPanel(this), "South");
        this.setIconImage(BaseController.getResourceIcon((String)"AddressBook.jpg").getImage());
        this.pack();
        this.setVisible(true);
        this.load();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.save();
            this.dispose();
        } else if (string.equals("<html><i>Apply")) {
            this.save();
        } else if (string.equals("Cancel")) {
            this.dispose();
        }
    }

    public void save() {
        int n = 0;
        while (n < this.tabbedpane.getTabCount()) {
            ((Persistable)this.tabbedpane.getComponentAt(n)).save();
            ++n;
        }
    }

    public void load() {
        int n = 0;
        while (n < this.tabbedpane.getTabCount()) {
            ((Persistable)this.tabbedpane.getComponentAt(n)).load();
            ++n;
        }
    }

    static void applyLocale(Serializer serializer) {
        String string;
        String string2 = (String)serializer.getProperty((Object)LOCALE, (Object)COUNTRY);
        if (string2 != null && (string = (String)serializer.getProperty((Object)LOCALE, (Object)LANG)) != null) {
            Locale.setDefault(new Locale(string2, string));
        }
    }

    class StorageTab
    extends JPanel
    implements ChangeListener,
    Persistable {
        ButtonGroup group;
        JRadioButton rb_global;
        JRadioButton rb_local;
        JTextField tf_addr_host;
        JTextField tf_db_url;
        JTextField tf_login;
        JPasswordField tf_password;
        JCheckBox cb_share_adr;
        JCheckBox cb_synchro;
        JComboBox cb_country;
        JComboBox cb_lang;
        JComboBox cb_auth;
        JComboBox cb_encrypt;

        StorageTab() {
            this.setLayout((LayoutManager)new GranulatedLayout(5, 6, 20, 4, 8, 8));
            this.group = new ButtonGroup();
            this.rb_global = new JRadioButton("Global");
            this.add((Component)this.rb_global, "0,0,1");
            this.group.add(this.rb_global);
            this.rb_global.addChangeListener(this);
            this.add((Component)new JLabel("Host"), "1,0,1");
            this.tf_addr_host = new JTextField();
            this.add((Component)this.tf_addr_host, "2,0,3");
            this.add((Component)new JLabel(OptionsFrame.AUTH), "1,1,1");
            this.cb_auth = new JComboBox<String>(AddressBookResources.LABEL_AUTHONTEFICATS);
            this.add(this.cb_auth, "2,1,1");
            this.add((Component)new JLabel(OptionsFrame.ENCRYPT), "3,1,1");
            this.cb_encrypt = new JComboBox<String>(AddressBookResources.LABEL_ENCRYPTIONS);
            this.add(this.cb_encrypt, "4,1,1");
            this.rb_local = new JRadioButton("Local");
            this.add((Component)this.rb_local, "0,2,2");
            this.group.add(this.rb_local);
            this.rb_local.addChangeListener(this);
            this.add((Component)new JLabel("XML Databook"), "1,2,1");
            this.tf_db_url = new JTextField();
            this.add((Component)this.tf_db_url, "2,2,3");
            this.add((Component)new JLabel("Locales"), "2,3");
            this.cb_country = new JComboBox<String>(AddressBookResources.COUNTRIES);
            this.add(this.cb_country, "3,3");
            this.cb_lang = new JComboBox<String>(AddressBookResources.LANGUAGES);
            this.add(this.cb_lang, "4,3");
            this.cb_share_adr = new JCheckBox("Share my address");
            this.add((Component)this.cb_share_adr, "0,4,2");
            this.cb_synchro = new JCheckBox(OptionsFrame.SYNCHRO);
            this.add((Component)this.cb_synchro, "0,5,2");
            this.add((Component)new JLabel(OptionsFrame.LOGIN), "2,4,1");
            this.tf_login = new JTextField();
            this.add((Component)this.tf_login, "3,4,2");
            this.add((Component)new JLabel(OptionsFrame.PASSWORD), "2,5,1");
            this.tf_password = new JPasswordField();
            this.add((Component)this.tf_password, "3,5,2");
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = this.rb_global.isSelected();
            this.tf_addr_host.setEnabled(bl);
            this.tf_db_url.setEnabled(!bl);
        }

        public void save() {
            String string;
            Integer n;
            Serializer serializer = OptionsFrame.this.controller.getSerializer();
            String string2 = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOCATION);
            if (this.rb_local.isSelected()) {
                n = AddressBookResources.NO_INT;
                string = this.tf_db_url.getText();
            } else {
                n = AddressBookResources.YES_INT;
                string = this.tf_addr_host.getText();
            }
            if (!string.equals(string2)) {
                OptionsFrame.this.controller.save();
                serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ACCESS, (Object)n);
                serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOCATION, (Object)string);
                OptionsFrame.this.controller.save();
            } else {
                serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ACCESS, (Object)n);
                serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOCATION, (Object)string);
            }
            serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOGIN, (Object)this.tf_login.getText());
            try {
                serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.PASSWORD, (Object)BaseController.bytesToHex((byte[])BaseController.encryptXor((String)new String(this.tf_password.getPassword())).getBytes("iso-8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.SHARE, (Object)(this.cb_share_adr.isSelected() ? AddressBookResources.YES_INT : AddressBookResources.NO_INT));
            serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.SYNCHRO, (Object)(this.cb_synchro.isSelected() ? AddressBookResources.YES_INT : AddressBookResources.NO_INT));
            serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.AUTH, this.cb_auth.getSelectedItem());
            serializer.setProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ENCRYPT, this.cb_encrypt.getSelectedItem());
            serializer.setProperty((Object)OptionsFrame.LOCALE, (Object)OptionsFrame.COUNTRY, this.cb_country.getSelectedItem());
            serializer.setProperty((Object)OptionsFrame.LOCALE, (Object)OptionsFrame.LANG, this.cb_lang.getSelectedItem());
            OptionsFrame.applyLocale(serializer);
        }

        public void load() {
            Serializer serializer = OptionsFrame.this.controller.getSerializer();
            this.rb_local.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ACCESS), (int)0) == 0);
            this.rb_global.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ACCESS), (int)0) == 1);
            String string = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOGIN);
            this.tf_login.setText(string != null ? string : "");
            string = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.PASSWORD);
            if (string != null) {
                try {
                    this.tf_password.setText(BaseController.encryptXor((String)new String(BaseController.hexToBytes((String)string), "iso-8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            string = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.LOCATION);
            if (this.rb_local.isSelected()) {
                this.tf_db_url.setText(string);
            } else {
                this.tf_addr_host.setText(string);
            }
            this.cb_share_adr.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.SHARE), (int)0) == 1);
            this.cb_synchro.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.SYNCHRO), (int)0) == 1);
            string = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.AUTH);
            if (string != null) {
                this.cb_auth.setSelectedItem(string);
            }
            if ((string = (String)serializer.getProperty((Object)OptionsFrame.OPTIONS, (Object)OptionsFrame.ENCRYPT)) != null) {
                this.cb_encrypt.setSelectedItem(string);
            }
            if ((string = (String)serializer.getProperty((Object)OptionsFrame.LOCALE, (Object)OptionsFrame.COUNTRY)) == null) {
                string = Locale.getDefault().getCountry();
            }
            this.cb_country.setSelectedItem(string);
            string = (String)serializer.getProperty((Object)OptionsFrame.LOCALE, (Object)OptionsFrame.LANG);
            if (string == null) {
                string = Locale.getDefault().getLanguage();
            }
            this.cb_lang.setSelectedItem(string);
        }
    }
}

