/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class ByteBuilder {
    public static final byte NONE = -1;
    public static final byte ISO = 0;
    public static final byte UNICODE = 1;
    protected ByteArrayOutputStream arr;
    protected byte encoding;

    public ByteBuilder(byte by) {
        this.arr = new ByteArrayOutputStream();
        this.encoding = by;
        this.checkEncoding();
    }

    public ByteBuilder(byte by, int n) {
        this.arr = new ByteArrayOutputStream(n);
        this.encoding = by;
        this.checkEncoding();
    }

    public void put(byte by) {
        this.arr.write(by);
    }

    public void put(byte[] byArray) {
        this.arr.write(byArray, 0, byArray.length);
    }

    public void put(String string) {
        byte[] byArray = null;
        switch (this.encoding) {
            case -1: 
            case 0: {
                try {
                    byArray = string.getBytes("ISO8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 1: {
                try {
                    byArray = string.getBytes("UNICODE");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        try {
            this.arr.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getBytes() {
        return this.arr.toByteArray();
    }

    protected void checkEncoding() {
        if (this.encoding == 0) {
            this.arr.write(0);
        } else if (this.encoding == 1) {
            this.arr.write(1);
        }
    }
}

