/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import photoorganizer.Controller;
import photoorganizer.album.AlbumModel;
import photoorganizer.album.MediaAccess;
import photoorganizer.directory.TreeDesktopModel;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.formats.Thumbnail;
import photoorganizer.media.PlaybackRequest;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.AlbumTableModel;
import photoorganizer.renderer.FolderTableModel;
import photoorganizer.renderer.OneThirdScroll;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.RipperModel;
import photoorganizer.renderer.StatusBar;
import photoorganizer.renderer.VirtualFolder;
import rogatkin.Persistable;
import rogatkin.Serializer;
import rogatkin.XmlExposable;

public class RipperPanel
extends JSplitPane
implements ActionListener,
Persistable {
    public static final String SECNAME = "RipperPanel";
    static final DataFlavor MEDIA_FORMAT_DF = new DataFlavor(class$photoorganizer$formats$AbstractFormat == null ? (class$photoorganizer$formats$AbstractFormat = RipperPanel.class$("photoorganizer.formats.AbstractFormat")) : class$photoorganizer$formats$AbstractFormat, "application/x-java-jvm-local-objectref");
    static final DataFlavor FILE_FORMAT_DF = new DataFlavor(class$java$io$File == null ? (class$java$io$File = RipperPanel.class$("java.io.File")) : class$java$io$File, "application/x-java-jvm-local-objectref");
    static final DataFlavor ALBUM_NODE_INDEX_DF = new DataFlavor(class$java$lang$Integer == null ? (class$java$lang$Integer = RipperPanel.class$("java.lang.Integer")) : class$java$lang$Integer, "application/x-java-jvm-local-objectref");
    static final DataFlavor FILE_LIST_DF = DataFlavor.javaFileListFlavor;
    static final DataFlavor MIXED_FILE_MEDIA_LIST_DF = new DataFlavor(class$java$util$ArrayList == null ? (class$java$util$ArrayList = RipperPanel.class$("java.util.ArrayList")) : class$java$util$ArrayList, "application/x-java-jvm-local-objectref");
    static final int TOO_MANY_WINDOWS = 20;
    protected Controller controller;
    protected DirectoryTable folderTable;
    protected AlbumTable albumTable;
    protected RipperTable ripperTable;
    protected CollectionTable collectionTable;
    protected SAXParserFactory saxParserFactory;
    protected RipperTree ripper;
    protected MediaAccess access;
    static /* synthetic */ Class class$photoorganizer$formats$AbstractFormat;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$ArrayList;

    public RipperPanel(Controller controller) {
        super(0);
        this.controller = controller;
        this.setOneTouchExpandable(true);
        this.access = new MediaAccess(controller);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        this.folderTable = new DirectoryTable(new FolderTableModel(controller));
        jTabbedPane.insertTab("Directory", null, new JSplitPane(1, new OneThirdScroll(new DirectoryTree(this.folderTable)), new JScrollPane(this.folderTable)), "Use it to navigate through your directory structure", jTabbedPane.getTabCount());
        this.albumTable = new AlbumTable(new AlbumTableModel(controller));
        jTabbedPane.insertTab("Album", null, new JSplitPane(1, new OneThirdScroll(new AlbumTree(this.albumTable)), new JScrollPane(this.albumTable)), "Viewing and creation photo albums", jTabbedPane.getTabCount());
        this.collectionTable = new CollectionTable();
        jTabbedPane.insertTab("Selection", null, new JScrollPane(this.collectionTable), "Use it to place your selection", jTabbedPane.getTabCount());
        this.setTopComponent(jTabbedPane);
        this.ripperTable = new RipperTable();
        this.ripper = new RipperTree(this.ripperTable);
        this.setBottomComponent(new JSplitPane(1, new OneThirdScroll(this.ripper), new JScrollPane(this.ripperTable)));
        this.setDividerLocation(0.5);
    }

    public void save() {
        this.controller.saveTableColumns(this.folderTable, SECNAME, this.folderTable.getClass().getName());
        this.controller.saveTableColumns(this.albumTable, SECNAME, this.albumTable.getClass().getName());
        this.controller.saveTableColumns(this.ripperTable, SECNAME, this.ripperTable.getClass().getName());
        this.controller.saveTableColumns(this.collectionTable, SECNAME, this.collectionTable.getClass().getName());
    }

    public void load() {
        this.controller.loadTableColumns(this.folderTable, SECNAME, this.folderTable.getClass().getName());
        this.controller.loadTableColumns(this.albumTable, SECNAME, this.albumTable.getClass().getName());
        this.controller.loadTableColumns(this.ripperTable, SECNAME, this.ripperTable.getClass().getName());
        this.controller.loadTableColumns(this.collectionTable, SECNAME, this.collectionTable.getClass().getName());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Make disk")) {
            ((RipperModel)this.ripper.getModel()).doDisk(this.controller);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MediaTransferHandler
    extends TransferHandler {
        MediaTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                JTable jTable = (JTable)jComponent;
                int[] nArray = jTable.getSelectedRows();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (jComponent instanceof CollectionTable) {
                    ListModel listModel = (ListModel)((Object)jTable.getModel());
                    int n = 0;
                    while (n < nArray.length) {
                        arrayList.add(((Thumbnail)listModel.getElementAt(nArray[n])).getFormat());
                        ++n;
                    }
                    return new TransferableMedias(arrayList);
                }
                if (jComponent instanceof AlbumTable) {
                    AlbumTableModel albumTableModel = (AlbumTableModel)jTable.getModel();
                    int n = 0;
                    while (n < nArray.length) {
                        arrayList.add(albumTableModel.getElementAt(nArray[n]));
                        ++n;
                    }
                    return new TransferableMedias(arrayList);
                }
                if (jComponent instanceof DirectoryTable) {
                    FolderTableModel folderTableModel = (FolderTableModel)jTable.getModel();
                    int n = 0;
                    while (n < nArray.length) {
                        arrayList.add(folderTableModel.getElementAt(nArray[n]));
                        ++n;
                    }
                    return new TransferableMedias(arrayList);
                }
            } else if (jComponent instanceof AlbumTree) {
                return new TransferableMedias(RipperPanel.this.access.getAlbumId(((AlbumTree)jComponent).getSelectionPath()));
            }
            return null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (jComponent instanceof RipperTree) {
                RipperTree ripperTree = (RipperTree)jComponent;
                RipperModel ripperModel = (RipperModel)ripperTree.getModel();
                TreePath treePath = ripperTree.getSelectionPath();
                Object object = treePath == null ? null : treePath.getLastPathComponent();
                RipperModel ripperModel2 = object != null && object instanceof VirtualFolder ? (VirtualFolder)object : ripperModel;
                try {
                    if (transferable.isDataFlavorSupported(MIXED_FILE_MEDIA_LIST_DF)) {
                        List list = (List)transferable.getTransferData(MIXED_FILE_MEDIA_LIST_DF);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Object e = iterator.next();
                            if (e instanceof AbstractFormat) {
                                ripperModel2.addMedia((AbstractFormat)e);
                                continue;
                            }
                            if (!(e instanceof File)) continue;
                            ripperModel2.addMedia((File)e);
                        }
                    } else if (transferable.isDataFlavorSupported(FILE_LIST_DF)) {
                        Iterator iterator = ((List)transferable.getTransferData(FILE_LIST_DF)).iterator();
                        while (iterator.hasNext()) {
                            ripperModel2.addMedia(iterator.next());
                        }
                    } else if (transferable.isDataFlavorSupported(ALBUM_NODE_INDEX_DF)) {
                        Integer n = (Integer)transferable.getTransferData(ALBUM_NODE_INDEX_DF);
                        VirtualFolder virtualFolder = new VirtualFolder(RipperPanel.this.access.getNameOfAlbum(n));
                        ((ArrayList)ripperModel2).add(virtualFolder);
                        File[] fileArray = RipperPanel.this.access.getAlbumContents(n);
                        int n2 = 0;
                        while (n2 < fileArray.length) {
                            virtualFolder.addMedia(fileArray[n2]);
                            ++n2;
                        }
                    }
                    ripperTree.ripperTable.revalidate();
                    ((StatusBar)RipperPanel.this.controller.component(Controller.COMP_STATUSBAR)).displayMetric(ripperModel.music ? MP3.convertTime(ripperModel.getTime()) : BasicIo.convertLength(ripperModel.getLength()));
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return false;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return true;
        }
    }

    class TransferableMedias
    implements Transferable {
        List medias;
        Integer albumId;

        TransferableMedias(List list) {
            this.medias = list;
        }

        TransferableMedias(int n) {
            this.albumId = new Integer(n);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.equals(MIXED_FILE_MEDIA_LIST_DF)) {
                return this.medias;
            }
            if (dataFlavor.equals(ALBUM_NODE_INDEX_DF)) {
                return this.albumId;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{MIXED_FILE_MEDIA_LIST_DF, ALBUM_NODE_INDEX_DF};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.medias != null && dataFlavor.equals(MIXED_FILE_MEDIA_LIST_DF) || dataFlavor.equals(ALBUM_NODE_INDEX_DF) && this.albumId != null;
        }
    }

    class RipperTable
    extends MediaTable {
        RipperTable() {
            super(new AlbumTableModel(RipperPanel.this.controller));
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ RipperTable this$1;
                {
                    this.this$1 = ripperTable;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127) {
                        ((AlbumTableModel)this.this$1.getModel()).delete(this.this$1.getSelectedRows());
                        RipperModel ripperModel = (RipperModel)RipperTable.access$100((RipperTable)this.this$1).ripper.getModel();
                        ((StatusBar)RipperTable.access$100((RipperTable)this.this$1).controller.component(Controller.COMP_STATUSBAR)).displayMetric(ripperModel.music ? MP3.convertTime(ripperModel.getTime()) : BasicIo.convertLength(ripperModel.getLength()));
                    }
                }
            });
        }

        static /* synthetic */ RipperPanel access$100(RipperTable ripperTable) {
            return ripperTable.RipperPanel.this;
        }
    }

    class RipperTree
    extends JTree
    implements ActionListener {
        RipperTable ripperTable;

        RipperTree(RipperTable ripperTable) {
            super(new RipperModel(Serializer.getInt((Object)RipperPanel.this.controller.getSerializer().getProperty((Object)"MediaOptions", (Object)"ListLimitType"), (int)1) == 1));
            this.ripperTable = ripperTable;
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ RipperTree this$1;
                {
                    this.this$1 = ripperTree;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        this.this$1.getRMouseMenu().show(this.this$1, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2) {
                        this.this$1.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                    }
                }
            });
            this.setTransferHandler(new MediaTransferHandler());
            this.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ RipperTree this$1;
                {
                    this.this$1 = ripperTree;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ((AlbumTableModel)this.this$1.ripperTable.getModel()).updateModel((VirtualFolder)treeSelectionEvent.getPath().getLastPathComponent());
                    if (this.this$1.ripperTable.getRowCount() > 0) {
                        this.this$1.ripperTable.removeRowSelectionInterval(0, this.this$1.ripperTable.getRowCount() - 1);
                    }
                    this.this$1.ripperTable.tableChanged(new TableModelEvent(this.this$1.ripperTable.getModel()));
                }
            });
            this.setEditable(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("New Folder")) {
                TreeModel treeModel = this.getSelectionPath() == null || this.getSelectionPath().getLastPathComponent() == null ? this.getModel() : this.getSelectionPath().getLastPathComponent();
                ((List)((Object)treeModel)).add(new VirtualFolder("New Folder" + ((List)((Object)treeModel)).size()));
                ((RipperModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{treeModel}, null, null);
            } else if (string.equals("Rename")) {
                this.startEditingAtPath(this.getSelectionPath());
            } else if (string.equals("Delete")) {
                TreePath treePath = this.getSelectionPath();
                if (treePath != null) {
                    Object object = treePath.getParentPath();
                    if (object != null) {
                        object = ((TreePath)object).getLastPathComponent();
                    }
                    if (object != null && object instanceof List) {
                        ((List)object).remove(treePath.getLastPathComponent());
                        ((RipperModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{object}, null, null);
                    }
                }
            } else if (string.equals("New layout")) {
                ((AlbumTableModel)this.ripperTable.getModel()).updateModel((VirtualFolder)null);
                ((RipperModel)this.getModel()).reset(Serializer.getInt((Object)RipperPanel.this.controller.getSerializer().getProperty((Object)"MediaOptions", (Object)"ListLimitType"), (int)1) == 1);
                ((RipperModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel()}, null, null);
                ((StatusBar)RipperPanel.this.controller.component(Controller.COMP_STATUSBAR)).displayMetric("");
            } else if (string.equals("Load Layout")) {
                XmlFileChooser xmlFileChooser = new XmlFileChooser(false);
                if (xmlFileChooser.showOpenDialog(this) == 0) {
                    try {
                        this.getSaxParserFactory().newSAXParser().parse(((JFileChooser)xmlFileChooser).getSelectedFile(), ((XmlExposable)this.getModel()).getXmlHandler(null, null, ((XmlExposable)this.getModel()).getNameSpacePrefix(), null, null));
                        ((RipperModel)this.getModel()).fireTreeStructureChanged(this, new Object[]{this.getModel()}, null, null);
                        ((StatusBar)RipperPanel.this.controller.component(Controller.COMP_STATUSBAR)).displayMetric("");
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        System.err.println("Can not obtain XML parser " + parserConfigurationException);
                    }
                    catch (IOException iOException) {
                        System.err.println("Can not read file " + ((JFileChooser)xmlFileChooser).getSelectedFile() + ' ' + iOException);
                    }
                    catch (SAXException sAXException) {
                        System.err.println("Parser failed for " + ((JFileChooser)xmlFileChooser).getSelectedFile() + ' ' + sAXException);
                        if (sAXException.getException() != null) {
                            sAXException.getException().printStackTrace();
                        } else if (sAXException instanceof SAXParseException) {
                            SAXParseException sAXParseException = (SAXParseException)sAXException;
                            System.err.println(" in " + sAXParseException.getLineNumber() + ':' + sAXParseException.getColumnNumber());
                        }
                    }
                }
            } else if (string.equals("Save Layout")) {
                XmlFileChooser xmlFileChooser = new XmlFileChooser(true);
                if (!(xmlFileChooser.showOpenDialog(this) != 0 || ((JFileChooser)xmlFileChooser).getSelectedFile().exists() && 0 != JOptionPane.showConfirmDialog(this, ((JFileChooser)xmlFileChooser).getSelectedFile().getName() + "- already exists.\nAre you sure to overwrite it?", "Overwrite", 0, 2))) {
                    try {
                        FileWriter fileWriter = new FileWriter(((JFileChooser)xmlFileChooser).getSelectedFile());
                        fileWriter.write(((XmlExposable)this.getModel()).toXmlString());
                        ((Writer)fileWriter).flush();
                        ((Writer)fileWriter).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Can not write XML coded ripper layout to :" + ((JFileChooser)xmlFileChooser).getSelectedFile() + ' ' + iOException);
                    }
                }
            } else if (string.equals("Properties...")) {
                // empty if block
            }
        }

        protected synchronized SAXParserFactory getSaxParserFactory() {
            if (RipperPanel.this.saxParserFactory == null) {
                RipperPanel.this.saxParserFactory = SAXParserFactory.newInstance();
            }
            return RipperPanel.this.saxParserFactory;
        }

        JPopupMenu getRMouseMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("New Folder");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Rename");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Delete");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("New layout");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Load Layout");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Save Layout");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            return jPopupMenu;
        }

        class XmlFileChooser
        extends JFileChooser {
            XmlFileChooser(boolean bl) {
                if (System.getProperty("MediaChest.home") != null) {
                    this.setCurrentDirectory(new File(System.getProperty("MediaChest.home")).getAbsoluteFile());
                    this.rescanCurrentDirectory();
                }
                this.setDialogTitle(bl ? "Save Layout" : "Load Layout");
                this.setDialogType(bl ? 1 : 0);
                if (bl) {
                    this.setSelectedFile(new File(this.getCurrentDirectory(), "Layout1.xml"));
                }
                this.addChoosableFileFilter(new FileFilter(this){
                    private final /* synthetic */ XmlFileChooser this$2;
                    {
                        this.this$2 = xmlFileChooser;
                    }

                    public String getDescription() {
                        return "layout files (.xml)";
                    }

                    public boolean accept(File file) {
                        return this.this$2.accept(file);
                    }
                });
            }

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }

            public File getSelectedFile() {
                File file = super.getSelectedFile();
                if (file != null && !this.accept(file)) {
                    file = new File(file.getParent(), file.getName() + ".xml");
                }
                return file;
            }
        }
    }

    class CollectionTable
    extends JTable
    implements ActionListener {
        CollectionTable() {
            super(((PhotoCollectionPanel)RipperPanel.this.controller.component(Controller.COMP_COLLECTION)).getModel());
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ CollectionTable this$1;
                {
                    this.this$1 = collectionTable;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        this.this$1.getRMouseMenu().show(this.this$1, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2) {
                        this.this$1.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                    }
                }
            });
            this.setDragEnabled(true);
            this.setTransferHandler(new MediaTransferHandler());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int[] nArray = this.getSelectedRows();
            ListModel listModel = (ListModel)((Object)this.getModel());
            if (string.equals("Show/Play")) {
                Object[] objectArray = new Object[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    objectArray[n] = ((Thumbnail)listModel.getElementAt(nArray[n])).getFormat();
                    ++n;
                }
                new PlaybackRequest(objectArray, RipperPanel.this.controller.getSerializer()).playList(RipperPanel.this.controller);
            } else if (string.equals("Properties...")) {
                int n = 0;
                while (n < nArray.length && n < 20) {
                    Thumbnail thumbnail = (Thumbnail)listModel.getElementAt(nArray[n]);
                    if (thumbnail != null) {
                        PropertiesPanel.showProperties(thumbnail.getFormat(), RipperPanel.this.controller);
                    }
                    ++n;
                }
            }
        }

        JPopupMenu getRMouseMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show/Play");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            return jPopupMenu;
        }
    }

    class AlbumTable
    extends MediaTable {
        AlbumTable(AlbumTableModel albumTableModel) {
            super(albumTableModel);
            this.setDragEnabled(true);
            this.setTransferHandler(new MediaTransferHandler());
        }
    }

    class MediaTable
    extends JTable
    implements ActionListener {
        MediaTable(TableModel tableModel) {
            super(tableModel);
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ MediaTable this$1;
                {
                    this.this$1 = mediaTable;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        this.this$1.getRMouseMenu().show(this.this$1, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2) {
                        this.this$1.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int[] nArray = this.getSelectedRows();
            AlbumTableModel albumTableModel = (AlbumTableModel)this.getModel();
            if (string.equals("Show/Play")) {
                Object[] objectArray = new Object[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    objectArray[n] = albumTableModel.getElementAt(nArray[n]);
                    ++n;
                }
                new PlaybackRequest(objectArray, RipperPanel.this.controller.getSerializer()).playList(RipperPanel.this.controller);
            } else if (string.equals("To selection")) {
                PhotoCollectionPanel photoCollectionPanel = (PhotoCollectionPanel)RipperPanel.this.controller.component(Controller.COMP_COLLECTION);
                File[] fileArray = new File[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    fileArray[n] = albumTableModel.getElementAt(nArray[n]) instanceof File ? (File)albumTableModel.getElementAt(nArray[n]) : ((AbstractFormat)albumTableModel.getElementAt(nArray[n])).getFile();
                    ++n;
                }
                photoCollectionPanel.add(fileArray);
            } else if (string.equals("To album")) {
                AlbumPane albumPane = (AlbumPane)RipperPanel.this.controller.component(Controller.COMP_ALBUMPANEL);
                AlbumSelectionDialog albumSelectionDialog = albumPane.getSelectionDialog();
                albumSelectionDialog.setTitle("Albums selection for - :" + nArray.length);
                albumSelectionDialog.setVisible(true);
                TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
                if (treePathArray != null) {
                    AbstractFormat[] abstractFormatArray = new AbstractFormat[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        abstractFormatArray[n] = albumTableModel.getElementAt(nArray[n]) instanceof AbstractFormat ? (AbstractFormat)albumTableModel.getElementAt(nArray[n]) : MediaFormatFactory.createMediaFormat((File)albumTableModel.getElementAt(nArray[n]));
                        ++n;
                    }
                    albumPane.addToAlbum(abstractFormatArray, treePathArray);
                }
            } else if (string.equals("Properties...")) {
                int n = 0;
                while (n < nArray.length && n < 20) {
                    AbstractFormat abstractFormat;
                    Object object = albumTableModel.getElementAt(nArray[n]);
                    if (object instanceof AbstractFormat) {
                        PropertiesPanel.showProperties((AbstractFormat)object, RipperPanel.this.controller);
                    } else if (object instanceof File && (abstractFormat = MediaFormatFactory.createMediaFormat((File)object)) != null && abstractFormat.isValid()) {
                        PropertiesPanel.showProperties(abstractFormat, RipperPanel.this.controller);
                    }
                    ++n;
                }
            }
        }

        JPopupMenu getRMouseMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show/Play");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("To selection");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("To album");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            return jPopupMenu;
        }
    }

    class AlbumTree
    extends JTree {
        AlbumTable albumTable;

        AlbumTree(AlbumTable albumTable) {
            this.albumTable = albumTable;
            this.setModel(new AlbumModel(RipperPanel.this.access));
            this.getSelectionModel().setSelectionMode(1);
            this.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ AlbumTree this$1;
                {
                    this.this$1 = albumTree;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ((AlbumTableModel)this.this$1.albumTable.getModel()).updateModel(AlbumTree.access$000((AlbumTree)this.this$1).access.getAlbumContents(AlbumTree.access$000((AlbumTree)this.this$1).access.getAlbumId(treeSelectionEvent.getPath())));
                    if (this.this$1.albumTable.getRowCount() > 0) {
                        this.this$1.albumTable.removeRowSelectionInterval(0, this.this$1.albumTable.getRowCount() - 1);
                    }
                    this.this$1.albumTable.revalidate();
                }
            });
            this.setDragEnabled(true);
            this.setTransferHandler(new MediaTransferHandler());
        }

        static /* synthetic */ RipperPanel access$000(AlbumTree albumTree) {
            return albumTree.RipperPanel.this;
        }
    }

    class DirectoryTable
    extends JTable
    implements ActionListener {
        DirectoryTable(FolderTableModel folderTableModel) {
            super(folderTableModel);
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ DirectoryTable this$1;
                {
                    this.this$1 = directoryTable;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        this.this$1.getRMouseMenu().show(this.this$1, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() == 2) {
                        this.this$1.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ DirectoryTable this$1;
                {
                    this.this$1 = directoryTable;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 127) {
                        this.this$1.actionPerformed(new ActionEvent(this, 3, "Delete"));
                    }
                }
            });
            this.setDragEnabled(true);
            this.setTransferHandler(new MediaTransferHandler());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int[] nArray = this.getSelectedRows();
            FolderTableModel folderTableModel = (FolderTableModel)this.getModel();
            if (string.equals("Show/Play")) {
                Object[] objectArray = new Object[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    objectArray[n] = folderTableModel.getElementAt(nArray[n]);
                    ++n;
                }
                if (objectArray.length != 1 || objectArray[0] == null || !(objectArray[0] instanceof File) || !((File)objectArray[0]).isDirectory()) {
                    new PlaybackRequest(objectArray, RipperPanel.this.controller.getSerializer()).playList(RipperPanel.this.controller);
                }
            } else if (string.equals("To selection")) {
                PhotoCollectionPanel photoCollectionPanel = (PhotoCollectionPanel)RipperPanel.this.controller.component(Controller.COMP_COLLECTION);
                File[] fileArray = new File[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    fileArray[n] = folderTableModel.getElementAt(nArray[n]) instanceof File ? folderTableModel.getElementAt(nArray[n]) : ((AbstractFormat)((Object)folderTableModel.getElementAt(nArray[n]))).getFile();
                    ++n;
                }
                photoCollectionPanel.add(fileArray);
            } else if (string.equals("To album")) {
                AlbumPane albumPane = (AlbumPane)RipperPanel.this.controller.component(Controller.COMP_ALBUMPANEL);
                AlbumSelectionDialog albumSelectionDialog = albumPane.getSelectionDialog();
                albumSelectionDialog.setTitle("Albums selection for - :" + nArray.length);
                albumSelectionDialog.setVisible(true);
                TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
                if (treePathArray != null) {
                    AbstractFormat[] abstractFormatArray = new AbstractFormat[nArray.length];
                    int n = 0;
                    while (n < nArray.length) {
                        abstractFormatArray[n] = folderTableModel.getElementAt(nArray[n]) instanceof AbstractFormat ? (AbstractFormat)((Object)folderTableModel.getElementAt(nArray[n])) : MediaFormatFactory.createMediaFormat(folderTableModel.getElementAt(nArray[n]));
                        ++n;
                    }
                    albumPane.addToAlbum(abstractFormatArray, treePathArray);
                }
            } else if (string.equals("Delete")) {
                boolean bl = true;
                int n = 0;
                while (n < nArray.length) {
                    File file = folderTableModel.getElementAt(nArray[n]);
                    File file2 = null;
                    if (file instanceof File) {
                        file2 = file;
                    } else if (file instanceof AbstractFormat) {
                        file2 = ((AbstractFormat)((Object)file)).getFile();
                    }
                    if (bl) {
                        int n2 = JOptionPane.showOptionDialog(this, file2.getName() + "- will be removed permanently.\nAre you sure?", "Delete", 0, 2, null, new Object[]{"Yes", "Yes to all", "No", "Cancel"}, "No");
                        if (n2 != 2) {
                            if (n2 == 1) {
                                bl = false;
                            } else if (n2 == 3) break;
                        }
                    } else if (file2 != null && !file2.delete()) {
                        ((StatusBar)RipperPanel.this.controller.component(Controller.COMP_STATUSBAR)).flashInfo("Cannot delete " + file2, true);
                    }
                    ++n;
                }
                this.revalidate();
            } else if (string.equals("Properties...")) {
                int n = 0;
                while (n < nArray.length && n < 20) {
                    AbstractFormat abstractFormat;
                    File file = folderTableModel.getElementAt(nArray[n]);
                    if (file instanceof AbstractFormat) {
                        PropertiesPanel.showProperties((AbstractFormat)((Object)file), RipperPanel.this.controller);
                    } else if (file instanceof File && (abstractFormat = MediaFormatFactory.createMediaFormat(file)) != null && abstractFormat.isValid()) {
                        PropertiesPanel.showProperties(abstractFormat, RipperPanel.this.controller);
                    }
                    ++n;
                }
            }
        }

        JPopupMenu getRMouseMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show/Play");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("To selection");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("To album");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jMenuItem = new JMenuItem("Delete");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            return jPopupMenu;
        }
    }

    class DirectoryTree
    extends JTree
    implements ActionListener {
        DirectoryTable folderTable;

        DirectoryTree(DirectoryTable directoryTable) {
            super(new TreeDesktopModel());
            this.folderTable = directoryTable;
            this.setCellRenderer(((TreeDesktopModel)this.getModel()).adoptCellRenderer(this.getCellRenderer()));
            this.setRootVisible(false);
            this.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ DirectoryTree this$1;
                {
                    this.this$1 = directoryTree;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    ((FolderTableModel)this.this$1.folderTable.getModel()).updateModel(((File)treeSelectionEvent.getPath().getLastPathComponent()).listFiles());
                    if (this.this$1.folderTable.getRowCount() > 0) {
                        this.this$1.folderTable.removeRowSelectionInterval(0, this.this$1.folderTable.getRowCount() - 1);
                    }
                    this.this$1.folderTable.revalidate();
                }
            });
            this.addMouseListener(new MouseInputAdapter(this){
                private final /* synthetic */ DirectoryTree this$1;
                {
                    this.this$1 = directoryTree;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        this.this$1.getRMouseMenu().show(this.this$1, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.setDragEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Refresh")) {
                ((TreeDesktopModel)this.getModel()).reset(null);
            }
        }

        JPopupMenu getRMouseMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Refresh");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Properties...");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(this);
            return jPopupMenu;
        }
    }
}

