/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   P_DisplayFrame.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *   DisplayFrame implements the Displayable interface and also build
 * a control panel with buttons to control the flow and information
 * display screen.
 */
class P_DisplayFrame extends JPanel implements P_Displayable
{

      private boolean dontPaint = false;
	/**
	 *   The Frame that used to display the video image
	 */
	private class P_Screen extends JComponent
	{

                private Image img;
                public Dimension getPreferredSize() {
                  return new Dimension(192,142);
                }

                public void setImage(Image img) {
                  boolean firstPaint = (img==null);
                  this.img = img;
                  //paint(getGraphics());
                  if (firstPaint) {
                    repaint();
                  }
                }

		P_Screen() {
		}

                public void paint(Graphics g) {
                  if (g!=null) {
                    if (img!=null && !dontPaint) {
                      //Image img2 = img.getScaledInstance(getSize().width, getSize().height,Image.SCALE_FAST);
                      g.drawImage(img, 0, 0, getSize().width, getSize().height, this);
                      //g.drawImage(img2, 0, 0, this);
                    } else {
                      g.setColor(Color.black);
                      g.fillRect(0,0,500,500);
                    }
                  }
                  super.paint(g);
                }

		public void update(Graphics g) {
			paint(g);
		}
	}

	/**
	 *   Default size for screen
	 */
	//public static final int xDefault = 320, yDefault = 240;



	/**
	 *   The image to display on screen
	 */
	private Image img = null;

	/**
	 *   The insets between the Frame border and actual display region
	 */
	private Insets insets;

	/**
	 *   The video display screen
	 */
	private P_Screen screen;

	/**
	 *   The MPEGApp that play the mpeg file
	 */
	private P_MPEGApp mpegplayer;

	/**
	 *   The mpeg file name
	 */
	private String mpegFileName = null;

	/**
	 *   Panels to hold control buttons
	 */
	private JPanel controlPanel1, controlPanel2, controlPanel3;

	/**
	 *   Panel to display time, player state and frame rate information
	 */
	private JPanel infoPanel1;

	/**
	 *   Main Panel to hold the above Panels
	 */
	private JPanel mainPanel;

	/**
	 *   The FileDialog to select the MPEG file
	 */
	FileDialog filedialog;

	/**
	 *   Control Buttons
	 */
	private JButton btPlay,btStep,btFForw,btStop;//, btOpen;

	/**
	 *   Labels to Display various information
	 */
	private JLabel lbTime, lbState, lbFrame, lbSpeed;

	/**
	 *   The Frame count for the information display
	 */
	private long count = 0;

	/**
	 *   Last system time for the frame rate calculation
	 */
	private long systime = 0;

	/**
	 *   Contructor
	 * @param	title		The title to display on the window
	 * @param	mpegplayer	The MPEG player it interact with
	 */
	public P_DisplayFrame (String title, P_MPEGApp mpegplayer )
	{
		//super(title);
		this.mpegplayer = mpegplayer;

                Container c = this;

		// The constrution of controlPanel
		controlPanel1 = new JPanel(new FlowLayout(FlowLayout.CENTER, 5,5));

		Font font1 = new Font("Monospaced",Font.PLAIN, 12);

		btPlay = new JButton(new ImageIcon("wobs"+File.separator+"wob61"+File.separator+"play.gif"));
		//btPlay.setFont(font1);
		btPlay.setEnabled(false);
		btPlay.addActionListener(new ActionListener() {
			public void actionPerformed (ActionEvent e)
			{
				playEvent();
			}
		});
		controlPanel1.add(btPlay);


		btStep = new JButton(new ImageIcon("wobs"+File.separator+"wob61"+File.separator+"pause.gif"));
		btStep.setFont(font1);
		btStep.setEnabled(false);
		btStep.addActionListener(new ActionListener() {
			public void actionPerformed (ActionEvent e)
			{
				stepEvent();
			}
		});
		//controlPanel1.add(btStep);

		btFForw = new JButton(new ImageIcon("wobs"+File.separator+"wob61"+File.separator+"fastforward.gif"));
		btFForw.setFont(font1);
		btFForw.setEnabled(false);
		btFForw.addActionListener(new ActionListener() {
			public void actionPerformed (ActionEvent e)
			{
				fforwEvent();
			}
		});
		//controlPanel1.add(btFForw);

		btStop = new JButton(new ImageIcon("wobs"+File.separator+"wob61"+File.separator+"stop.gif"));
		btStop.setFont(font1);
		btStop.setEnabled(false);
		btStop.addActionListener(new ActionListener() {
			public void actionPerformed (ActionEvent e)
			{
				stopEvent();
			}
		});
		controlPanel1.add(btStop);


		controlPanel2 = new JPanel(new FlowLayout(FlowLayout.CENTER,10,2));


		controlPanel3 = new JPanel(new GridLayout(1,1));
		controlPanel3.add(controlPanel1);


		Font font2 = new Font("SansSerif",Font.PLAIN, 14);
		infoPanel1 = new JPanel(new GridLayout(2,2,15,2));

		lbTime = new JLabel("0:0:0");
		//lbTime.setAlignment(Label.RIGHT);
		lbTime.setFont(font2);
		infoPanel1.add(lbTime);

		lbState = new JLabel("Reset");
		//lbState.setAlignment(Label.CENTER);
		lbState.setFont(font2);
		infoPanel1.add(lbState);

		lbFrame = new JLabel("0");
		//lbFrame.setAlignment(Label.RIGHT);
		lbFrame.setFont(font2);
		infoPanel1.add(lbFrame);

		lbSpeed = new JLabel("0 f/s");
		//lbSpeed.setAlignment(Label.CENTER);
		lbSpeed.setFont(font2);
		infoPanel1.add(lbSpeed);

		infoPanel1.setBackground(Color.black);
		infoPanel1.setForeground(Color.green);


		screen = new P_Screen();

		c.setLayout(new BorderLayout());
                c.add("Center", screen);
		c.add("South", controlPanel3);

	}

	/**
	 *   Reset the Frame rate calculation variables
	 */
	private void reset()
	{
		count = 0;
		systime = System.currentTimeMillis();
		lbSpeed.setText("0 f/s");
	}

	/**
	 *   Tell the mpegplayer to play
	 */
	private void playEvent()
	{
          dontPaint = false;
		if (mpegplayer.isReseted()) {
			try {
				mpegplayer.setInputStream(new FileInputStream(mpegFileName));

			} catch (IOException e){
				System.out.println("IOException while try to open the inputstream");
				System.exit(-1);
			}
			reset();
		}

		mpegplayer.play();
		btStop.setEnabled(true);
		lbState.setText("Play");
	}

	/**
	 *   Tell the mpegplayer to step
	 */
	public void stepEvent()
	{
          dontPaint = false;
		if (mpegplayer.isReseted())
			playEvent();
		mpegplayer.step();
		btStop.setEnabled(true);
		lbState.setText("Step");
	}

	/**
	 *   Tell the mpegplayer to fast forward
	 */
	private void fforwEvent()
	{
          dontPaint = false;
		if (mpegplayer.isReseted())
			playEvent();
		mpegplayer.fastForward();
		btStop.setEnabled(true);
		lbState.setText("FForw");
	}

	/**
	 *   Tell the mpegplayer to stop and reset
	 */
	public void stopEvent()
	{
            dontPaint = true;
		try {
			mpegplayer.stop();
		} catch (IOException e){
			System.out.println("IOException while try to close the inputstream");
			System.exit(-1);
		}
		btStop.setEnabled(false);
		lbState.setText("Stop");
                screen.setImage(null);
	}

	/**
	 *   Let the user to select a MPEG file name
	 */
	public void openMovie(File file)
	{

		if (!mpegplayer.isReseted())
			stopEvent();

		// Store the name for future use.
		mpegFileName = file.getAbsolutePath();
		btPlay.setEnabled(true);
		btFForw.setEnabled(true);
		btStep.setEnabled(true);
		lbState.setText("Reseted");
                screen.setImage(null); // s inget visas frst...bttre med step ngra gnger?

	}



	/**
	 *   Set the screen's size
	 */
	public void setDisplaySize(int width, int height)
	{
          mpegplayer.displaySizeCalculated(width, height);
	}

	/**
	 *   Set the video image source
	 */
	public void setImageSource(ImageProducer imagesource)
	{
                if (img==null)
      		  img = createImage(imagesource);
                screen.setImage(img);
	}

	/**
	 *   Tell the screen to draw the next image
	 */
	public void nextImage()
	{
		if (img != null) {
                        screen.setImage(img);
		}

	}

	/**
	 *   Update the time information
	 */
	public void updateTime(int hour, int minute, int second)
	{
		lbTime.setText(hour + ":" + minute + ":" + second);
	}

	/**
	 *   Update variables for the frame rate calculation
	 */
	public void updateFrame()
	{
		lbFrame.setText(String.valueOf(count++));
		if (count % 10 == 0) {
			long now = System.currentTimeMillis();
			String speed = String.valueOf(10.0/(now - systime) * 1000.0);
			if (speed.length() >= 5)
				speed = speed.substring(0,4);
			lbSpeed.setText(speed + " f/s");
			systime = now;
		}
	}
}