/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   MpegPlayerProperties.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.applet.*;

public class MpegPlayerProperties extends WobProperties implements Externalizable {
    static final long serialVersionUID = 1234519954521657440L;

    private String fileName = "dummyFileName";
    private boolean supportSound = true;
    private boolean streamed = true;
    private double buffer = 32;
    private int startupMode = 0; // 0==NOTHING, 1==PLAY 2==LOOP
    protected boolean initTargetRect = false; // Set to true when default-file loaded initally, so that target area will be resized.


    public WobPropertiesPanel createWobPropertiesPanel() {
        return new MpegPlayerPropertiesPanel();
    }

    public void writeExternal(ObjectOutput out) {
        try {
            ObjectOutputStream oos = (ObjectOutputStream)out;
            super.writeExternal(oos);
            oos.writeUTF(fileName);
            oos.writeBoolean(supportSound);
            oos.writeBoolean(streamed);
            oos.writeDouble(buffer);
            oos.writeShort(startupMode);
        } catch (Exception e) {e.printStackTrace();}
    }

    public void readExternal(ObjectInput in) {
        try {
            ObjectInputStream ois = (ObjectInputStream)in;
            super.readExternal(ois);
            fileName = (String)ois.readUTF();
            supportSound = ois.readBoolean();
            streamed = ois.readBoolean();
            buffer = ois.readDouble();
            startupMode = ois.readShort();

            if (fileName.equals("dummyFileName")) {
                initTargetRect = true;
                File file = createFileDep(new File(WF.installFolder, "wobs"+File.separator+"wob61"+File.separator+"default.mpg"), 1, true); // Lgg den p id=1
                fileName = file.getName();
            }
        } catch (Exception e) {e.printStackTrace(); if (!e.getMessage().equals("progress")) e.printStackTrace();}
    }

    public void setSound(File mpegFile) {
        File file = createFileDep(mpegFile, 1, true, ((streamed) ? FileDependency.NON_RESOURCE_MANAGED_DEPENDENCY : FileDependency.DYNAMIC_DEPENDENCY)); // Lgg den p id=1
        fileName = file.getName();
    }

    public MpegPlayerProperties() {
        super(); // S att parentBVis blir satt
    }

    public void writeData(DataOutputStream dos) {
        try {
            dos.writeBoolean(streamed);
            dos.writeShort((short)buffer);
            dos.writeShort(startupMode);
            dos.writeUTF(fileName);
            dos.writeBoolean(supportSound);
        } catch (IOException e) {System.out.println(e);}
    }

class MpegPlayerPropertiesPanel extends WobPropertiesPanel implements ActionListener {
    private JButton changeButton;
    private JLabel fileLabel;
    private JLabel frameSizeLabel;
    private JLabel sizeLabel;
    private File mpegFile;
    private P_DisplayFrame playerPanel;
    private JPanel playerPanelContainer;
    private JCheckBox soundCheckBox;
    private JCheckBox streamedCheckBox;
    private JComboBox startupModeComboBox;
    private Dimension frameSize;
    private NumberTextField bufferTextField;
    private JLabel bufferLabel;
    private boolean fileChanged = false;

    public MpegPlayerPropertiesPanel() {
        mpegFile = new File("tmpfiles"+File.separator+fileName);

        JPanel panel = new JPanel();
        setLayout(new FlowLayout());
        add(panel);

        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);

        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.insets = new Insets(5,5,5,5);

        frameSizeLabel = new JLabel("");

        playerPanelContainer = new JPanel();
        playerPanelContainer.setLayout(new BorderLayout());
        openMovie(mpegFile);
        playerPanelContainer.setPreferredSize(playerPanelContainer.getPreferredSize());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        panel.add(playerPanelContainer,gbc);



        JLabel currentLabel = new JLabel("Filename:");
        currentLabel.setForeground(Color.black);
        gbc.anchor = gbc.EAST;
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        panel.add(currentLabel,gbc);

        fileLabel = new JLabel(removeCheckSum(fileName));
        fileLabel.setPreferredSize(new Dimension(170,fileLabel.getPreferredSize().height));
        gbc.anchor = gbc.WEST;
        gbc.gridy = 2;
        gbc.gridx = 1;
        panel.add(fileLabel, gbc);
        gbc.gridwidth = 1;


        JLabel frameSizeNameLabel = new JLabel("Frame size:");
        frameSizeNameLabel.setForeground(Color.black);
        gbc.anchor = gbc.EAST;
        gbc.gridy = 3;
        gbc.gridx = 0;
        panel.add(frameSizeNameLabel,gbc);

        //frameSizeLabel = new JLabel("");
        gbc.anchor = gbc.WEST;
        gbc.gridy = 3;
        gbc.gridx = 1;
        panel.add(frameSizeLabel, gbc);
        gbc.gridwidth = 1;



        JLabel sizeNameLabel = new JLabel("File size:");
        sizeNameLabel.setForeground(Color.black);
        gbc.anchor = gbc.EAST;
        gbc.gridy = 4;
        gbc.gridx = 0;
        panel.add(sizeNameLabel,gbc);

        sizeLabel = new JLabel("");
        gbc.anchor = gbc.WEST;
        gbc.gridy = 4;
        gbc.gridx = 1;
        panel.add(sizeLabel, gbc);
        gbc.gridwidth = 1;



        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = gbc.EAST;
        gbc.gridwidth = 1;
        panel.add(new JLabel("At startup:"), gbc);

        Object[] items = {"Do nothing", "Play", "Loop"};
        startupModeComboBox = new JComboBox(items);
        startupModeComboBox.setSelectedIndex(startupMode);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 10000;
        gbc.fill = gbc.HORIZONTAL;
        gbc.anchor = gbc.WEST;
        gbc.gridwidth = 1;
        panel.add(startupModeComboBox, gbc);


        soundCheckBox = new JCheckBox("Enable sound (extra 45kb)", supportSound);
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.anchor = gbc.WEST;
        gbc.gridwidth = 1;
        panel.add(soundCheckBox, gbc);


        streamedCheckBox = new JCheckBox("Streaming", streamed);
        streamedCheckBox.setActionCommand("stream");
        streamedCheckBox.addActionListener(this);
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.anchor = gbc.WEST;
        gbc.gridwidth = 1;
        panel.add(streamedCheckBox, gbc);


        bufferLabel = new JLabel("Buffer (kb):");
        this.bufferLabel.setEnabled(streamedCheckBox.isSelected());
        bufferLabel.setForeground(Color.black);
        gbc.anchor = gbc.EAST;
        gbc.gridy = 8;
        gbc.gridx = 0;
        panel.add(bufferLabel,gbc);

        bufferTextField = new NumberTextField(""+buffer);
        this.bufferTextField.setEnabled(streamedCheckBox.isSelected());
        bufferTextField.setMax(5000);
        bufferTextField.setMin(0);
        gbc.anchor = gbc.WEST;
        gbc.gridy = 8;
        gbc.gridx = 1;
        panel.add(bufferTextField, gbc);
        gbc.gridwidth = 1;



        changeButton = new JButton("Change Movie...");
        changeButton.addActionListener(this);
        gbc.insets = new Insets(20,5,5,5);
        gbc.gridx = 0;
        gbc.anchor = gbc.CENTER;
        gbc.gridwidth = 2;
        gbc.gridy = 9;
        gbc.fill = gbc.NONE;
        panel.add(changeButton,gbc);

        updateFileLabel();
        fileChanged = false;
    }

    private void openMovie(File mpegFile) {
        this.mpegFile = mpegFile;
        P_MPEGApp player = new P_MPEGApp("");
        playerPanel = player.getPlayerPanel();
        playerPanel.openMovie(mpegFile);
        playerPanelContainer.removeAll();
        playerPanelContainer.add("Center", playerPanel);
        playerPanel.stepEvent();
        frameSize = player.getDisplaySize();
        frameSizeLabel.setText(frameSize.width+"x"+frameSize.height);
        if (propertiesDialog!=null) {
          propertiesDialog.getContentPane().doLayout();
          this.propertiesDialog.pack();
          propertiesDialog.setSize(propertiesDialog.getPreferredSize());
        }
        fileChanged = true;
    }

    private void updateFileLabel() {
      String fileName = mpegFile.getName();
      fileLabel.setText(removeCheckSum(fileName));
      sizeLabel.setText(mpegFile.length()/1024+" kb");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource()==changeButton) {
            playerPanel.stopEvent();
            File selectedFile = null;
            File defaultFolder = WFUtils.getDefaultFolder("video", new File(WF.installFolder, "resources"+File.separator+"video"));
            JFileChooser chooser = new JFileChooser(defaultFolder);

            MyFileFilter filter = new MyFileFilter("mpg","MPEG Movie");
            filter.addExtension("mpeg");

            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(getPropertiesDialog());
            WFUtils.saveDefaultFolder("video", chooser.getSelectedFile());
            if (returnVal == JFileChooser.APPROVE_OPTION) {
                selectedFile = chooser.getSelectedFile();
                openMovie( selectedFile);
                updateFileLabel();
            } else {
                return;
            }
        } else if (e.getActionCommand().equals("stream")) {
            this.bufferLabel.setEnabled(streamedCheckBox.isSelected());
            this.bufferTextField.setEnabled(streamedCheckBox.isSelected());
        }
    }


    public void closed() {
      playerPanel.stopEvent();
      if (initTargetRect) { // Should always be initialized when "first dialog" closed
        initTargetRect = false;
        Dimension displaySize = getWobModel().getParent().getDisplayDimension();
        int x = (displaySize.width-frameSize.width)/2;
        int y = (displaySize.height-frameSize.height)/2;
        Rectangle operatorArea = new Rectangle(x,y,frameSize.width,frameSize.height);
        getWobModel().getOperatorAreaModel().setOperatorArea(operatorArea);
      }
    }

    private String[] audioFiles = {
      "AD_Crc16.class",
      "AD_Decoder$Params.class",
      "AD_Decoder.class",
      "AD_DecoderErrors.class",
      "AD_DecoderException.class",
      "AD_Equalizer$EQFunction.class",
      "AD_Equalizer.class",
      "AD_FrameDecoder.class",
      "AD_Header.class",
      "AD_InputStreamSource.class",
      "AD_JavaLayerError.class",
      "AD_JavaLayerErrors.class",
      "AD_JavaLayerException.class",
      "AD_JavaLayerHook.class",
      "AD_JavaLayerUtils.class",
      "AD_LayerIDecoder$Subband.class",
      "AD_LayerIDecoder$SubbandLayer1.class",
      "AD_LayerIDecoder$SubbandLayer1IntensityStereo.class",
      "AD_LayerIDecoder$SubbandLayer1Stereo.class",
      "AD_LayerIDecoder.class",
      "AD_LayerIIDecoder$SubbandLayer2.class",
      "AD_LayerIIDecoder$SubbandLayer2IntensityStereo.class",
      "AD_LayerIIDecoder$SubbandLayer2Stereo.class",
      "AD_LayerIIDecoder.class",
      "AD_Obuffer.class",
      "AD_OutputChannels.class",
      "AD_Source.class",
      "AD_SynthesisFilter.class",
      "AP_AudioDevice.class",
      "AP_AudioDeviceBase.class",
      "AP_AudioDeviceFactory.class",
      "AP_BigPipedInputStream.class",
      "AP_EightBitAudioDevice.class",
      "AP_EightBitAudioDeviceFactory.class",
      "AP_FactoryRegistry.class",
      "AP_Player.class",
      "AP_JavaSoundAudioDeviceFactory.class",
      "AP_JavaSoundAudioDevice.class"};

    public void apply() {
        this.propertiesDialog.setCursor(new Cursor(Cursor.WAIT_CURSOR));

        supportSound = soundCheckBox.isSelected();
        if (supportSound) {
          for (int i=0; i<audioFiles.length; i++) {
            createFileDep2(audioFiles[i], i+10);
          }
        } else {
          for (int i=0; i<audioFiles.length; i++) {
            removeFileDep(i+10);
          }
        }


        streamed = streamedCheckBox.isSelected();
        startupMode = startupModeComboBox.getSelectedIndex();
        buffer = bufferTextField.getDouble();
        setSound(mpegFile);

        if (fileChanged) {
          Rectangle rect = getWobModel().getOperatorAreaModel().getOperatorArea();
          getWobModel().getOperatorAreaModel().setOperatorArea(new Rectangle(rect.x,rect.y,frameSize.width,frameSize.height));//getWobModel().getOperatorAreaModel().getDefaultDimension());
        }

        this.propertiesDialog.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }
}
}
