/* PhotoOrganizer - CollectionThumbnailsPanel
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.InputStream;
import java.io.IOException;

import javax.swing.*;
import javax.swing.event.MouseInputAdapter;
import javax.swing.tree.*;

import rogatkin.*;
import photoorganizer.formats.*;
import photoorganizer.*;

public class CollectionThumbnailsPanel extends ThumbnailsPanel {
    public CollectionThumbnailsPanel(Controller controller) {
        super(controller);
    }

    void setImageView() {
        imagepanel = (PhotoImagePanel)controller.component(Controller.COMP_IMAGECOLLCTPANEL);
    }
    
    void setCollection(PhotoCollectionPanel collectionpanel) {
        this.collectionpanel = collectionpanel;
    }

    JPopupMenu getRightButtonMenu(ActionListener listener, boolean use_alternative) {
	if (use_alternative)
	    return collectionpanel.getRMouseMenu();
	else
	    return new CollectThumbsRightBtnMenu(listener);
    }

	void doSpecificAction(AbstractFormat format, ActionEvent a, Thumbnail source) {
		String cmd = a.getActionCommand();
		int op;
		if (cmd.equals(Resources.MENU_SHOW)) {
			showFullImage(format, source);
		} else if (cmd.equals(Resources.MENU_DELETE)) {
			collectionpanel.delete(new int[]{collectionpanel.findIndexOf(source)});
		} else if (cmd.equals(Resources.MENU_RENAME)) {
			collectionpanel.rename(new int[]{collectionpanel.findIndexOf(source)});
		} else if (cmd.equals(Resources.MENU_REVERSE_SELECT)) {
			int sel = collectionpanel.findIndexOf(source);
			if (sel >= 0) {
				if (collectionpanel.isRowSelected(sel))
					collectionpanel.removeRowSelectionInterval(sel, sel);
				else
					collectionpanel.addRowSelectionInterval(sel, sel);
				controller.getUiUpdater().notify(collectionpanel.getSelectedRowCount()>0, UiUpdater.SELECTION_SELECTED);
			}
		} else if (cmd.equals(Resources.MENU_PRINT)) {
			controller.print(new File[]{format.getFile()});
		} else if (cmd.equals(Resources.MENU_ADDTOALBUM)) {
			AlbumPane albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
			AlbumSelectionDialog asd = albumpane.getSelectionDialog();
			asd.setTitle(Resources.TITLE_SELECT_ALBUM+":"+format);
			asd.setVisible(true);
			TreePath[] tps = asd.getSelectedAlbums();
			if (tps != null && format instanceof BasicJpeg) {
				// do not mix albums types for a while
				albumpane.addToAlbum(new BasicJpeg[]{ (BasicJpeg)format }, tps);
				Serializer s = controller.getSerializer();
				if (Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.MOVETOFOLDER), 0) == 1 &&
					Serializer.getInt(s.getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.USEALBUMFOLDER), 0) == 1)
					collectionpanel.delete(new int[]{collectionpanel.findIndexOf(source)});
			}
		} else if ((op = Controller.convertCmdToTrnasformOp(cmd)) != -1) {
			collectionpanel.transform(new int[]{collectionpanel.findIndexOf(source)}, op);
		}
	}
    
    class CollectThumbsRightBtnMenu extends JPopupMenu {
        CollectThumbsRightBtnMenu(ActionListener listener) {
            JMenuItem item;
            add(item = new JMenuItem(Resources.MENU_REVERSE_SELECT));
            item.addActionListener(listener);
            add(item = new JMenuItem(Resources.MENU_SHOW));
            item.addActionListener(listener);
            addSeparator();
            add(item = new JMenuItem(Resources.MENU_ADDTOALBUM));
            item.addActionListener(listener);
            add(item = new JMenuItem(Resources.MENU_RENAME));
            item.addActionListener(listener);
            add(item = new JMenuItem(Resources.MENU_DELETE));
            item.addActionListener(listener);
            addSeparator();
            add(item = new JMenuItem(Resources.MENU_PRINT));
            item.addActionListener(listener);
            addSeparator();
            this.add(Controller.createTransformMenu(listener));
            addSeparator();
            add(item = new JMenuItem(Resources.MENU_PROPERTIES));
            item.addActionListener(listener); // setPopupSize(this.getPreferredSize());
        }
    }
}