/* PhotoOrganizer - AlbumSelectionPanel 
 * Copyright (C) 1999-2000 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package photoorganizer.renderer;

import javax.swing.*;
import javax.swing.event.ChangeListener;
import javax.swing.event.ChangeEvent;
import java.awt.event.*;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.album.*;
import photoorganizer.directory.JDirectoryChooser;

public class AlbumOptionsTab extends JPanel implements ActionListener, Persistable {
    public final static String SECNAME = "AlbumOptions";
    public final static String DRIVER = "JDBCDriver";
    public final static String DBURL = "DatabaseURL";
    public final static String USER = "User";
    public final static String PSWD = "Password";
    public final static String USEALBUMFOLDER = "AlbumFolders";
    public final static String MOVETOFOLDER = "MoveToAlbum";
    public final static String IGNORE_DB_ERR = "IgnoreDatabaseErrors";
    public final static String ALBUMROOT = "AlbumRoot";
	public final static String USEENCODING = "UseEncoding";

    public final static String DEFAULT_JDBC_DRIVER = "com.ms.jdbc.odbc.JdbcOdbcDriver";
    public final static String DEFAULT_DB_URL = "jdbc:odbc:"+PhotoOrganizer.PROGRAMNAME;

	public AlbumOptionsTab(Controller controller) {
		this.controller = controller;
		setLayout(new GranulatedLayout(7, Resources.CTRL_VERT_PREF_SIZE, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
		add(new JLabel(Resources.LABEL_JDBCDRV_CLASS), "0,0,3");
		add(tf_driver_class = new JTextField(), "0,1,5");
		add(new JLabel(Resources.LABEL_DATABASE_URL), "0,2,2");
		add(tf_db_url = new JTextField(), "0,3,5");
		add(new JLabel(Resources.LABEL_USER), "5,0,1");
		add(tf_db_user = new JTextField(), "5,1,2");
		//tf_db_user.setFont(new java.awt.Font("Arial Cyr", java.awt.Font.PLAIN, 12));
		//canDisplayUpTo
		add(new JLabel(Resources.LABEL_PASSWORD), "5,2,2");
		add(tf_db_pswd = new JPasswordField(), "5,3,2");
		add(cb_nowarn = new JCheckBox(Resources.LABEL_NOJDBCWARN), "0,4,3");
		JButton btn;
		add(btn = new JButton(Resources.CMD_CREATEDB), "3,4,2");
		btn.addActionListener(this);
		add(btn = new JButton(Resources.CMD_INITJDBC), "5,4,2");
		btn.addActionListener(this);
		add(cb_maintaindir = new JCheckBox(Resources.LABEL_USE_DIRALBUM), "0,5,2");
		add(tf_album_root = new JTextField(), "2,5,4");
		add(bt_browse = new JButton(Resources.CMD_BROWSE), "6,5,1");
		bt_browse.addActionListener(this);
		add(cb_moveto = new JCheckBox(Resources.LABEL_MOVETO_ALBUM), "0,6,3");
		add(cb_useEnc = new JCheckBox(Resources.LABEL_ENC_FOR_CMT), "3,6,3");
		cb_maintaindir.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
			boolean enabled = ((AbstractButton)e.getSource()).isSelected();
			tf_album_root.setEnabled(enabled);
			bt_browse.setEnabled(enabled);
			cb_moveto.setEnabled(enabled);
			}
			});
		albumpane = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
	}
    
	public void actionPerformed(ActionEvent a) {
		String cmd = a.getActionCommand();
		Access access = albumpane.access;
		if (Resources.CMD_CREATEDB.equals(cmd)) {
			if (JOptionPane.showConfirmDialog(this,
				Resources.LABEL_COFIRMDROPTABLE, Resources.TITLE_COFIRMATION,
				JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION) {
				access.forgetTables();
				access.createTables();
				albumpane.invalidateTree();
			}
		} else if (Resources.CMD_INITJDBC.equals(cmd)) {
			reloadDriver();
		} else if (Resources.CMD_BROWSE.equals(cmd)) {
			JDirectoryChooser dc = new JDirectoryChooser(new JFrame(), tf_album_root.getText(), null);
			if (dc.getDirectory() != null)
				tf_album_root.setText(dc.getDirectory());
		}
	}

	private void reloadDriver() {
		// overide error handling
		int saveErrHand = Serializer.getInt(controller.getSerializer().getProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.IGNORE_DB_ERR), 0);
		controller.getSerializer().setProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.IGNORE_DB_ERR, Resources.I_NO);
		albumpane.access.init();
		controller.getSerializer().setProperty(AlbumOptionsTab.SECNAME, AlbumOptionsTab.IGNORE_DB_ERR, new Integer(saveErrHand));
		albumpane.invalidateTree();
	}
    
    public void load() {
        Serializer s = controller.getSerializer();
        String p = (String)s.getProperty(SECNAME, DRIVER);
        if (p!=null && p.length() >0)
            tf_driver_class.setText(p);
        else
            tf_driver_class.setText(DEFAULT_JDBC_DRIVER);
        p = (String)s.getProperty(SECNAME, DBURL);
        if (p!=null && p.length() >0)
            tf_db_url.setText(p);
        else
            tf_db_url.setText(DEFAULT_DB_URL);
        p = (String)s.getProperty(SECNAME, USER);
        if (p!=null && p.length() >0)
            tf_db_user.setText(p);
        p = (String)s.getProperty(SECNAME, PSWD);
        if (p!=null)
            tf_db_pswd.setText(p);
        cb_nowarn.setSelected(Serializer.getInt(s.getProperty(SECNAME, IGNORE_DB_ERR), 0) == 1);
        cb_maintaindir.setSelected(Serializer.getInt(s.getProperty(SECNAME, USEALBUMFOLDER), 0) == 1);
        cb_moveto.setSelected(Serializer.getInt(s.getProperty(SECNAME, MOVETOFOLDER), 0) == 1);
		cb_useEnc.setSelected(Serializer.getInt(s.getProperty(SECNAME, USEENCODING), 0) == 1);
        p = (String)s.getProperty(SECNAME, ALBUMROOT);
        if (p!=null)
            tf_album_root.setText(p);
    }
    
	public void save() {
		Serializer s = controller.getSerializer();
		boolean needReload = false;
		String p = (String)s.getProperty(SECNAME, DRIVER);
		needReload |= p != null && !p.equalsIgnoreCase(tf_driver_class.getText());
		s.setProperty(SECNAME, DRIVER, tf_driver_class.getText());
		if (!needReload) {
			p = (String)s.getProperty(SECNAME, DBURL);
			needReload |= p != null && !p.equalsIgnoreCase(tf_db_url.getText());
		}
		s.setProperty(SECNAME, DBURL, tf_db_url.getText());
		if (!needReload) {
			p = (String)s.getProperty(SECNAME, USER);
			needReload |= p != null && !p.equalsIgnoreCase(tf_db_user.getText());
		}
		s.setProperty(SECNAME, USER, tf_db_user.getText());
		if (!needReload) {
			p = (String)s.getProperty(SECNAME, PSWD);
			needReload |= p != null && !p.equalsIgnoreCase(tf_db_pswd.getText());
		}
		s.setProperty(SECNAME, PSWD, new String(tf_db_pswd.getPassword()));
		// check if something above was changed, do reload driver
		s.setProperty(SECNAME, IGNORE_DB_ERR, cb_nowarn.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, USEALBUMFOLDER, cb_maintaindir.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, MOVETOFOLDER, cb_moveto.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, USEENCODING, cb_useEnc.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, ALBUMROOT, tf_album_root.getText());
		if (needReload)
			reloadDriver();
	}
	
    Controller controller;
    AlbumPane albumpane;
    JTextField tf_driver_class, tf_db_url, tf_db_user, tf_album_root;
    JPasswordField tf_db_pswd;
    JCheckBox cb_nowarn, cb_maintaindir, cb_moveto, cb_useEnc;
    JButton bt_browse;
}