/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.TagContent;

class BinaryFrame {
    protected ID3v2 id3v2;
    protected String type;
    protected TagContent content;
    protected boolean use_compression;
    protected ID3v2Frame frame;

    public BinaryFrame(ID3v2 iD3v2, String string, TagContent tagContent, boolean bl) {
        this.id3v2 = iD3v2;
        this.type = string;
        this.content = tagContent;
        this.use_compression = bl;
        byte[] byArray = tagContent.getBinaryContent();
        try {
            this.frame = new ID3v2Frame(string, byArray, false, false, false, bl ? (byte)2 : 0, 0, 0);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            // empty catch block
        }
    }

    public void write() {
        try {
            this.id3v2.removeFrame(this.type);
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        this.id3v2.addFrame(this.frame);
    }

    public static TagContent read(ID3v2 iD3v2, String string) throws FrameDamagedException {
        TagContent tagContent = new TagContent();
        try {
            byte[] byArray = ((ID3v2Frame)iD3v2.getFrame(string).elementAt(0)).getContent();
            tagContent.setContent(byArray);
        }
        catch (ID3v2Exception iD3v2Exception) {
        }
        catch (Exception exception) {
            throw new FrameDamagedException();
        }
        return tagContent;
    }
}

