/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.directory;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import photoorganizer.Controller;
import photoorganizer.IrdControllable;
import photoorganizer.Resources;
import photoorganizer.directory.AbstractCellEditor;
import photoorganizer.directory.AbstractTreeTableModel;
import photoorganizer.directory.FileNode;
import photoorganizer.directory.FileSystemModel;
import photoorganizer.directory.TreeTableModel;
import photoorganizer.directory.TreeTableModelAdapter;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.MP3;
import photoorganizer.formats.MediaFormatFactory;
import photoorganizer.media.PlaybackRequest;
import photoorganizer.renderer.AlbumPane;
import photoorganizer.renderer.AlbumSelectionDialog;
import photoorganizer.renderer.FastMenu;
import photoorganizer.renderer.Id3TagEditor;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.PhotoImagePanel;
import photoorganizer.renderer.PropertiesPanel;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.StatusBar;
import photoorganizer.renderer.ThumbnailsPanel;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class JTreeTable
extends JTable
implements ActionListener,
Persistable,
IrdControllable {
    static final String SECNAME = "JTreeTable";
    static final String COLWIDTH = "ColumnWidthes";
    static final String DRIVE = "Drive";
    protected TreeTableCellRenderer tree;
    private PhotoImagePanel imagepanel;
    private ThumbnailsPanel thumbnailspanel;
    private PhotoCollectionPanel collectionpanel;
    private AlbumPane albumpanel;
    private Controller controller;
    static /* synthetic */ Class class$photoorganizer$directory$TreeTableModel;

    public JTreeTable(TreeTableModel treeTableModel, Controller controller) {
        this.controller = controller;
        this.imagepanel = (PhotoImagePanel)controller.component(Controller.COMP_IMAGEPANEL);
        this.thumbnailspanel = (ThumbnailsPanel)controller.component(Controller.COMP_THUMBPANEL);
        this.collectionpanel = (PhotoCollectionPanel)controller.component(Controller.COMP_COLLECTION);
        this.albumpanel = (AlbumPane)controller.component(Controller.COMP_ALBUMPANEL);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (JTreeTable.this.isRowSelected(listSelectionEvent.getLastIndex()) || JTreeTable.this.isRowSelected(listSelectionEvent.getFirstIndex())) {
                    FileNode[] fileNodeArray = JTreeTable.this.getSelectedNodes();
                    if (fileNodeArray != null) {
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        AbstractFormat[] abstractFormatArray = new AbstractFormat[fileNodeArray.length];
                        int n = 0;
                        while (n < fileNodeArray.length) {
                            abstractFormatArray[n] = fileNodeArray[n].getFormat();
                            bl2 |= abstractFormatArray[n] instanceof BasicJpeg;
                            bl3 |= abstractFormatArray[n] instanceof MP3;
                            bl |= fileNodeArray[n].getFile().isDirectory();
                            bl4 |= fileNodeArray[n].getFile().isFile();
                            ++n;
                        }
                        JTreeTable.this.setCursor(Controller.WAIT_CURSOR);
                        if (bl) {
                            Vector vector = new Vector(10);
                            JTreeTable.this.buildFormatList(fileNodeArray, vector, true);
                            JTreeTable.this.controller.getUiUpdater().notify(JTreeTable.this.thumbnailspanel.updateMedias(vector.toArray(new AbstractFormat[vector.size()])), 1);
                        } else {
                            JTreeTable.this.controller.getUiUpdater().notify(JTreeTable.this.thumbnailspanel.updateMedias(abstractFormatArray), 1);
                        }
                        JTreeTable.this.controller.updateCaption((abstractFormatArray[0] != null ? abstractFormatArray[0].toString() : fileNodeArray[0].toString()) + (abstractFormatArray.length > 1 ? "..." : ""));
                        JTreeTable.this.controller.getUiUpdater().notify(bl, 3);
                        JTreeTable.this.controller.getUiUpdater().notify(bl2, 5);
                        JTreeTable.this.controller.getUiUpdater().notify(bl3, 4);
                        JTreeTable.this.controller.getUiUpdater().notify(bl4, 1);
                        JTreeTable.this.setCursor(Controller.DEFAULT_CURSOR);
                    }
                } else {
                    JTreeTable.this.controller.getUiUpdater().notify(false, 1);
                    JTreeTable.this.controller.getUiUpdater().notify(false, 3);
                    JTreeTable.this.controller.getUiUpdater().notify(false, 5);
                    JTreeTable.this.controller.getUiUpdater().notify(false, 4);
                }
            }
        });
        this.setDefaultRenderer(class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel, this.tree);
        this.setDefaultEditor(class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    Point point = ((JViewport)JTreeTable.this.getParent()).getViewPosition();
                    FastMenu fastMenu = new FastMenu(JTreeTable.this, JTreeTable.this.controller);
                    fastMenu.add(new JPopupMenu.Separator());
                    JMenuItem jMenuItem = new JMenuItem("Annotation");
                    fastMenu.add(jMenuItem);
                    jMenuItem.addActionListener(JTreeTable.this);
                    jMenuItem.setEnabled(JTreeTable.this.controller.getUiUpdater().isEnabled(4));
                    fastMenu.add(new JPopupMenu.Separator());
                    jMenuItem = new JMenuItem("Change drive");
                    fastMenu.add(jMenuItem);
                    jMenuItem.addActionListener(JTreeTable.this);
                    fastMenu.show(JTreeTable.this.getParent(), mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
                } else if (mouseEvent.getClickCount() == 2) {
                    JTreeTable.this.actionPerformed(new ActionEvent(this, 0, "Show/Play"));
                }
            }
        });
        this.setMinimumSize(Resources.MIN_PANEL_DIMENSION);
    }

    FileNode[] getSelectedNodes() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        FileNode[] fileNodeArray = new FileNode[treePathArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < treePathArray.length) {
            Object object = treePathArray[n2].getLastPathComponent();
            if (object instanceof FileNode) {
                fileNodeArray[n++] = (FileNode)object;
            }
            ++n2;
        }
        return fileNodeArray;
    }

    File[] getSelectedFiles() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            return null;
        }
        File[] fileArray = new File[treePathArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < treePathArray.length) {
            Object object = treePathArray[n2].getLastPathComponent();
            if (object instanceof FileNode) {
                fileArray[n++] = ((FileNode)object).getFile();
            }
            ++n2;
        }
        return fileArray;
    }

    public void fireDriveChanged() {
        FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
        Object[] objectArray = fileSystemModel.getRoots();
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                vector.addElement(objectArray[n]);
            }
            ++n;
        }
        objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        Object object = JOptionPane.showInputDialog(this, "Choose drive", "Change current drive", 1, null, objectArray, objectArray[0]);
        if (object == null) {
            return;
        }
        fileSystemModel.setRoot(new FileNode((File)object));
        fileSystemModel.fireTreeStructureChanged(this, new Object[]{object}, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Change drive") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("Change drive")) {
            this.fireDriveChanged();
            return;
        }
        Object[] objectArray = this.getSelectedFiles();
        if (objectArray == null) {
            return;
        }
        TreePath treePath = this.tree.getSelectionPath().getParentPath();
        if (string.equals("Properties...")) {
            AbstractFormat abstractFormat = this.getFirstSelectedMedia();
            if (abstractFormat != null) {
                PropertiesPanel.showProperties(abstractFormat, this.controller);
            }
            return;
        }
        if (string.equals("To selection") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("To selection")) {
            this.collectionpanel.add(new PlaybackRequest(objectArray, this.controller.getSerializer()));
            return;
        }
        if (string.equals("To album")) {
            AlbumPane albumPane = (AlbumPane)this.controller.component(Controller.COMP_ALBUMPANEL);
            AlbumSelectionDialog albumSelectionDialog = albumPane.getSelectionDialog();
            albumSelectionDialog.setTitle("Albums selection for - :" + objectArray[0] + (objectArray.length == 1 ? "" : "..."));
            albumSelectionDialog.setVisible(true);
            TreePath[] treePathArray = albumSelectionDialog.getSelectedAlbums();
            if (treePathArray != null) {
                Vector vector = new Vector();
                this.buildFormatList((File[])objectArray, vector, true);
                this.albumpanel.addToAlbum(vector.toArray(new AbstractFormat[vector.size()]), treePathArray);
            }
        } else if (string.equals("Rename")) {
            FileNode[] fileNodeArray = this.getSelectedNodes();
            int n = 0;
            while (n < fileNodeArray.length) {
                Object object = fileNodeArray[n].getFile().getName();
                AbstractFormat abstractFormat = fileNodeArray[n].getFormat();
                Serializer serializer = this.controller.getSerializer();
                if (abstractFormat != null && abstractFormat.isValid()) {
                    if (Serializer.getInt((Object)serializer.getProperty((Object)"RenameOptions", (Object)"AskEdit"), (int)0) == 0) {
                        abstractFormat.renameTo(new File(fileNodeArray[n].getFile().getParent(), FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(abstractFormat, this.controller))));
                    } else {
                        object = fileNodeArray[n].getFile().getParent() + File.separatorChar + FileNameFormat.makeValidPathName(RenameOptionsTab.getNewName(abstractFormat, this.controller));
                        if ((object = JOptionPane.showInputDialog(this, "New name", "Rename", 3, null, null, object)) != null) {
                            abstractFormat.renameTo(new File(object.toString()));
                        }
                    }
                } else if ((object = JOptionPane.showInputDialog(this, "New name", "Rename", 3, null, null, object)) != null) {
                    fileNodeArray[n].getFile().renameTo(new File(object.toString()));
                }
                ++n;
            }
        } else if (string.equals("Delete")) {
            int n = 0;
            while (n < objectArray.length) {
                if (0 == JOptionPane.showConfirmDialog(this, ((File)objectArray[n]).getName() + "- will be removed permanently.\nAre you sure?", "Delete", 0, 2) && !((File)objectArray[n]).delete()) {
                    ((StatusBar)this.controller.component(Controller.COMP_STATUSBAR)).flashInfo("Cannot delete " + objectArray[n], true);
                }
                ++n;
            }
        } else {
            AbstractFormat abstractFormat;
            if (string.equals("Print")) {
                this.controller.print((File[])objectArray);
                return;
            }
            if (string.equals("Show/Play") || actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getToolTipText().equals("Show/Play")) {
                AbstractFormat abstractFormat2 = this.getFirstSelectedMedia();
                if (abstractFormat2 != null && abstractFormat2.isValid() && abstractFormat2 instanceof BasicJpeg) {
                    this.imagepanel.updateView((BasicJpeg)abstractFormat2);
                    this.controller.updateCaption(((File)objectArray[0]).toString());
                } else {
                    new PlaybackRequest(objectArray).playList(this.controller);
                }
                return;
            }
            if (string.equals("Annotation") && (abstractFormat = this.getFirstSelectedMedia()) instanceof MP3) {
                Id3TagEditor.editTag(this.controller, abstractFormat);
            }
        }
        ((AbstractTreeTableModel)this.tree.getModel()).fireTreeStructureChanged(this, treePath.getPath(), null, null);
    }

    protected AbstractFormat getFirstSelectedMedia() {
        FileNode[] fileNodeArray = this.getSelectedNodes();
        if (fileNodeArray != null) {
            int n = 0;
            while (n < fileNodeArray.length) {
                AbstractFormat abstractFormat = fileNodeArray[n].getFormat();
                if (abstractFormat != null && abstractFormat.isValid()) {
                    return abstractFormat;
                }
                ++n;
            }
        }
        return null;
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$photoorganizer$directory$TreeTableModel == null ? (class$photoorganizer$directory$TreeTableModel = JTreeTable.class$("photoorganizer.directory.TreeTableModel")) : class$photoorganizer$directory$TreeTableModel) ? -1 : this.editingRow;
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Integer[] integerArray = new Integer[this.getColumnCount()];
        int n = 0;
        while (n < integerArray.length) {
            try {
                integerArray[n] = new Integer(this.getColumn(this.getColumnName(n)).getWidth());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                integerArray[n] = Resources.I_NO;
            }
            ++n;
        }
        serializer.setProperty((Object)SECNAME, (Object)COLWIDTH, (Object)integerArray);
        FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
        FileNode fileNode = (FileNode)fileSystemModel.getRoot();
        serializer.setProperty((Object)SECNAME, (Object)DRIVE, (Object)fileNode);
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray = (Object[])serializer.getProperty((Object)SECNAME, (Object)COLWIDTH);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.getColumn(this.getColumnName(n)).setWidth((Integer)objectArray[n]);
            this.getColumn(this.getColumnName(n)).setPreferredWidth((Integer)objectArray[n]);
            ++n;
        }
        Object object = serializer.getProperty((Object)SECNAME, (Object)DRIVE);
        if (object != null) {
            FileSystemModel fileSystemModel = (FileSystemModel)this.tree.getModel();
            File file = new File(object.toString());
            if (!file.exists()) {
                file = fileSystemModel.findFirstDrive();
            }
            fileSystemModel.setRoot(new FileNode(file));
            fileSystemModel.fireTreeStructureChanged(this, new Object[]{file}, null, null);
            this.revalidate();
            this.repaint();
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public String getName() {
        return "Browser";
    }

    public String toString() {
        return this.getName();
    }

    public Iterator getKeyMnemonics() {
        return Arrays.asList(new Object[0]).iterator();
    }

    public boolean doAction(String string) {
        return false;
    }

    public void bringOnTop() {
        this.controller.selectTab("Browse");
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            int n = this.getColumnCount() - 1;
            while (n >= 0) {
                if (this.getColumnClass(n) == (class$photoorganizer$directory$TreeTableModel == null ? JTreeTable.class$("photoorganizer.directory.TreeTableModel") : class$photoorganizer$directory$TreeTableModel)) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
                --n;
            }
        }
        return false;
    }

    protected void buildFormatList(FileNode[] fileNodeArray, Vector vector, boolean bl) {
        int n = 0;
        while (n < fileNodeArray.length) {
            FileNode[] fileNodeArray2 = (FileNode[])fileNodeArray[n].getChildren();
            if (bl && fileNodeArray2 != null) {
                this.buildFormatList(fileNodeArray2, vector, false);
            } else {
                vector.addElement(fileNodeArray[n].getFormat());
            }
            ++n;
        }
    }

    protected void buildFormatList(File[] fileArray, Vector vector, boolean bl) {
        int n = 0;
        while (n < fileArray.length) {
            if (bl && fileArray[n].isDirectory()) {
                this.buildFormatList(fileArray[n].listFiles(), vector, bl);
            } else {
                AbstractFormat abstractFormat = MediaFormatFactory.createMediaFormat(fileArray[n]);
                if (abstractFormat != null && abstractFormat.isValid()) {
                    vector.addElement(abstractFormat);
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this;
        }
    }
}

