/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import photoorganizer.Controller;
import photoorganizer.IrdControllable;
import photoorganizer.PhotoPlugin;
import photoorganizer.Resources;
import photoorganizer.Upgrader;
import photoorganizer.directory.FileSystemModel;
import photoorganizer.directory.JTreeTable;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.ird.IrdReceiver;
import photoorganizer.renderer.MediaPlayerPanel;
import photoorganizer.renderer.MiscellaneousOptionsTab;
import photoorganizer.renderer.PhotoCollectionPanel;
import photoorganizer.renderer.RipperPanel;
import photoorganizer.renderer.StatusBar;
import rogatkin.Program;
import rogatkin.Serializer;

public class PhotoOrganizer
extends JFrame
implements Program,
IrdControllable {
    public static final String PROGRAMNAME = "MediaChest";
    public static final String VERSION = "version 1.1";
    public static final int BUILD = 74;
    public static final String COPYRIGHT = "Copyright \u00a9 1999-2001 Dmitriy Rogatkin";
    public static final String DEDICATED = "For my wife Olga";
    public static final String HOME_PAGE = "http://mediachest.sourceforge.net/MediaChest.html";
    public static final String BASE_URL = "http://mediachest.sourceforge.net/";
    public static final String KEY_BROWSE = "Browse";
    public static final String KEY_SELECTION = "Selection";
    public static final String KEY_ALBUM = "Album";
    static final String SECNAME = "MediaChest";
    public static final String BOUNDS = "Bounds";
    public static final String DIVIDERDIR = "DividerBrowsePos";
    public static final String DIVIDERCOL = "DividerCollectionPos";
    public static final String DIVIDERALBUM = "DividerAlbumPos";
    public static final String DIVIDERRIPPER = "DividerRipperPos";
    public static final String TB_ORIENT = "ToolBarOrientation";
    private Controller controller;
    private Map irdKeyMap;

    public static void main(String[] stringArray) {
        new PhotoOrganizer();
    }

    public PhotoOrganizer() {
        Object object;
        try {
            System.setErr(new PrintStream(new FileOutputStream("MediaChest.log"), true));
        }
        catch (IOException iOException) {
            System.err.println("MediaChest: Can not redefine error stream.");
        }
        FlashWindow flashWindow = new FlashWindow();
        this.controller = new Controller(this);
        this.controller.updateCaption(null);
        this.setIconImage(this.controller.getMainIcon());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PhotoOrganizer.this.controller.close();
                PhotoOrganizer.this.dispose();
                super.windowClosing(windowEvent);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.irdKeyMap = new Hashtable();
        boolean bl = true;
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.StatusBar", Controller.COMP_STATUSBAR);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.PhotoImagePanel", Controller.COMP_IMAGEPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.PhotoImagePanel", Controller.COMP_IMAGECOLLCTPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.PhotoImagePanel", Controller.COMP_IMAGEALBUMPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.CollectionThumbnailsPanel", Controller.COMP_THUMBCOLLCTPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.AlbumPane", Controller.COMP_ALBUMPANEL);
        this.irdKeyMap.put(KEY_ALBUM, Controller.COMP_ALBUMPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.PhotoCollectionPanel", Controller.COMP_COLLECTION);
        this.irdKeyMap.put(KEY_SELECTION, Controller.COMP_COLLECTION);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.WebAlbumPane", Controller.COMP_WEBALBUMPANEL);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.ThumbnailsPanel", Controller.COMP_THUMBPANEL);
        this.controller.add(new JTreeTable(new FileSystemModel(this.controller), this.controller), Controller.COMP_DIRTREE);
        this.irdKeyMap.put(KEY_BROWSE, Controller.COMP_DIRTREE);
        bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.AlbumThumbnailsPanel", Controller.COMP_ALBUMTHUMBPANEL);
        if (!(bl &= this.controller.add(this.getClass().getPackage().getName() + ".renderer.RipperPanel", Controller.COMP_RIPPERPANEL))) {
            JOptionPane.showMessageDialog(null, "Some of major components could not be initialized, watch for upgrades.", "Error", 1);
            new Upgrader(this.controller);
            System.exit(255);
        }
        Serializer serializer = this.controller.getSerializer();
        Object object2 = serializer.getProperty((Object)"MiscellaneousOptions", (Object)"L&F");
        try {
            if (object2 != null) {
                UIManager.setLookAndFeel(object2.toString());
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            System.err.println(object2 + " L&F is not supported.");
        }
        catch (Exception exception) {
            System.err.println("Can not instantiate " + object2 + " " + exception);
        }
        boolean bl2 = Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"SplitVertically"), (int)1) == 1;
        final JTabbedPane jTabbedPane = new JTabbedPane(Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"TabPosition"), (int)3));
        JScrollPane jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_ALBUMTHUMBPANEL));
        JTabbedPane jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab(KEY_ALBUM, null, new JScrollPane(this.controller.component(Controller.COMP_ALBUMPANEL)), "Use it to view content of your photo albums", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGEALBUMPANEL), "Use it to see original sized image", 1);
        JSplitPane jSplitPane = new JSplitPane(bl2 ? 0 : 1, true, jTabbedPane2, jScrollPane);
        jTabbedPane.insertTab(KEY_ALBUM, null, jSplitPane, "Viewing and creation photo albums", 0);
        jSplitPane.setOneTouchExpandable(true);
        jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab(KEY_SELECTION, null, new JScrollPane(this.controller.component(Controller.COMP_COLLECTION)), "Use it to navigate through your selection structure", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGECOLLCTPANEL), "Use it to see original sized image", 1);
        jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_THUMBCOLLCTPANEL));
        jSplitPane = new JSplitPane(bl2 ? 0 : 1, true, jTabbedPane2, jScrollPane);
        jTabbedPane.insertTab(KEY_SELECTION, null, jSplitPane, "Use it to place your selection", 1);
        jSplitPane.setOneTouchExpandable(true);
        jTabbedPane2 = new JTabbedPane(2);
        jTabbedPane2.insertTab("Directory", null, new JScrollPane(this.controller.component(Controller.COMP_DIRTREE)), "Use it to navigate through your directory structure", 0);
        jTabbedPane2.insertTab("Image", null, this.controller.component(Controller.COMP_IMAGEPANEL), "Use it to see original sized image", 1);
        jScrollPane = new JScrollPane(this.controller.component(Controller.COMP_THUMBPANEL));
        jTabbedPane.insertTab(KEY_BROWSE, null, new JSplitPane(bl2 ? 0 : 1, true, jTabbedPane2, jScrollPane), "Use it to navigate through your directory structure", 2);
        jTabbedPane.insertTab("Ripper", null, this.controller.component(Controller.COMP_RIPPERPANEL), "Allows to create audio, MP3, photo and mixed disk images", 3);
        boolean bl3 = Serializer.getInt((Object)serializer.getProperty((Object)"plugins", (Object)"allDisabled"), (int)0) == 0;
        int n = 1;
        while (bl3) {
            object = (String)serializer.getProperty((Object)"plugins", (Object)("class" + n));
            if (object == null) break;
            if (Serializer.getInt((Object)serializer.getProperty((Object)"plugins", (Object)"disabled1"), (int)0) != 1) {
                String string = (String)serializer.getProperty((Object)"plugins", (Object)("name" + n));
                if (string == null) {
                    string = "plug-in" + n;
                }
                if (this.controller.add((String)object, string)) {
                    jTabbedPane.insertTab(string, null, this.controller.component(string), (String)serializer.getProperty((Object)"plugins", (Object)("tooltip" + n)), jTabbedPane.getTabCount());
                } else {
                    System.err.println("The plug-in " + (String)object + " has not been added, see exceptions above.");
                }
            }
            ++n;
        }
        jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JComponent jComponent = null;
                try {
                    jComponent = ((PhotoPlugin)((Object)jTabbedPane.getSelectedComponent())).getStatusBar();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                ((StatusBar)PhotoOrganizer.this.controller.component(Controller.COMP_STATUSBAR)).setCustomStatus(jComponent);
            }
        });
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.pack();
        this.load();
        try {
            object = new IrdReceiver();
            ((IrdReceiver)object).init();
            if (((IrdReceiver)object).getPort() != null) {
                this.controller.add((Component)object, Controller.COMP_REMOTERECEIVER);
                ((IrdReceiver)object).register(this);
                ((IrdReceiver)object).register(MediaPlayerPanel.getIrdControllable());
                ((IrdReceiver)object).register((IrdControllable)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
                ((IrdReceiver)object).register((IrdControllable)((Object)this.controller.component(Controller.COMP_COLLECTION)));
                ((IrdReceiver)object).register((IrdControllable)((Object)this.controller.component(Controller.COMP_DIRTREE)));
                int n2 = 0;
                while (n2 < jTabbedPane.getTabCount()) {
                    Component component = jTabbedPane.getComponentAt(n2);
                    if (component instanceof IrdControllable) {
                        ((IrdReceiver)object).register((IrdControllable)((Object)component));
                    }
                    ++n2;
                }
                ((IrdReceiver)object).standBy(serializer);
                ((IrdReceiver)object).setOnTop(this);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception " + throwable + " in initializing of IRD receiver, the functionality will be suspended.");
        }
        this.setVisible(true);
        this.controller.load();
        this.controller.getUiUpdater().reset();
        flashWindow.dispose();
        new Upgrader(this.controller);
    }

    public void setTitle(String string) {
        super.setTitle(string + " - " + "MediaChest" + " " + VERSION);
    }

    public String getName() {
        return "MediaChest";
    }

    public String toString() {
        return this.getName();
    }

    public String getVersion() {
        return VERSION;
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        Rectangle rectangle = this.getBounds();
        Integer[] integerArray = new Integer[]{new Integer(rectangle.x), new Integer(rectangle.y), new Integer(rectangle.width), new Integer(rectangle.height)};
        serializer.setProperty((Object)"MediaChest", (Object)BOUNDS, (Object)integerArray);
        JSplitPane jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(2);
        serializer.setProperty((Object)"MediaChest", (Object)DIVIDERDIR, (Object)new Integer(jSplitPane.getDividerLocation()));
        jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(1);
        serializer.setProperty((Object)"MediaChest", (Object)DIVIDERCOL, (Object)new Integer(jSplitPane.getDividerLocation()));
        jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(0);
        serializer.setProperty((Object)"MediaChest", (Object)DIVIDERALBUM, (Object)new Integer(jSplitPane.getDividerLocation()));
        jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(3);
        serializer.setProperty((Object)"MediaChest", (Object)DIVIDERRIPPER, (Object)new Integer(jSplitPane.getDividerLocation()));
        serializer.setProperty((Object)"RenameOptions", (Object)"Counter", (Object)new Integer(FileNameFormat.counter));
        int n = 0;
        while (n < this.getContentPane().getComponentCount()) {
            Component component = this.getContentPane().getComponent(n);
            if (component instanceof JToolBar) {
                serializer.setProperty((Object)"MediaChest", (Object)TB_ORIENT, (Object)new Integer(((JToolBar)component).getOrientation()));
            }
            ++n;
        }
    }

    public void load() {
        Object[] objectArray;
        String string;
        Serializer serializer = this.controller.getSerializer();
        Object[] objectArray2 = (Object[])serializer.getProperty((Object)"MediaChest", (Object)BOUNDS);
        if (objectArray2 != null && objectArray2.length == 4 && objectArray2[0] instanceof Integer) {
            this.setBounds((Integer)objectArray2[0], (Integer)objectArray2[1], (Integer)objectArray2[2], (Integer)objectArray2[3]);
        }
        JSplitPane jSplitPane = null;
        Integer n = (Integer)serializer.getProperty((Object)"MediaChest", (Object)DIVIDERDIR);
        if (n != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(2);
            jSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)serializer.getProperty((Object)"MediaChest", (Object)DIVIDERCOL)) != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(1);
            jSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)serializer.getProperty((Object)"MediaChest", (Object)DIVIDERALBUM)) != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(0);
            jSplitPane.setDividerLocation(n);
        }
        if ((n = (Integer)serializer.getProperty((Object)"MediaChest", (Object)DIVIDERRIPPER)) != null) {
            jSplitPane = (JSplitPane)((JTabbedPane)this.getContentPane().getComponent(0)).getComponentAt(3);
            jSplitPane.setDividerLocation(n);
        }
        if (Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"MenuBar"), (int)1) == 1) {
            this.setJMenuBar(this.createMenu());
        } else {
            this.getContentPane().getComponent(0).addMouseListener(new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) > 0) {
                        new ROptionsMenu().show(PhotoOrganizer.this, mouseEvent.getX(), PhotoOrganizer.this.controller.adjustMenuY(mouseEvent.getY(), 230));
                    }
                }
            });
        }
        if (Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"ToolBar"), (int)0) == 1) {
            int n2 = Serializer.getInt((Object)serializer.getProperty((Object)"MediaChest", (Object)TB_ORIENT), (int)0);
            string = "North";
            if (n2 == 1) {
                string = "West";
            }
            this.getContentPane().add((Component)this.createToolBar(n2), string);
        }
        if (Serializer.getInt((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"StatusBar"), (int)1) == 1) {
            this.getContentPane().add(this.controller.component(Controller.COMP_STATUSBAR), "South");
        }
        FileNameFormat.datemask = Serializer.arrayToString((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"DateFormat"));
        FileNameFormat.timemask = Serializer.arrayToString((Object)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"TimeFormat"));
        FileNameFormat.counter = Serializer.getInt((Object)serializer.getProperty((Object)"RenameOptions", (Object)"Counter"), (int)0);
        FileNameFormat.transformCodes = new Object[Resources.ROTATIONS.length];
        System.arraycopy(Resources.ROTATIONS, 0, FileNameFormat.transformCodes, 0, Resources.ROTATIONS.length);
        try {
            objectArray = (Object[])serializer.getProperty((Object)"TransformOptions", (Object)"TransformCode");
            if (objectArray == null) {
                throw new Exception("A transform option's missed in configuration file");
            }
        }
        catch (Exception exception) {
            objectArray = Resources.ROTATIONS;
        }
        System.arraycopy(objectArray, 0, FileNameFormat.transformCodes, 0, objectArray.length);
        string = (String)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"Language");
        String string2 = (String)serializer.getProperty((Object)"MiscellaneousOptions", (Object)"Country");
        if (string != null && string2 != null) {
            Locale.setDefault(new Locale(string, string2));
        }
        BasicJpeg.setEncoding(MiscellaneousOptionsTab.getEncoding(this.controller));
    }

    public Iterator getKeyMnemonics() {
        return this.irdKeyMap.keySet().iterator();
    }

    public boolean doAction(String string) {
        try {
            System.err.println("Doing action " + string);
            IrdControllable irdControllable = (IrdControllable)((Object)this.controller.component(this.irdKeyMap.get(string)));
            irdControllable.bringOnTop();
            if (irdControllable.getKeyMnemonics() != null) {
                ((IrdReceiver)this.controller.component(Controller.COMP_REMOTERECEIVER)).setOnTop(irdControllable);
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public void bringOnTop() {
        this.controller.getMainFrame().requestFocus();
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        jMenu.setActionCommand("File");
        JMenuItem jMenuItem = new JMenuItem("Change drive");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        jMenuItem = new JMenuItem("To selection");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 3);
        jMenuItem = new JMenuItem("Make disk");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((RipperPanel)this.controller.component(Controller.COMP_RIPPERPANEL));
        jMenuItem = new JMenuItem("Get CF");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Properties...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 1);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Export");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("To CSV...");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener((ActionListener)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
        jMenuItem = new JMenuItem("To Disk...");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener((ActionListener)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
        jMenu2 = new JMenu("Import");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("From CSV...");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener((ActionListener)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
        jMenuItem = new JMenuItem("From Disk...");
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener((ActionListener)((Object)this.controller.component(Controller.COMP_ALBUMPANEL)));
        jMenu.addSeparator();
        this.addPluginMenus(jMenu);
        jMenuItem = new JMenuItem("Exit");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("alt F4"));
        jMenuItem.addActionListener(this.controller);
        jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        jMenu.setActionCommand("Tools");
        jMenu2 = Controller.createTransformMenu((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jMenu.add(jMenu2);
        this.controller.getUiUpdater().addForNotification(jMenu2, 2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Extract markers");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 2);
        jMenuItem = new JMenuItem("Extract thumbs");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 2);
        jMenuItem = new JMenuItem("Web publishing");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 2);
        jMenuItem = new JMenuItem("Upload to print shop");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 2);
        jMenuItem = new JMenuItem("Send by e-mail");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        this.controller.getUiUpdater().addForNotification(jMenuItem, 2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("View HTML");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenuItem = new JMenuItem("Show/play list");
        jMenu.add(jMenuItem);
        this.controller.getUiUpdater().addForNotification(jMenuItem, 6);
        jMenuItem.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jMenu.addSeparator();
        this.addPluginMenus(jMenu);
        jMenuItem = new JMenuItem("Options...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Contents...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        jMenuItem = new JMenuItem("About...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this.controller);
        try {
            jMenuBar.setHelpMenu(jMenu);
        }
        catch (Error error) {
            // empty catch block
        }
        return jMenuBar;
    }

    void addPluginMenus(JMenu jMenu) {
        Enumeration enumeration = this.controller.components();
        while (enumeration.hasMoreElements()) {
            try {
                if (!((PhotoPlugin)enumeration.nextElement()).addMenuElements(jMenu)) continue;
                jMenu.addSeparator();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    JToolBar createToolBar(int n) {
        JToolBar jToolBar = new JToolBar(n);
        JButton jButton = new JButton(Controller.getResourceIcon((String)"readcf.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("Get CF");
        jButton.addActionListener((PhotoCollectionPanel)this.controller.component(Controller.COMP_COLLECTION));
        jButton = new JButton(Controller.getResourceIcon((String)"photoorganizer.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("To selection");
        jButton.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        this.controller.getUiUpdater().addForNotification(jButton, 3);
        jButton = new JButton(Controller.getResourceIcon((String)"changedrive.jpg"));
        jToolBar.add(jButton);
        jButton.setToolTipText("Change drive");
        jButton.addActionListener((JTreeTable)this.controller.component(Controller.COMP_DIRTREE));
        return jToolBar;
    }

    class ROptionsMenu
    extends JPopupMenu {
        public ROptionsMenu() {
            JMenuItem jMenuItem = new JMenuItem("Extract thumbs");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("Web publishing");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("Send by e-mail");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            jMenuItem.setEnabled(PhotoOrganizer.this.controller.getUiUpdater().isEnabled(2));
            jMenuItem = new JMenuItem("View HTML");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoOrganizer.this.controller);
            this.addSeparator();
            jMenuItem = new JMenuItem("Get CF");
            this.add(jMenuItem);
            jMenuItem.addActionListener((PhotoCollectionPanel)PhotoOrganizer.this.controller.component(Controller.COMP_COLLECTION));
            this.addSeparator();
            jMenuItem = new JMenuItem("Options...");
            this.add(jMenuItem);
            jMenuItem.addActionListener(PhotoOrganizer.this.controller);
        }
    }

    class FlashWindow
    extends JWindow {
        public FlashWindow() {
            this.getContentPane().add(new JLabel(Controller.getResourceIcon((String)"logo.jpg")));
            this.pack();
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getPreferredSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.setVisible(true);
        }
    }
}

