// View.h : interface of the CIPsinkView class
//
/////////////////////////////////////////////////////////////////////////////
#include "winsock.h"

#define SOCKERR "Windows Socket Error"

enum eProtocolMode
{
	eUDP,
	eTCP
};

enum eServerFail
{
	eServerOK,
	eServerFail1,
	eServerFail2,
	eServerFail3,
	eServerFail4,
	eServerFail5,
	eServerFail6,
};

class CIPsinkView : public CEditView
{
protected: // create from serialization only
	CIPsinkView();
	DECLARE_DYNCREATE(CIPsinkView)
	SOCKET m_hSocket;
	eServerFail BecomeListeningServer(const char *name, const char *port);
	CString GetLocalDotName(void);
	void NeatTest(void);
	eProtocolMode m_eProtocolMode;

// Attributes
public:
	CIPsinkDoc* GetDocument();
	SOCKET m_hListenSocket;
	SOCKET m_hListenAcceptSocket;

// Operations
public:
	void Log (const char * szBuffer);  // was LPSTR

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIPsinkView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL
	afx_msg LONG OnWinsockListenEvent(WPARAM wParam, LPARAM lParam);

// Implementation
public:
	virtual ~CIPsinkView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void CIPsinkView::KillSocket(void);
// Generated message map functions
protected:
	//{{AFX_MSG(CIPsinkView)
	afx_msg void OnConnect();
	afx_msg void OnCloseconn();
	afx_msg void OnClearview();
	afx_msg void OnUpdateCloseconn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnMyfileOpen();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in View.cpp
inline CIPsinkDoc* CIPsinkView::GetDocument()
   { return (CIPsinkDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
