/*
 * Decompiled with CFR 0.152.
 */
package jfr.util;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import jfr.util.Alphabet;
import jfr.util.AlphabetIncompatible;
import jfr.util.AlphabetOutOfRange;

public class StringUtils {
    protected static Alphabet alphabet_forbidden_url_characters;
    protected static Alphabet alphabet_whitespace;

    public static int countOccurrences(String s, char c) {
        if (s.length() == 0) {
            return 0;
        }
        int result = 0;
        int index = s.indexOf(c);
        while (index >= 0) {
            ++result;
            index = s.indexOf(c, index + 1);
        }
        return result;
    }

    public static String[] tokenizeString(String s, char token, boolean decode_encoded_chars, Alphabet characters_to_trim, boolean ignore_token_at_end) {
        int i;
        if (ignore_token_at_end && s.charAt(s.length() - 1) == token) {
            s = s.substring(0, s.length() - 1);
        }
        int part_count = StringUtils.countOccurrences(s, token) + 1;
        String[] result = new String[part_count];
        if (part_count == 1) {
            result[0] = s;
        } else {
            i = 0;
            int last_index = 0;
            while (i < part_count - 1) {
                int token_index = s.indexOf(token, last_index);
                result[i] = s.substring(last_index, token_index);
                last_index = token_index + 1;
                ++i;
            }
            result[part_count - 1] = s.substring(last_index);
        }
        if (decode_encoded_chars || characters_to_trim != null) {
            i = 0;
            while (i < part_count) {
                String str = result[i];
                if (decode_encoded_chars) {
                    str = StringUtils.decodeEncodedCharacters(str, true);
                }
                if (characters_to_trim != null) {
                    str = characters_to_trim.trim(str);
                }
                result[i] = str;
                ++i;
            }
        }
        return result;
    }

    public static String[] tokenizeString(String s, char token) {
        return StringUtils.tokenizeString(s, token, false, null, false);
    }

    public static int countLines(String s, int max_line_length) {
        if (s == null) {
            return 0;
        }
        int line_count = 0;
        int s_length = s.length();
        int last_index = 0;
        while (last_index < s_length) {
            int token_index;
            int n = token_index = max_line_length < 1 ? s_length + 1 : last_index + max_line_length;
            if (token_index > s_length) {
                token_index = s_length;
            } else {
                int j = token_index - 1;
                while (j > last_index) {
                    if (alphabet_whitespace.contains(s.charAt(j))) {
                        token_index = j + 1;
                        break;
                    }
                    --j;
                }
            }
            int lf_index = s.indexOf(10, last_index);
            if (lf_index != -1 && lf_index < token_index) {
                token_index = lf_index + 1;
            }
            ++line_count;
            last_index = token_index;
        }
        return line_count;
    }

    public static String[] stringToLines(String s, int max_line_length) {
        if (s == null) {
            return null;
        }
        int s_length = s.length();
        int part_count = StringUtils.countLines(s, max_line_length);
        if (part_count == 0) {
            return null;
        }
        String[] result = new String[part_count];
        if (part_count == 1) {
            result[0] = s;
        } else {
            int i = 0;
            int last_index = 0;
            while (i < part_count - 1) {
                int token_index;
                int n = token_index = max_line_length < 1 ? s_length + 1 : last_index + max_line_length;
                if (token_index > s_length) {
                    token_index = s_length;
                } else {
                    int j = token_index - 1;
                    while (j > last_index) {
                        if (alphabet_whitespace.contains(s.charAt(j))) {
                            token_index = j + 1;
                            break;
                        }
                        --j;
                    }
                }
                int lf_index = s.indexOf(10, last_index);
                if (lf_index != -1 && lf_index < token_index) {
                    token_index = lf_index + 1;
                }
                result[i] = alphabet_whitespace.contains(s.charAt(token_index - 1)) ? s.substring(last_index, token_index - 1) : s.substring(last_index, token_index);
                last_index = token_index;
                ++i;
            }
            result[part_count - 1] = s.substring(last_index);
        }
        return result;
    }

    public static String arrayToString(String[] array, String token, boolean append_token_at_end, Alphabet characters_to_encode) {
        Alphabet local_chars_to_encode;
        if (array == null) {
            return "";
        }
        try {
            if (characters_to_encode == null) {
                local_chars_to_encode = new Alphabet(token);
            } else {
                local_chars_to_encode = new Alphabet(characters_to_encode);
                local_chars_to_encode.add(token);
            }
        }
        catch (AlphabetOutOfRange alphabetOutOfRange) {
            local_chars_to_encode = characters_to_encode;
        }
        catch (AlphabetIncompatible alphabetIncompatible) {
            local_chars_to_encode = characters_to_encode;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            String encoded_element = array[i];
            encoded_element = StringUtils.encodeString(encoded_element, local_chars_to_encode, false);
            result.append(encoded_element);
            if (token != null && (append_token_at_end || i < array.length - 1)) {
                result.append(token);
            }
            ++i;
        }
        return result.toString();
    }

    public static String arrayToString(String[] array, String token) {
        return StringUtils.arrayToString(array, token, false, null);
    }

    public static String compressString(String str, int max_length) {
        if (str.length() <= max_length) {
            return str;
        }
        if (max_length <= 0) {
            return "";
        }
        int half_length = (max_length - 3) / 2;
        if (half_length <= 0) {
            return str.substring(0, max_length);
        }
        return String.valueOf(str.substring(0, half_length)) + "..." + str.substring(str.length() - half_length);
    }

    public static String compressString(String str, Component component, int inset) {
        Graphics graphics = component.getGraphics();
        if (graphics == null) {
            return str;
        }
        FontMetrics fm = graphics.getFontMetrics();
        int full_width = fm.stringWidth(str);
        float compress_ratio = (float)(component.getSize().width - inset) / (float)full_width;
        int max_length = (int)((float)str.length() * compress_ratio);
        return StringUtils.compressString(str, max_length);
    }

    public static String decodeEncodedCharacters(String str, boolean decode_control_chars) {
        int length = str.length();
        if (length < 3) {
            return str;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < length) {
            char character = str.charAt(i);
            if (character == '%' && i + 2 < length) {
                String code_string = str.substring(i + 1, i + 3);
                try {
                    int value = Integer.parseInt(code_string, 16);
                    if (value > 31 && value != 127 || decode_control_chars) {
                        character = (char)value;
                    }
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            result.append(character);
            ++i;
        }
        return result.toString();
    }

    public static String encodeString(String str, Alphabet undesired_characters, boolean replace_encoded_chars) {
        StringBuffer result = new StringBuffer();
        if (replace_encoded_chars) {
            str = StringUtils.decodeEncodedCharacters(str, true);
        }
        int length = str.length();
        int i = 0;
        while (i < length) {
            char character = str.charAt(i);
            if (undesired_characters.contains(character) || character == '%') {
                result.append(String.valueOf('%') + Integer.toHexString(character).toUpperCase());
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    public static String encodeString(String str, Alphabet undesired_characters) {
        return StringUtils.encodeString(str, undesired_characters, true);
    }

    public static String encodeURLCharacters(String str) {
        return StringUtils.encodeString(str, alphabet_forbidden_url_characters, true);
    }

    public static String cryptString(String str, int key) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int x = str.charAt(i) ^ key;
            result.append((char)x);
            ++i;
        }
        return result.toString();
    }

    static {
        try {
            alphabet_forbidden_url_characters = new Alphabet("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789$-_.+!*'(),/");
            alphabet_forbidden_url_characters.invert();
            alphabet_whitespace = new Alphabet(" \t\r\n");
        }
        catch (AlphabetOutOfRange e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

