/*
 * Decompiled with CFR 0.152.
 */
package jfr.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import jfr.pagesucker.Constants;
import jfr.pagesucker.PageSucker;
import jfr.util.Alphabet;
import jfr.util.AlphabetException;
import jfr.util.FileSet;
import jfr.util.ModifiableInteger;
import jfr.util.StringUtils;

public class FileAccessor {
    public static int max_filename_length;
    public static Alphabet alphabet_invisible_characters;
    public static Alphabet alphabet_platform_illegal_characters;
    public static Alphabet alphabet_platform_illegal_filename_characters;
    public static Alphabet alphabet_non_alphanumeric;
    public static Alphabet alphabet_dot;

    public synchronized File createFile(File file, ModifiableInteger existing_file_strategy, FileSet files_in_use) throws IOException {
        if ((file = this.createParentDirs(file, existing_file_strategy.value == 4)).exists()) {
            if (existing_file_strategy.value == 1) {
                existing_file_strategy.value = files_in_use.contains(file) ? 2 : 1;
            } else if (existing_file_strategy.value == 2) {
                if (file.length() == 0L) {
                    existing_file_strategy.value = files_in_use.contains(file) ? 2 : 1;
                }
            } else if (existing_file_strategy.value == 3) {
                file = null;
            } else if (existing_file_strategy.value == 4) {
                file = this.bumpRevise(file, true, false);
                existing_file_strategy.value = 1;
            } else if (existing_file_strategy.value == 5) {
                file = this.bumpRevise(file, false, false);
                existing_file_strategy.value = 1;
            }
        } else {
            existing_file_strategy.value = 1;
        }
        if (existing_file_strategy.value == 1) {
            files_in_use.add(file);
            FileOutputStream fos = new FileOutputStream(file);
            fos.close();
        }
        return file;
    }

    private synchronized File createParentDirs(File in_file, boolean prefix) {
        String parent_string;
        File dir = in_file;
        int path_depth = 0;
        while ((parent_string = dir.getParent()) != null) {
            dir = new File(parent_string);
            ++path_depth;
        }
        if (path_depth == 0) {
            return in_file;
        }
        String[] dir_names = new String[path_depth];
        dir = in_file;
        int i = path_depth - 1;
        while ((parent_string = dir.getParent()) != null) {
            dir = new File(parent_string);
            dir_names[i--] = dir.getName();
        }
        i = 0;
        while (i < path_depth) {
            dir = new File(dir, dir_names[i]);
            ++i;
        }
        dir.mkdirs();
        return new File(dir, in_file.getName());
    }

    private synchronized File bumpRevise(File original_file, boolean prefix, boolean accept_directories) {
        if (!original_file.exists() || accept_directories && original_file.isDirectory()) {
            return original_file;
        }
        int index = 0;
        String name = original_file.getName();
        String parent = original_file.getParent();
        int dot_index = (name = StringUtils.decodeEncodedCharacters(name, true)).lastIndexOf(46);
        String extension = dot_index == -1 ? "" : name.substring(dot_index);
        String root = dot_index == -1 ? name : name.substring(0, dot_index);
        File f = original_file;
        String[] name_parts = new String[2];
        while (!(!f.exists() || accept_directories && f.isDirectory())) {
            String new_name;
            String number;
            if (prefix) {
                number = String.valueOf(String.valueOf(index)) + '~';
                new_name = String.valueOf(number) + name;
                if (new_name.length() > max_filename_length) {
                    name_parts[0] = root;
                    name_parts[1] = extension;
                    this.shortenFileName(new_name.length(), name_parts);
                    new_name = String.valueOf(number) + name_parts[0] + name_parts[1];
                }
            } else {
                number = String.valueOf('~') + String.valueOf(index);
                new_name = String.valueOf(root) + number + extension;
                if (new_name.length() > max_filename_length) {
                    name_parts[0] = root;
                    name_parts[1] = extension;
                    this.shortenFileName(new_name.length(), name_parts);
                    new_name = String.valueOf(name_parts[0]) + number + name_parts[1];
                }
            }
            new_name = StringUtils.encodeString(new_name, Constants.alphabet_non_ASCII_or_control_characters);
            f = new File(parent, new_name);
            ++index;
        }
        return f;
    }

    public File adaptFileSpecToLocalSystem(File file) {
        StringBuffer path_buffer = new StringBuffer();
        String filename = file.getName();
        String path = file.getParent();
        path = StringUtils.decodeEncodedCharacters(path, true);
        String[] path_elements = StringUtils.tokenizeString(path, File.separatorChar);
        Alphabet alphabet_illegal_characters = Main.sucker.working_settings.alphanumeric_filenames ? alphabet_non_alphanumeric : alphabet_platform_illegal_characters;
        int i = 0;
        while (i < path_elements.length) {
            String path_element = path_elements[i];
            if (path_element.length() > 0 && ((path_element = alphabet_illegal_characters.clean(path_element)).length() == 0 || path_element.equals("."))) {
                path_element = "untitled";
            }
            if (path_element.length() > max_filename_length) {
                path_element = path_element.substring(0, max_filename_length);
            }
            path_buffer.append(path_element);
            if (i < path_elements.length - 1) {
                path_buffer.append(File.separatorChar);
            }
            ++i;
        }
        path = StringUtils.encodeString(path_buffer.toString(), Constants.alphabet_non_ASCII_or_control_characters);
        filename = StringUtils.decodeEncodedCharacters(filename, true);
        if ((filename = alphabet_illegal_characters.clean(filename, 'x')).length() > max_filename_length) {
            String[] name_parts = new String[2];
            int dot_index = filename.lastIndexOf(46);
            name_parts[1] = dot_index == -1 ? "" : filename.substring(dot_index);
            name_parts[0] = dot_index == -1 ? filename : filename.substring(0, dot_index);
            this.shortenFileName(filename.length(), name_parts);
            filename = String.valueOf(name_parts[0]) + name_parts[1];
        }
        filename = StringUtils.encodeString(filename, Constants.alphabet_non_ASCII_or_control_characters);
        return new File(path, filename);
    }

    private void shortenFileName(int original_length, String[] name_parts) {
        if (original_length <= max_filename_length) {
            return;
        }
        int subtract_length = original_length - max_filename_length;
        if (name_parts[0].length() > subtract_length) {
            name_parts[0] = name_parts[0].substring(0, name_parts[0].length() - subtract_length);
        } else {
            name_parts[0] = "";
            name_parts[1] = name_parts[1].length() > subtract_length ? name_parts[1].substring(0, name_parts[1].length() - subtract_length) : "";
        }
    }

    static {
        try {
            alphabet_invisible_characters = new Alphabet('\u0000', '\u001f');
            alphabet_invisible_characters.add('\u007f');
            switch (PageSucker.os_type) {
                case 1: {
                    max_filename_length = 31;
                    alphabet_platform_illegal_characters = new Alphabet(':');
                    break;
                }
                case 2: {
                    max_filename_length = 127;
                    alphabet_platform_illegal_characters = new Alphabet("\\/:*?\"<>|");
                    break;
                }
                case 3: {
                    max_filename_length = 127;
                    alphabet_platform_illegal_characters = new Alphabet("\\/:*?\"<>|");
                    break;
                }
                default: {
                    max_filename_length = 12;
                    alphabet_platform_illegal_characters = new Alphabet("\\/:*?\"<>|");
                }
            }
            alphabet_platform_illegal_characters.add(alphabet_invisible_characters);
            alphabet_platform_illegal_filename_characters = new Alphabet(alphabet_platform_illegal_characters);
            alphabet_platform_illegal_filename_characters.sub(File.separatorChar);
            alphabet_non_alphanumeric = new Alphabet("_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789.");
            alphabet_non_alphanumeric.invert();
            alphabet_dot = new Alphabet('.');
        }
        catch (AlphabetException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

