/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import jfr.awt.MessageDialog;
import jfr.pagesucker.Constants;
import jfr.pagesucker.InvalidSettingsFileError;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.Settings;

public class ReleaseCheckerThread
extends Thread {
    private static final int DOWNLOAD_BUFFER_SIZE = 100000;
    private boolean m_quiet;
    private static Thread thread_instance = null;
    private FileDialog filedialog_save_new_release;

    ReleaseCheckerThread(boolean quiet) {
        this.filedialog_save_new_release = new FileDialog((Frame)Main.sucker.frame_control, "Save new release as:", 1);
        this.m_quiet = quiet;
        thread_instance = this;
    }

    public static Thread getThreadInstance() {
        return thread_instance;
    }

    public void run() {
        this.checkForNewestRelease(this.m_quiet);
        thread_instance = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkForNewestRelease(boolean quiet) {
        boolean newer_java_needed;
        boolean bl;
        URL info_url;
        String platform_name;
        String engine_description;
        BufferedReader buffered_reader = null;
        int new_pagesucker_version = 0;
        int new_pagesucker_sub_version = 0;
        int new_pagesucker_sub_sub_version = 0;
        int needed_java_version = 0;
        int needed_java_sub_version = 0;
        int needed_java_sub_sub_version = 0;
        String download_url = null;
        String info_url_string = "http://www.pagesucker.com/ReleaseInfo/";
        switch (PageSucker.os_type) {
            case 1: {
                info_url_string = String.valueOf(info_url_string) + "Macintosh.dat";
                engine_description = "a newer version of MRJ";
                platform_name = "Macintosh";
                break;
            }
            case 2: {
                info_url_string = String.valueOf(info_url_string) + "Windows.dat";
                engine_description = "a newer version of JRE";
                platform_name = "Windows";
                break;
            }
            default: {
                if (quiet) return;
                new MessageDialog((Frame)Main.sucker.frame_control, "Sorry, the release check function is not supported for your platform. Please check out the PageSucker homepage manually; it is located at \"http://www.pagesucker.com\".", 3).handle();
                return;
            }
        }
        try {
            info_url = new URL(info_url_string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("*** Internal Error - invalid release info URL.");
            return;
        }
        Window status_dialog = null;
        if (!quiet) {
            String[] buttons = new String[]{"Cancel"};
            status_dialog = new MessageDialog(Main.sucker.frame_control, "Checking for a new release of PageSucker:\nConnecting to the home server ...", 4, buttons, true);
            ((MessageDialog)status_dialog).handle();
        }
        try {
            try {
                InputStream stream = info_url.openStream();
                buffered_reader = new BufferedReader(new InputStreamReader(stream));
                String line = buffered_reader.readLine();
                while (line != null) {
                    Thread.currentThread();
                    Thread.yield();
                    String name = Constants.alphabet_not_control_or_equals.span(line);
                    line = Constants.alphabet_not_control_or_equals.trimLeft(line);
                    if (name.length() == 0) throw new InvalidSettingsFileError();
                    if (!line.startsWith("=")) {
                        throw new InvalidSettingsFileError();
                    }
                    String value = line.substring(1);
                    if (name.equals("Version")) {
                        new_pagesucker_version = Settings.loadIntValue(value);
                    } else if (name.equals("SubVersion")) {
                        new_pagesucker_sub_version = Settings.loadIntValue(value);
                    } else if (name.equals("SubSubVersion")) {
                        new_pagesucker_sub_sub_version = Settings.loadIntValue(value);
                    } else if (name.equals("NeededJavaVersion")) {
                        needed_java_version = Settings.loadIntValue(value);
                    } else if (name.equals("NeededJavaSubVersion")) {
                        needed_java_sub_version = Settings.loadIntValue(value);
                    } else if (name.equals("NeededJavaSubSubVersion")) {
                        needed_java_sub_sub_version = Settings.loadIntValue(value);
                    } else if (name.equals("NeededEngineDescription")) {
                        engine_description = Settings.loadStringValue(value);
                    } else if (name.equals("URL")) {
                        download_url = Settings.loadStringValue(value);
                    }
                    line = buffered_reader.readLine();
                }
            }
            catch (Exception exception) {
                if (!quiet) {
                    new MessageDialog((Frame)Main.sucker.frame_control, "New release check:\nCouldn't access the release information on the home server. You may want to check out the homepage using your favorite browser. The URL is \"http://www.pagesucker.com\".", 3).handle();
                }
                Object var19_22 = null;
                try {
                    if (buffered_reader != null) {
                        buffered_reader.close();
                    }
                }
                catch (IOException iOException) {}
                if (status_dialog == null) return;
                status_dialog.dispose();
                return;
            }
            Object var19_23 = null;
        }
        catch (Throwable buttons) {
            Object var19_24 = null;
            try {}
            catch (IOException iOException) {}
            if (buffered_reader != null) {
                buffered_reader.close();
            }
            if (status_dialog == null) throw buttons;
            status_dialog.dispose();
            throw buttons;
        }
        try {}
        catch (IOException iOException) {}
        if (buffered_reader != null) {
            buffered_reader.close();
        }
        if (status_dialog != null) {
            status_dialog.dispose();
        }
        if (!(new_pagesucker_version > 2 || new_pagesucker_version == 2 && new_pagesucker_sub_version > 1 || new_pagesucker_version == 2 && new_pagesucker_sub_version == 1 && new_pagesucker_sub_sub_version > 0)) {
            boolean bl2 = new_pagesucker_version == 2 && new_pagesucker_sub_version == 1 && new_pagesucker_sub_sub_version == 0;
            bl = false;
        } else {
            bl = true;
        }
        boolean newer_pagesucker_released = bl;
        boolean bl3 = newer_java_needed = needed_java_version > PageSucker.java_version || needed_java_version == PageSucker.java_version && needed_java_sub_version > PageSucker.java_sub_version || needed_java_version == PageSucker.java_version && needed_java_sub_version == PageSucker.java_sub_version && needed_java_sub_sub_version > PageSucker.java_sub_sub_version;
        if (!newer_pagesucker_released) {
            if (quiet) return;
            new MessageDialog((Frame)Main.sucker.frame_control, "New release check:\nThere is currently no newer version of PageSucker for " + platform_name + " available than the one which you are using right now.", 1).handle();
            return;
        }
        if (quiet) return;
        String new_pagesucker_release = String.valueOf(String.valueOf(new_pagesucker_version)) + '.' + String.valueOf(new_pagesucker_sub_version) + '.' + String.valueOf(new_pagesucker_sub_sub_version);
        StringBuffer message = new StringBuffer("A new version of PageSucker for ");
        message.append(platform_name);
        message.append(" has been released (");
        message.append(new_pagesucker_release);
        message.append(").");
        if (download_url != null) {
            message.append(" Click the download button below to download it now from the homepage. You can of course also use a Web browser to download it manually from your preferred download site.");
        }
        if (newer_java_needed) {
            message.append("\n\nYou'll need to upgrade your Java engine to use the new version of PageSucker: ");
            message.append(engine_description);
            message.append(" is needed. You can get it directly from the Java engine vendor; see the Read Me file for details.");
        } else {
            message.append("\n\nThe Java engine you have installed should work fine with the new PageSucker release.");
        }
        String[] buttons = new String[]{"Download PageSucker", "Thanks For The Info"};
        String button_pressed = new MessageDialog((Frame)Main.sucker.frame_control, message.toString(), 1, buttons).handle();
        if (button_pressed == null) return;
        if (!button_pressed.equals("Download PageSucker")) return;
        try {
            URL url = new URL(download_url);
            this.downloadNewRelease(url);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            new MessageDialog((Frame)Main.sucker.frame_control, "Oops, an error occurred while trying to access the remote file. You might want to use your favorite Web browser to get the new release. The homepage is located at \"http://www.mediatel.lu/pagesucker/\"", 3).handle();
            return;
        }
    }

    void downloadNewRelease(URL url) {
        File save_file;
        boolean download_interrupted;
        InputStream input_stream;
        block32: {
            input_stream = null;
            URLConnection connection = null;
            FileOutputStream fos = null;
            BufferedOutputStream output_stream = null;
            int content_length = -1;
            download_interrupted = false;
            String url_path = url.getFile();
            int slash_index = url_path.lastIndexOf(47);
            String url_file = slash_index >= 0 && slash_index < url_path.length() - 1 ? url_path.substring(slash_index + 1) : "";
            this.filedialog_save_new_release.setFile(url_file);
            ((Component)this.filedialog_save_new_release).setVisible(true);
            String save_dir = this.filedialog_save_new_release.getDirectory();
            String save_filename = this.filedialog_save_new_release.getFile();
            if (save_dir == null || save_filename == null) {
                return;
            }
            save_file = new File(String.valueOf(save_dir) + save_filename);
            String[] dialog_buttons = new String[]{"Cancel"};
            MessageDialog status_dialog = new MessageDialog(Main.sucker.frame_control, "Downloading the newest release of PageSucker:\nConnecting to the home server ...", 4, dialog_buttons, true, -1);
            status_dialog.handle();
            try {
                try {
                    int size;
                    connection = url.openConnection();
                    input_stream = connection.getInputStream();
                    content_length = connection.getContentLength();
                    fos = new FileOutputStream(save_file);
                    output_stream = new BufferedOutputStream(fos, 100000);
                    byte[] buffer = new byte[100000];
                    int bytes_read = 0;
                    Label status_label = status_dialog.getLabels()[1];
                    while ((size = input_stream.read(buffer)) != -1) {
                        output_stream.write(buffer, 0, size);
                        if (bytes_read < content_length) {
                            int percentage = (bytes_read += size) * 100 / content_length;
                            status_label.setText("Progress: " + String.valueOf(percentage) + "% complete.");
                            status_label.invalidate();
                            status_label.getParent().validate();
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                    new MessageDialog((Frame)Main.sucker.frame_control, "The newest release of PageSucker has been downloaded successfully. You'll need to use a decompressor tool (e.g. \"Stuffit Expander\" on Macintosh, or \"WinZIP\" under Windows) to get it operational.", 1).handle();
                }
                catch (InterruptedException interruptedException) {
                    download_interrupted = true;
                    Object var18_23 = null;
                    status_dialog.dispose();
                    if (output_stream != null) {
                        try {
                            output_stream.flush();
                            output_stream.close();
                        }
                        catch (IOException iOException) {}
                        output_stream = null;
                    }
                    if (download_interrupted) {
                        try {
                            save_file.delete();
                        }
                        catch (SecurityException securityException) {}
                    }
                    if (input_stream != null) {
                        try {
                            input_stream.close();
                        }
                        catch (IOException iOException) {}
                        input_stream = null;
                    }
                    return;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    new MessageDialog((Frame)Main.sucker.frame_control, "There was a problem while trying to access the remote file (" + e.toString() + "). You might want to use your favorite Web browser to get the new release. The homepage is located at \"http://www.mediatel.lu/pagesucker/\"", 3).handle();
                }
                Object var18_24 = null;
                status_dialog.dispose();
                if (output_stream == null) break block32;
            }
            catch (Throwable throwable) {
                Object var18_25 = null;
                status_dialog.dispose();
                if (output_stream != null) {
                    try {
                        output_stream.flush();
                        output_stream.close();
                    }
                    catch (IOException iOException) {}
                    output_stream = null;
                }
                if (download_interrupted) {
                    try {
                        save_file.delete();
                    }
                    catch (SecurityException securityException) {}
                }
                if (input_stream != null) {
                    try {
                        input_stream.close();
                    }
                    catch (IOException iOException) {}
                    input_stream = null;
                }
                throw throwable;
            }
            try {
                output_stream.flush();
                output_stream.close();
            }
            catch (IOException iOException) {}
            output_stream = null;
        }
        if (download_interrupted) {
            try {
                save_file.delete();
            }
            catch (SecurityException securityException) {}
        }
        if (input_stream != null) {
            try {
                input_stream.close();
            }
            catch (IOException iOException) {}
            input_stream = null;
        }
    }
}

