/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import jfr.awt.MessageDialog;
import jfr.pagesucker.Constants;
import jfr.pagesucker.InvalidPrefsFileError;
import jfr.pagesucker.PrefsFileVersionError;
import jfr.pagesucker.Settings;

public class Preferences {
    private static final int PREFS_FILE_VERSION = 1;
    private static final int RECOGNIZED_PREFS_FILE_VERSION = 1;
    private static Preferences instance = new Preferences();
    public Point control_frame_location = null;
    public Dimension control_frame_size = null;
    public boolean html_files_frame_open = false;
    public boolean data_files_frame_open = false;
    public boolean ram_files_frame_open = false;
    public boolean m3u_files_frame_open = false;
    public boolean script_frame_open = false;
    public boolean options_frame_open = false;
    public boolean expert_frame_open = false;
    public boolean proxy_frame_open = false;
    public boolean authentication_frame_open = false;

    public static Preferences getInstance() {
        return instance;
    }

    private Preferences() {
    }

    void saveToDisk() {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        FilterOutputStream out_stream = null;
        String fspec = System.getProperty("user.home", "");
        if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
            fspec = String.valueOf(fspec) + File.separator;
        }
        fspec = String.valueOf(fspec) + "PageSuckerPrefs.prf";
        try {
            try {
                File file = new File(fspec);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                out_stream = new DataOutputStream(bos);
                ((DataOutputStream)out_stream).writeBytes("PageSucker Preferences File Version " + String.valueOf(1) + '\n');
                Settings.saveValue((DataOutputStream)out_stream, "ControlFrameLocation", Main.sucker.frame_control.getLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "ControlFrameSize", Main.sucker.frame_control.getSize());
                Settings.saveValue((DataOutputStream)out_stream, "HTMLFilesFrameLocation", Main.sucker.settings_html.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "HTMLFilesFrameSize", Main.sucker.settings_html.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "HTMLFilesFrameOpen", Main.sucker.settings_html.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "DataFilesFrameLocation", Main.sucker.settings_data.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "DataFilesFrameSize", Main.sucker.settings_data.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "DataFilesFrameOpen", Main.sucker.settings_data.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "RAMFilesFrameLocation", Main.sucker.settings_ram_files.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "RAMFilesFrameSize", Main.sucker.settings_ram_files.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "RAMFilesFrameOpen", Main.sucker.settings_ram_files.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "M3UFilesFrameLocation", Main.sucker.settings_m3u_files.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "M3UFilesFrameSize", Main.sucker.settings_m3u_files.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "M3UFilesFrameOpen", Main.sucker.settings_m3u_files.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "ScriptFrameLocation", Main.sucker.settings_script.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "ScriptFrameSize", Main.sucker.settings_script.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "ScriptFrameOpen", Main.sucker.settings_script.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "OptionsFrameLocation", Main.sucker.settings_options.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "OptionsFrameSize", Main.sucker.settings_options.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "OptionsFrameOpen", Main.sucker.settings_options.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "ExpertFrameLocation", Main.sucker.settings_expert.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "ExpertFrameSize", Main.sucker.settings_expert.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "ExpertFrameOpen", Main.sucker.settings_expert.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "ProxyFrameLocation", Main.sucker.settings_proxy.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "ProxyFrameSize", Main.sucker.settings_proxy.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "ProxyFrameOpen", Main.sucker.settings_proxy.isFrameOpen());
                Settings.saveValue((DataOutputStream)out_stream, "AuthenticationFrameLocation", Main.sucker.settings_authentication.getFrameLocationOnScreen());
                Settings.saveValue((DataOutputStream)out_stream, "AuthenticationFrameSize", Main.sucker.settings_authentication.getFrameSize());
                Settings.saveValue((DataOutputStream)out_stream, "AuthenticationFrameOpen", Main.sucker.settings_authentication.isFrameOpen());
                ((DataOutputStream)out_stream).flush();
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't write the preferences file.\n" + e.toString(), 2).handle();
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (out_stream != null) {
                    out_stream.close();
                }
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the preferences file.\n" + e.toString(), 2).handle();
            }
            throw throwable;
        }
        try {
            if (out_stream != null) {
                out_stream.close();
            }
        }
        catch (IOException e) {
            new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the preferences file.\n" + e.toString(), 2).handle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadFromDisk() {
        BufferedReader buffered_reader;
        block81: {
            block80: {
                FileReader reader = null;
                buffered_reader = null;
                int version = 0;
                String header_string = "PageSucker Preferences File Version ";
                String fspec = System.getProperty("user.home", "");
                if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
                    fspec = String.valueOf(fspec) + File.separator;
                }
                fspec = String.valueOf(fspec) + "PageSuckerPrefs.prf";
                File file = new File(fspec);
                try {
                    try {
                        reader = new FileReader(file);
                        buffered_reader = new BufferedReader(reader);
                        String line = buffered_reader.readLine();
                        if (line == null) {
                            Object var11_8 = null;
                            break block80;
                        }
                        if (line.length() <= "PageSucker Preferences File Version ".length()) throw new InvalidPrefsFileError();
                        if (!line.startsWith("PageSucker Preferences File Version ")) {
                            throw new InvalidPrefsFileError();
                        }
                        line = line.substring("PageSucker Preferences File Version ".length());
                        try {
                            version = Integer.parseInt(line);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidPrefsFileError();
                        }
                        if (version > 1) {
                            throw new PrefsFileVersionError();
                        }
                        line = buffered_reader.readLine();
                        while (line != null) {
                            String name = Constants.alphabet_not_control_or_equals.span(line);
                            line = Constants.alphabet_not_control_or_equals.trimLeft(line);
                            if (name.length() == 0) throw new InvalidPrefsFileError();
                            if (!line.startsWith("=")) {
                                throw new InvalidPrefsFileError();
                            }
                            String value = line.substring(1);
                            if (name.equals("ControlFrameLocation")) {
                                this.control_frame_location = Settings.loadPointValue(value);
                            } else if (name.equals("ControlFrameSize")) {
                                this.control_frame_size = Settings.loadDimensionValue(value);
                            } else if (name.equals("HTMLFilesFrameLocation")) {
                                Main.sucker.settings_html.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("HTMLFilesFrameSize")) {
                                Main.sucker.settings_html.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("HTMLFilesFrameOpen")) {
                                this.html_files_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("DataFilesFrameLocation")) {
                                Main.sucker.settings_data.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("DataFilesFrameSize")) {
                                Main.sucker.settings_data.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("DataFilesFrameOpen")) {
                                this.data_files_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("RAMFilesFrameLocation")) {
                                Main.sucker.settings_ram_files.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("RAMFilesFrameSize")) {
                                Main.sucker.settings_ram_files.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("RAMFilesFrameOpen")) {
                                this.ram_files_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("M3UFilesFrameLocation")) {
                                Main.sucker.settings_m3u_files.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("M3UFilesFrameSize")) {
                                Main.sucker.settings_m3u_files.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("M3UFilesFrameOpen")) {
                                this.m3u_files_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("ScriptFrameLocation")) {
                                Main.sucker.settings_script.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("ScriptFrameSize")) {
                                Main.sucker.settings_script.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("ScriptFrameOpen")) {
                                this.script_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("OptionsFrameLocation")) {
                                Main.sucker.settings_options.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("OptionsFrameSize")) {
                                Main.sucker.settings_options.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("OptionsFrameOpen")) {
                                this.options_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("ExpertFrameLocation")) {
                                Main.sucker.settings_expert.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("ExpertFrameSize")) {
                                Main.sucker.settings_expert.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("ExpertFrameOpen")) {
                                this.expert_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("ProxyFrameLocation")) {
                                Main.sucker.settings_proxy.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("ProxyFrameSize")) {
                                Main.sucker.settings_proxy.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("ProxyFrameOpen")) {
                                this.proxy_frame_open = Settings.loadBooleanValue(value);
                            } else if (name.equals("AuthenticationFrameLocation")) {
                                Main.sucker.settings_authentication.setFrameLocation(Settings.loadPointValue(value));
                            } else if (name.equals("AuthenticationFrameSize")) {
                                Main.sucker.settings_authentication.setFrameSize(Settings.loadDimensionValue(value));
                            } else if (name.equals("AuthenticationFrameOpen")) {
                                this.authentication_frame_open = Settings.loadBooleanValue(value);
                            }
                            line = buffered_reader.readLine();
                        }
                        break block81;
                    }
                    catch (InvalidPrefsFileError invalidPrefsFileError) {
                        Object var11_9 = null;
                        try {
                            if (buffered_reader == null) return;
                            buffered_reader.close();
                            return;
                        }
                        catch (IOException iOException) {}
                        return;
                    }
                    catch (PrefsFileVersionError prefsFileVersionError) {
                        Object var11_10 = null;
                        try {}
                        catch (IOException iOException) {}
                        if (buffered_reader == null) return;
                        buffered_reader.close();
                        return;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Object var11_11 = null;
                        try {}
                        catch (IOException iOException) {}
                        if (buffered_reader == null) return;
                        buffered_reader.close();
                        return;
                    }
                    catch (IOException iOException) {
                        Object var11_12 = null;
                        try {}
                        catch (IOException iOException2) {}
                        if (buffered_reader == null) return;
                        buffered_reader.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (buffered_reader == null) throw throwable;
                    buffered_reader.close();
                    throw throwable;
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (buffered_reader == null) return;
            buffered_reader.close();
            return;
        }
        Object var11_13 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        if (buffered_reader == null) return;
        buffered_reader.close();
    }
}

