/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Adjustable;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.BitSet;
import jfr.awt.AWTUtil;
import jfr.awt.FixedSizePanel;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.SuckerFrame;
import jfr.pagesucker.SuckerThread;
import jfr.util.StringUtils;

public class ControlFrame
extends SuckerFrame
implements AdjustmentListener {
    private Label[] labels_thread_status;
    private Scrollbar scrollbar_thread_status;
    private String[] strings_thread_status;
    private int first_visible_thread_status_index = 0;
    private BitSet bitset_thread_status_slots;
    public Button button_start_download;
    public Button button_stop_download;
    public TextField textfield_base_url;
    public TextField textfield_max_recursion_depth;
    public TextField textfield_active_threads;
    public TextField textfield_remaining_documents;
    public TextField textfield_total_saved_files;
    public TextField textfield_total_errors;
    public TextField textfield_status;
    public Label label_reg_name;

    public ControlFrame(Point location, Dimension size) {
        super("Page Sucker " + PageSucker.version_string, location, size);
    }

    protected void setUpFrameContents() {
        int row = 0;
        Label label = new Label("Base URL:");
        this.addToGridBag(label, row, 1, 17);
        this.textfield_base_url = new TextField(Main.sucker.editing_settings.base_url_string, 45);
        this.textfield_base_url.setEditable(true);
        ((Component)this.textfield_base_url).setBackground(Color.white);
        this.addToGridBag(this.textfield_base_url, row, 0, 17, 2);
        label = new Label("Max. Recursion Depth:");
        this.addToGridBag(label, ++row, 1, 17);
        this.textfield_max_recursion_depth = new TextField(Main.sucker.editing_settings.max_recursion_depth == -1 ? "INF" : String.valueOf(Main.sucker.editing_settings.max_recursion_depth), 3);
        this.textfield_max_recursion_depth.setEditable(true);
        ((Component)this.textfield_max_recursion_depth).setBackground(Color.white);
        this.addToGridBag(this.textfield_max_recursion_depth, row, 0, 17);
        ++row;
        row = this.addVerticalSpace(row);
        label = new Label("Active Threads:");
        this.addToGridBag(label, row, 1, 17);
        this.textfield_active_threads = new TextField("0", 6);
        this.textfield_active_threads.setEditable(false);
        this.addToGridBag(this.textfield_active_threads, row, 1, 17);
        label = new Label();
        this.addToGridBag(label, row, 1, 17);
        label = new Label("Total Errors:");
        this.addToGridBag(label, row, 1, 17);
        this.textfield_total_errors = new TextField("0", 6);
        this.textfield_total_errors.setEditable(false);
        this.addToGridBag(this.textfield_total_errors, row, 1, 17);
        this.button_start_download = new Button("Start Download");
        this.button_start_download.setBackground(Color.white);
        this.button_start_download.addActionListener(this);
        this.addToGridBag(this.button_start_download, row, 2, 13);
        this.button_start_download.setEnabled(false);
        label = new Label("Remaining Documents:");
        this.addToGridBag(label, ++row, 1, 17);
        this.textfield_remaining_documents = new TextField("0", 6);
        this.textfield_remaining_documents.setEditable(false);
        this.addToGridBag(this.textfield_remaining_documents, row, 1, 17);
        label = new Label();
        this.addToGridBag(label, row, 1, 17);
        label = new Label("Total Saved Files:");
        this.addToGridBag(label, row, 1, 17);
        this.textfield_total_saved_files = new TextField("0", 6);
        this.textfield_total_saved_files.setEditable(false);
        this.addToGridBag(this.textfield_total_saved_files, row, 1, 17);
        this.button_stop_download = new Button("Stop Download");
        this.button_stop_download.setBackground(Color.white);
        this.button_stop_download.addActionListener(this);
        this.addToGridBag(this.button_stop_download, row, 2, 13);
        this.button_stop_download.setEnabled(false);
        ++row;
        row = this.addVerticalSpace(row);
        this.textfield_status = new TextField("Application Status: Idle", 30);
        this.textfield_status.setEditable(false);
        ((Component)this.textfield_status).setBackground(Color.black);
        this.textfield_status.setForeground(Color.white);
        this.addToGridBag(this.textfield_status, row, 0, 17, 2);
        ++row;
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        this.labels_thread_status = new Label[10];
        FixedSizePanel panel = new FixedSizePanel(500, 150, true, 4, 2, 1);
        panel.setLayout(new GridLayout(10, 1));
        this.strings_thread_status = new String[Main.sucker.editing_settings.max_threads];
        String idle_thread_string = String.valueOf(String.valueOf('I')) + "Thread ";
        int i = 0;
        while (i < Main.sucker.editing_settings.max_threads) {
            this.strings_thread_status[i] = String.valueOf(idle_thread_string) + String.valueOf(i + 1) + ": idle";
            ++i;
        }
        int i2 = 0;
        while (i2 < 10) {
            this.labels_thread_status[i2] = new Label();
            panel.add(this.labels_thread_status[i2]);
            ++i2;
        }
        this.scrollbar_thread_status = new Scrollbar(1, this.first_visible_thread_status_index, 10, 0, Main.sucker.editing_settings.max_threads);
        this.scrollbar_thread_status.addAdjustmentListener(this);
        this.updateThreadStatusList(0);
        this.addToGridBag(panel2, panel, 0, -1, 17, 1);
        this.addToGridBag(panel2, this.scrollbar_thread_status, 0, -1, 13, 3);
        this.addToGridBag((Component)panel2, row, 0, 17, 1);
        ++row;
        row = this.addVerticalSpace(row);
        label = new Label("Copyright \u00a9 1999 Joel Francois");
        this.addToGridBag(label, row, 0, 10);
        label = new Label("New Media Group / Centre de Recherche Public Henri Tudor");
        this.addToGridBag(label, ++row, 0, 10);
        String reg_name = PageSucker.registration_name != null ? PageSucker.registration_name : "< Unregistered Demo Version >";
        this.label_reg_name = new Label("Registered To: " + reg_name);
        this.addToGridBag(this.label_reg_name, ++row, 0, 10);
        ++row;
    }

    public boolean saveContentsValues() {
        block5: {
            Main.sucker.editing_settings.base_url_string = this.textfield_base_url.getText();
            String max_recursion_depth_string = this.textfield_max_recursion_depth.getText().toUpperCase();
            if (max_recursion_depth_string.equals("INF")) {
                Main.sucker.editing_settings.max_recursion_depth = -1;
            } else {
                try {
                    int v = Integer.parseInt(max_recursion_depth_string);
                    if (v < 0) {
                        Main.sucker.editing_settings.max_recursion_depth = -1;
                        ((TextComponent)this.textfield_max_recursion_depth).setText("INF");
                        break block5;
                    }
                    Main.sucker.editing_settings.max_recursion_depth = v;
                }
                catch (NumberFormatException numberFormatException) {
                    Main.sucker.editing_settings.max_recursion_depth = -1;
                    ((TextComponent)this.textfield_max_recursion_depth).setText("INF");
                }
            }
        }
        return true;
    }

    public void updateFromEditingSettings() {
        ((TextComponent)this.textfield_base_url).setText(Main.sucker.editing_settings.base_url_string);
        int v = Main.sucker.editing_settings.max_recursion_depth;
        ((TextComponent)this.textfield_max_recursion_depth).setText(v < 0 ? "INF" : String.valueOf(v));
    }

    public synchronized void prepareThreadStatusList() {
        this.bitset_thread_status_slots = new BitSet(Main.sucker.working_settings.max_threads);
        this.strings_thread_status = new String[Main.sucker.working_settings.max_threads];
        String idle_thread_string = String.valueOf(String.valueOf('I')) + "Thread ";
        int i = 0;
        while (i < Main.sucker.working_settings.max_threads) {
            this.strings_thread_status[i] = String.valueOf(idle_thread_string) + String.valueOf(i + 1) + ": idle";
            ++i;
        }
        this.first_visible_thread_status_index = 0;
        this.scrollbar_thread_status.setValues(0, 10, 0, Main.sucker.working_settings.max_threads);
        this.updateThreadStatusList(0);
    }

    public synchronized void updateThreadStatusList(int first_visible_index) {
        int i = 0;
        int j = first_visible_index;
        while (i < 10) {
            if (j < Main.sucker.working_settings.max_threads) {
                String text = this.strings_thread_status[j];
                Color color = this.getThreadStatusColor(text.charAt(0));
                this.labels_thread_status[i].setForeground(color);
                AWTUtil.updateLabelText(this.labels_thread_status[i], text.substring(1));
            } else {
                AWTUtil.updateLabelText(this.labels_thread_status[i], "");
            }
            ++i;
            ++j;
        }
        this.first_visible_thread_status_index = first_visible_index;
    }

    private synchronized void rememberThreadStatus(String description, int index, char status) {
        String text = "Thread " + String.valueOf(index + 1) + ": " + description;
        text = StringUtils.compressString(text, this.labels_thread_status[0], 0);
        this.strings_thread_status[index] = String.valueOf(String.valueOf(status)) + text;
        if (index >= this.first_visible_thread_status_index && index < this.first_visible_thread_status_index + 10) {
            int label_index = index - this.first_visible_thread_status_index;
            this.labels_thread_status[label_index].setForeground(this.getThreadStatusColor(status));
            AWTUtil.updateLabelText(this.labels_thread_status[label_index], text);
        }
    }

    synchronized int setThreadStatus(String description, char status) {
        int index = 0;
        while (index < Main.sucker.working_settings.max_threads) {
            if (!this.bitset_thread_status_slots.get(index)) break;
            ++index;
        }
        if (index >= Main.sucker.working_settings.max_threads) {
            Main.sucker.logMessage("WARNING - Couldn't update thread status.");
            return -1;
        }
        this.rememberThreadStatus(description, index, status);
        this.bitset_thread_status_slots.set(index);
        return index;
    }

    synchronized void setThreadStatus(String description, int index, char status) {
        if (this.bitset_thread_status_slots.get(index)) {
            this.rememberThreadStatus(description, index, status);
        }
    }

    synchronized int setThreadStatus(String description) {
        return this.setThreadStatus(description, '*');
    }

    synchronized void setThreadStatus(String description, int index) {
        this.setThreadStatus(description, index, '*');
    }

    synchronized void removeThreadStatus(int index) {
        this.rememberThreadStatus("idle", index, 'I');
        this.bitset_thread_status_slots.clear(index);
    }

    private Color getThreadStatusColor(char status) {
        switch (status) {
            case 'A': {
                return Color.blue;
            }
            case 'D': {
                return Color.red;
            }
            case 'I': {
                return Color.black;
            }
        }
        return Color.black;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Adjustable source = evt.getAdjustable();
        if (source == this.scrollbar_thread_status) {
            int value = evt.getValue();
            this.updateThreadStatusList(value);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.button_stop_download) {
            Main.sucker.aborter.requestAbort();
        } else if (source == this.button_start_download) {
            new SuckerThread().start();
        } else {
            super.actionPerformed(evt);
        }
    }
}

