/*
 * Decompiled with CFR 0.152.
 */
package jfr.awt;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jfr.awt.FixedSizePanel;
import jfr.pagesucker.PageSucker;
import jfr.util.StringUtils;

public class MessageDialog
extends Dialog
implements ActionListener {
    public static final int DEFAULT_MAX_TEXT_LENGTH = 64;
    public static final int INFINITE_MAX_TEXT_LENGTH = -1;
    public static final byte GENERIC = 0;
    public static final byte NOTE = 1;
    public static final byte CAUTION = 2;
    public static final byte STOP = 3;
    public static final byte MODELESS = 4;
    protected byte m_dialog_kind;
    protected int m_max_text_length = 64;
    protected String button_pressed = null;
    protected Thread starter_thread = null;
    protected boolean m_interrupt_thread_on_cancel = false;
    protected Label[] labels = null;
    protected Frame m_parent_frame;
    public static final String[] array_ok_button = new String[]{"OK"};
    public static final String[] array_ok_cancel_buttons = new String[]{"Cancel", "OK"};

    public MessageDialog(Frame parent, String message, byte dialog_kind, String[] buttons, boolean interrupt_thread_on_cancel, int max_text_length, Panel custom_panel) {
        super(parent, dialog_kind != 4);
        this.m_dialog_kind = dialog_kind;
        this.m_interrupt_thread_on_cancel = interrupt_thread_on_cancel;
        this.m_max_text_length = max_text_length;
        this.m_parent_frame = parent;
        ((Component)this).setBackground(Color.white);
        this.setResizable(false);
        if (PageSucker.os_type == 1) {
            ((Component)this).setFont(new Font("Geneva", 0, 10));
        }
        this.initializeCustomItems(custom_panel);
        this.initializeText(message);
        this.initializeButtons(buttons);
        this.pack();
        this.addWindowListener(new MessageDialogAdapter());
        if (this.m_interrupt_thread_on_cancel) {
            this.starter_thread = Thread.currentThread();
        }
    }

    public MessageDialog(Frame parent, String message, byte dialog_kind, String[] buttons, boolean interrupt_thread_on_cancel, int max_text_length) {
        this(parent, message, dialog_kind, buttons, interrupt_thread_on_cancel, max_text_length, null);
    }

    public MessageDialog(Frame parent, String message, byte dialog_kind, String[] buttons, boolean interrupt_thread_on_cancel) {
        this(parent, message, dialog_kind, buttons, interrupt_thread_on_cancel, 64, null);
    }

    public MessageDialog(Frame parent, String message, byte dialog_kind, String[] buttons) {
        this(parent, message, dialog_kind, buttons, false, 64, null);
    }

    public MessageDialog(Frame parent, String message, byte dialog_kind) {
        this(parent, message, dialog_kind, array_ok_button, false, 64, null);
    }

    public MessageDialog(Frame parent, byte dialog_kind, String[] buttons, Panel custom_panel) {
        this(parent, null, dialog_kind, buttons, false, 64, custom_panel);
    }

    protected void initializeText(String message) {
        if (message == null) {
            return;
        }
        String[] text_lines = StringUtils.stringToLines(message, this.m_max_text_length);
        FixedSizePanel panel = new FixedSizePanel(-1, (text_lines.length + 1) * 14, true, 0, 0, 0);
        panel.setLayout(new GridLayout(text_lines.length + 1, 0));
        this.labels = new Label[text_lines.length];
        int i = 0;
        while (i < text_lines.length) {
            this.labels[i] = new Label(text_lines[i], 1);
            panel.add(this.labels[i]);
            ++i;
        }
        panel.add(new Label());
        this.add("Center", panel);
    }

    protected void initializeButtons(String[] buttons) {
        if (buttons == null || buttons.length == 0) {
            return;
        }
        Panel panel = new Panel();
        int alignment = buttons.length == 1 ? 1 : 2;
        panel.setLayout(new FlowLayout(alignment));
        int i = 0;
        while (i < buttons.length) {
            Button button = new Button(buttons[i]);
            button.addActionListener(this);
            panel.add(button);
            ++i;
        }
        this.add("South", panel);
    }

    protected void initializeCustomItems(Panel custom_panel) {
        if (custom_panel == null) {
            return;
        }
        this.add("North", custom_panel);
    }

    public String handle() {
        Point location = this.m_parent_frame.getLocation();
        Dimension parent_frame_size = this.m_parent_frame.getSize();
        Dimension dialog_size = this.getSize();
        location.translate((parent_frame_size.width - dialog_size.width) / 2, (parent_frame_size.height - dialog_size.height) / 2);
        ((Component)this).setLocation(location);
        ((Component)this).setVisible(true);
        if (this.m_dialog_kind != 4) {
            this.dispose();
        }
        return this.button_pressed;
    }

    public String getButtonPressed() {
        return this.button_pressed;
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public Insets getInsets() {
        Insets r = (Insets)super.getInsets().clone();
        r.top += 15;
        r.bottom += 15;
        r.left += 15;
        r.right += 15;
        return r;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String command = evt.getActionCommand();
        if (source instanceof Button) {
            this.button_pressed = command;
            if (this.m_dialog_kind != 4) {
                ((Component)this).setVisible(false);
            }
            if (this.m_interrupt_thread_on_cancel && command.toLowerCase().equals("cancel")) {
                this.starter_thread.interrupt();
            }
        }
    }

    class MessageDialogAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            if (MessageDialog.this.m_interrupt_thread_on_cancel) {
                MessageDialog.this.starter_thread.interrupt();
            }
            ((Component)MessageDialog.this).setVisible(false);
        }

        MessageDialogAdapter() {
        }
    }
}

