package com.gotdns.jimula.EatHealthy;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.net.*;
import javax.help.*;

/**
 * <em>MainFrame</em> is a main frame of this program. When program is executed,
 * the MainFrame is loaded first.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 */
public class MainFrame extends JFrame {

  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  JToolBar jToolBar = new JToolBar();
  JButton butt_FEL = new JButton();
  JButton butt_allocate = new JButton();
  JButton butt_help = new JButton();
  JButton butt_personal=new JButton();
  ImageIcon image_FEL;
  ImageIcon image_calc;
  ImageIcon image_help;
  ImageIcon image_serving;
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  NutrientPanel np;
  ServingPanel ap;
  JPanel npp;
  JPanel app;
  JMenu jMenuTools = new JMenu();
  JMenuItem jMenuNutrient = new JMenuItem();
  JMenuItem jMenuServing = new JMenuItem();
  JMenuItem jMenuFEL = new JMenuItem();
  JMenuItem jMenuGuide = new JMenuItem();

  /**
   * Construsts a new MainFrame instance.
   */
  public MainFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

 //Component initialization
  private void jbInit() throws Exception  {
    image_serving=new ImageIcon("images/hamburger.gif");
    image_FEL=new ImageIcon("images/FEL.gif");
    image_calc=new ImageIcon("images/calculator.gif");
    image_help=new ImageIcon("images/help.png");
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(710, 520));
    this.setTitle("EatHealthy V1.01");
    statusBar.setText(" ");
    jMenuFile.setText("File");
    jMenuFileExit.setText("Exit");
    jMenuFileExit.addActionListener(new MainFrame_jMenuFileExit_ActionAdapter(this));
    jMenuHelp.setText("Help");
    jMenuHelpAbout.setText("About");
    jMenuHelpAbout.addActionListener(new MainFrame_jMenuHelpAbout_ActionAdapter(this));
    butt_personal.setIcon(image_calc);
    butt_FEL.setIcon(image_FEL);
    butt_FEL.addActionListener(new MainFrame_butt_FEL_actionAdapter(this));
    butt_FEL.setToolTipText("Food Exchange List");
    butt_allocate.setIcon(image_serving);
    butt_allocate.addActionListener(new MainFrame_butt_allocate_actionAdapter(this));
    butt_allocate.setToolTipText("calculate food serving");
    butt_help.setIcon(image_help);
    butt_help.setToolTipText("Help");
    jMenuTools.setText("Tools");
    jMenuNutrient.setText("nutrient need");
    jMenuNutrient.addActionListener(new MainFrame_jMenuNutrient_actionAdapter(this));
    jMenuServing.setText("food serving");
    jMenuServing.addActionListener(new MainFrame_jMenuServing_actionAdapter(this));
    jMenuFEL.setText("food exchange list");
    jMenuFEL.addActionListener(new MainFrame_jMenuFEL_actionAdapter(this));
    butt_personal.setToolTipText("calculate personal nutrient need");
    butt_personal.setText("");
    butt_personal.addActionListener(new MainFrame_butt_personal_actionAdapter(this));
    jMenuGuide.setActionCommand("guide");
    jMenuGuide.setText("Help");
    jToolBar.add(butt_personal);
    jToolBar.add(butt_allocate);
    jToolBar.add(butt_FEL);
    jToolBar.add(butt_help);
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuGuide);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenuTools);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(jToolBar, BorderLayout.NORTH);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    startJavaHelp(); 

   //add NutrientPanel
    this.np=new NutrientPanel(this);
    this.npp=np.addPanel();
    contentPane.add(npp, BorderLayout.CENTER);
    jMenuTools.add(jMenuNutrient);
    jMenuTools.add(jMenuServing);
    jMenuTools.add(jMenuFEL);

  }//end jbJint()

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    MainFrame_AboutBox dlg = new MainFrame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.show();
  }
  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

  //Help| Help
 
   private void startJavaHelp() {

    try {
      URL url = new URL("file:./docs/help/helpset.hs");
      HelpSet hs = new HelpSet(null, url);
      HelpBroker hb = hs.createHelpBroker();
      butt_help.addActionListener(new CSH.DisplayHelpFromSource(hb));
      jMenuGuide.addActionListener(new CSH.DisplayHelpFromSource(hb));
    }catch(Exception e) {
       e.printStackTrace();
    }

  }

  
  void butt_allocate_actionPerformed(ActionEvent e) {
    calculate_food_serving();

  }

  //show food exchange list
  void butt_FEL_actionPerformed(ActionEvent e) {
    show_food_exchange_list();
  }

 //add NutrientPanel
  void butt_personal_actionPerformed(ActionEvent e) {
    calculate_nutrient_need();

  }


 //remove ServingPanel and add NutrientPanel to MainFrame
  void calculate_nutrient_need(){

    if(this.np!=null){
     contentPane.remove(this.np.addPanel());
   }
    NutrientPanel np=new NutrientPanel(this);
    this.np=np;
    contentPane.add(this.np.addPanel(),BorderLayout.CENTER);
    contentPane.remove(this.ap.addPanel());
    contentPane.updateUI();

  }

 //remove NutrientPanel and add ServingPanel to MainFrame
  void calculate_food_serving(){
    if(this.ap!=null){
    contentPane.remove(this.ap.addPanel());
  }
   ServingPanel ap=new ServingPanel(this);
   this.ap=ap;
   contentPane.add(this.ap.addPanel(),BorderLayout.CENTER);
   contentPane.remove(this.np.addPanel());

   contentPane.updateUI();

  }

  //show food exchange list
  void show_food_exchange_list(){
    FoodExchangeList fl=new FoodExchangeList();
    fl.setVisible(true);
  }

  //add NutrientPanel
  void jMenuNutrient_actionPerformed(ActionEvent e) {
    calculate_nutrient_need();
  }

  //add ServingPanel
  void jMenuServing_actionPerformed(ActionEvent e) {
    calculate_food_serving();
  }

  //show food exchange list
  void jMenuFEL_actionPerformed(ActionEvent e) {
    show_food_exchange_list();
  }

}


class MainFrame_jMenuFileExit_ActionAdapter implements ActionListener {
  MainFrame adaptee;

  MainFrame_jMenuFileExit_ActionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileExit_actionPerformed(e);
  }
}

class MainFrame_jMenuHelpAbout_ActionAdapter implements ActionListener {
  MainFrame adaptee;

  MainFrame_jMenuHelpAbout_ActionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuHelpAbout_actionPerformed(e);
  }
}

class MainFrame_butt_allocate_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_butt_allocate_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_allocate_actionPerformed(e);
  }
}

class MainFrame_butt_FEL_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_butt_FEL_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_FEL_actionPerformed(e);
  }
}

class MainFrame_butt_personal_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_butt_personal_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_personal_actionPerformed(e);
  }
}

class MainFrame_jMenuNutrient_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_jMenuNutrient_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuNutrient_actionPerformed(e);
  }
}

class MainFrame_jMenuServing_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_jMenuServing_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuServing_actionPerformed(e);
  }
}

class MainFrame_jMenuFEL_actionAdapter implements java.awt.event.ActionListener {
  MainFrame adaptee;

  MainFrame_jMenuFEL_actionAdapter(MainFrame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFEL_actionPerformed(e);
  }
}
