package com.gotdns.jimula.EatHealthy;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

/**
 * <em>FoodExchangeList</em> is an object which
 * show the food exchange list.
 * <p>EatHealthy </p>
 * <p>A simple personal nutrient need and food serving calculator </p>
 * <p>Copyright (c) 2003</p>
 * @author Jimmy Ding
 * @version 1.01, 05/01/03
 */
public class FoodExchangeList extends JFrame {

  JScrollPane sp = new JScrollPane();
  JTextArea txtArea_food_list = new JTextArea();
  JComboBox cb_food_list = new JComboBox(getFileList());
  JLabel lbl_source = new JLabel();
  String food;
  JButton butt_close = new JButton();

  /**
   * Construsts a new FoodExchangeList instance.
   */
  public FoodExchangeList() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

//Component initialization
  private void jbInit() throws Exception  {
    this.setSize(new Dimension(600, 400));
    this.setTitle("Food Exchange List");
    this.getContentPane().setLayout(null);

    sp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    sp.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    sp.setBounds(new Rectangle(48, 55, 470, 213));
    cb_food_list.setBounds(new Rectangle(50, 18, 132, 20));
    cb_food_list.setSelectedIndex(0);
    this.food=String.valueOf(cb_food_list.getSelectedItem());
    cb_food_list.addActionListener(new FoodExchangeList_cb_food_list_actionAdapter(this));
    lbl_source.setFont(new java.awt.Font("Dialog", 1, 11));
    lbl_source.setText("Source: Based on American Dietetic Association Exchange List");
    lbl_source.setBounds(new Rectangle(52, 270, 377, 25));
    butt_close.setBounds(new Rectangle(201, 305, 73, 27));
    butt_close.setText("Close");
    butt_close.addActionListener(new FoodExchangeList_butt_close_actionAdapter(this));
    this.getContentPane().add(sp, null);
    this.getContentPane().add(cb_food_list, null);
    this.getContentPane().add(lbl_source, null);
    this.getContentPane().add(butt_close, null);
    sp.getViewport().add(txtArea_food_list, null);

    readFile();//read food exchange list file
  }

 //return a list to JComboBox "cb_food_list"
  private String[] getFileList(){
   File file=new File("./files/FEL/");
   String list[] =file.list();
   return list;
 }

//read food exchange list file
  private void readFile(){
   try{
     BufferedReader br=
      new BufferedReader(new FileReader("files/FEL/"+this.food));
     String line;
     while((line=br.readLine())!=null){
       txtArea_food_list.append(line+"\n");
     }
     br.close();
   }catch(Exception e){
         System.out.println(e);
   }
 }

 /**
  * select the food exchange list file
  */
 void cb_food_list_actionPerformed(ActionEvent e) {
    this.food=String.valueOf(cb_food_list.getSelectedItem());
    txtArea_food_list.setText("");
    readFile();
  }

  /**
   * close frame
   */
  void butt_close_actionPerformed(ActionEvent e) {
    dispose();
  }

}

class FoodExchangeList_cb_food_list_actionAdapter implements java.awt.event.ActionListener {
  FoodExchangeList adaptee;

  FoodExchangeList_cb_food_list_actionAdapter(FoodExchangeList adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.cb_food_list_actionPerformed(e);
  }
}

class FoodExchangeList_butt_close_actionAdapter implements java.awt.event.ActionListener {
  FoodExchangeList adaptee;

  FoodExchangeList_butt_close_actionAdapter(FoodExchangeList adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.butt_close_actionPerformed(e);
  }
}