package com.gotdns.jimula.EatHealthy;

import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;

  /**
   * <em>InputNutrient</em> is evoked when user push button
   * of food serving on tools bar. User can directly input nutrient need to calculate food serving.
   * <p>EatHealthy </p>
   * <p>A simple personal nutrient need and food serving calculator </p>
   * <p>Copyright (c) 2003</p>
   * @author Jimmy Ding
   * @version 1.01, 05/01/03
   */
public class InputNutrient {

//Construts a SpinnerNumberModel
  Float value = new Float(0);
  Float min = new Float(0);
  Float max = new Float(10000);
  Float step = new Float(0.1);
  SpinnerNumberModel model1 = new SpinnerNumberModel(value, min, max, step);
  SpinnerNumberModel model2 = new SpinnerNumberModel(value, min, max, step);
  SpinnerNumberModel model3 = new SpinnerNumberModel(value, min, max, step);
  SpinnerNumberModel model4 = new SpinnerNumberModel(value, min, max, step);

  JPanel panel_nutrient = new JPanel();
  JLabel lbl_calories = new JLabel();
  JSpinner spin_calories = new JSpinner(model1);
  JLabel lbl_carb = new JLabel();
  JSpinner spin_protein = new JSpinner(model2);
  JLabel lbl_protein = new JLabel();
  JLabel lbl_fat = new JLabel();
  JSpinner spin_carb = new JSpinner(model3);
  JSpinner spin_fat = new JSpinner(model4);
  GridLayout gridLayout1 = new GridLayout();
  ServingPanel ap;

  /**
   * Construsts a new InputNutrient instance.
   * @param ap ServingPanel
   * @see com.gotdns.jimula.EatHealthy.ServingPanel
   */
  public InputNutrient(ServingPanel ap) {
   this.ap=ap;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception {
    lbl_calories.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_calories.setText("calories (Kcal)");
    lbl_carb.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_carb.setText("carbohydrate (g)");
    lbl_protein.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_protein.setText("protein (g)");
    lbl_fat.setHorizontalAlignment(SwingConstants.RIGHT);
    lbl_fat.setText("fat (g)");
    panel_nutrient.setLayout(gridLayout1);
    gridLayout1.setColumns(1);
    gridLayout1.setHgap(5);
    gridLayout1.setRows(5);
    gridLayout1.setVgap(10);
    panel_nutrient.setBorder(BorderFactory.createLineBorder(Color.black));
    spin_calories.addChangeListener(new InputNutrient_spin_calories_changeAdapter(this));
    spin_protein.addChangeListener(new InputNutrient_spin_protein_changeAdapter(this));
    spin_fat.addChangeListener(new InputNutrient_spin_fat_changeAdapter(this));
    spin_carb.addChangeListener(new InputNutrient_spin_carb_changeAdapter(this));
    panel_nutrient.add(lbl_calories, null);
    panel_nutrient.add(spin_calories, null);
    panel_nutrient.add(lbl_protein, null);
    panel_nutrient.add(spin_protein, null);
    panel_nutrient.add(lbl_fat, null);
    panel_nutrient.add(spin_fat, null);
    panel_nutrient.add(lbl_carb, null);
    panel_nutrient.add(spin_carb, null);
  }

  /**
   * get a InputNutrient panel
   * @return a JPanel with InputNutrient panel
   */
  public JPanel getPanel(){
    return panel_nutrient;
  }

  void spin_calories_stateChanged(ChangeEvent e) {
    this.ap.actual_calories=Float.parseFloat(String.valueOf(spin_calories.getValue()));
    this.ap.show_serving();
  }

  void spin_protein_stateChanged(ChangeEvent e) {
    this.ap.actual_protein=Float.parseFloat(String.valueOf(spin_protein.getValue()));
    this.ap.show_serving();
  }

  void spin_fat_stateChanged(ChangeEvent e) {
    this.ap.actual_fat=Float.parseFloat(String.valueOf(spin_fat.getValue()));
    this.ap.show_serving();
  }

  void spin_carb_stateChanged(ChangeEvent e) {
    this.ap.actual_carb=Float.parseFloat(String.valueOf(spin_carb.getValue()));
    this.ap.show_serving();
  }


}

class InputNutrient_spin_calories_changeAdapter implements javax.swing.event.ChangeListener {
  InputNutrient adaptee;

  InputNutrient_spin_calories_changeAdapter(InputNutrient adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.spin_calories_stateChanged(e);
  }
}

class InputNutrient_spin_protein_changeAdapter implements javax.swing.event.ChangeListener {
  InputNutrient adaptee;

  InputNutrient_spin_protein_changeAdapter(InputNutrient adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.spin_protein_stateChanged(e);
  }
}

class InputNutrient_spin_fat_changeAdapter implements javax.swing.event.ChangeListener {
  InputNutrient adaptee;

  InputNutrient_spin_fat_changeAdapter(InputNutrient adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.spin_fat_stateChanged(e);
  }
}

class InputNutrient_spin_carb_changeAdapter implements javax.swing.event.ChangeListener {
  InputNutrient adaptee;

  InputNutrient_spin_carb_changeAdapter(InputNutrient adaptee) {
    this.adaptee = adaptee;
  }
  public void stateChanged(ChangeEvent e) {
    adaptee.spin_carb_stateChanged(e);
  }
}