/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class ImageCanvas
extends Component {
    private Image image;

    public ImageCanvas() {
    }

    public ImageCanvas(Image image) {
        this.setImage(image);
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setImage(Image image) {
        ImageCanvas.waitForImage(this, image);
        this.image = image;
        this.setSize(image.getWidth(this), image.getHeight(this));
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public Dimension getMinimumSize() {
        if (this.image != null) {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

