/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsql.Cache;
import org.hsql.Channel;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Node;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.StringConverter;
import org.hsql.Table;
import org.hsql.Trace;

class Log
implements Runnable {
    private static final int COPY_BLOCK_SIZE = 65536;
    private FileInputStream fProperties;
    private Properties pProperties;
    private String sName;
    private Database dDatabase;
    private Channel cSystem;
    private Writer wScript;
    private String sFileProperties;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize = 200;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    private int mLastId;
    Cache cCache;

    Log(Database database, Channel channel, String string) throws SQLException {
        this.dDatabase = database;
        this.cSystem = channel;
        this.sName = string;
        this.sFileProperties = String.valueOf(this.sName) + ".properties";
        this.pProperties = new Properties();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }

    private void backup() throws SQLException {
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(String.valueOf(this.sFileBackup) + ".new"), new Deflater(1), 65536);
            byte[] byArray = new byte[65536];
            FileInputStream fileInputStream = new FileInputStream(this.sFileCache);
            while ((n = fileInputStream.read(byArray, 0, 65536)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            deflaterOutputStream.close();
            fileInputStream.close();
            l = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    void checkpoint() throws SQLException {
        this.close(false);
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache.open(false);
        this.openScript();
    }

    void close(boolean bl) throws SQLException {
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(bl);
        this.cCache.flush();
        this.backup();
        ((Hashtable)this.pProperties).put("modified", "yes-new-files");
        this.saveProperties();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        ((Hashtable)this.pProperties).put("modified", "no");
        this.saveProperties();
        this.closeProperties();
        if (bl) {
            this.stop();
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
            Database database = new Database(this.sName);
            database.getLog().close(false);
        }
    }

    private void closeProperties() throws SQLException {
        try {
            if (this.fProperties != null) {
                this.fProperties.close();
                this.fProperties = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(28, String.valueOf(this.sFileProperties) + " " + exception);
        }
    }

    private void closeScript() throws SQLException {
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception exception) {
            Trace.error(28, this.sFileScript);
        }
    }

    private void create() throws SQLException {
        ((Hashtable)this.pProperties).put("modified", "no");
        ((Hashtable)this.pProperties).put("version", "1.4");
        this.saveProperties();
    }

    private boolean isAlreadyOpen() throws SQLException {
        File file = new File(String.valueOf(this.sName) + ".lock");
        long l = file.lastModified();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {}
        long l2 = file.lastModified();
        if (l != l2) {
            return true;
        }
        this.closeProperties();
        if (!new File(this.sFileProperties).delete()) {
            return true;
        }
        this.saveProperties();
        return false;
    }

    private void loadProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            this.fProperties = new FileInputStream(file);
            this.pProperties.load(this.fProperties);
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    boolean open() throws SQLException {
        if (!new File(this.sFileProperties).exists()) {
            this.create();
            this.open();
            return true;
        }
        this.loadProperties();
        this.sFileScript = this.pProperties.getProperty("script", String.valueOf(this.sName) + ".script");
        this.sFileCache = this.pProperties.getProperty("data", String.valueOf(this.sName) + ".data");
        this.sFileBackup = this.pProperties.getProperty("backup", String.valueOf(this.sName) + ".backup");
        String string = this.pProperties.getProperty("version", "1.0");
        boolean bl = string.equals("1.4");
        Trace.check(bl, 29);
        if (this.pProperties.getProperty("readonly", "false").equals("true")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            this.cCache = new Cache(this.sFileCache);
            this.cCache.open(true);
            this.runScript();
            return false;
        }
        boolean bl2 = false;
        String string2 = this.pProperties.getProperty("modified", "no");
        if (string2.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (string2.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(0);
            }
            this.restoreBackup();
            bl2 = true;
        }
        ((Hashtable)this.pProperties).put("modified", "yes");
        this.saveProperties();
        this.cCache = new Cache(this.sFileCache);
        this.cCache.open(false);
        this.runScript();
        if (bl2) {
            this.close(false);
            ((Hashtable)this.pProperties).put("modified", "yes");
            this.saveProperties();
            this.cCache.open(false);
        }
        this.openScript();
        return false;
    }

    private void openScript() throws SQLException {
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception exception) {
            Trace.error(28, this.sFileScript);
        }
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return StringConverter.asciiToUnicode(string);
    }

    private void renameNewToCurrent(String string) {
        if (new File(String.valueOf(string) + ".new").exists()) {
            new File(string).delete();
            new File(String.valueOf(string) + ".new").renameTo(new File(string));
        }
    }

    private void restoreBackup() throws SQLException {
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int n;
            long l = System.currentTimeMillis();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFileCache);
            byte[] byArray = new byte[65536];
            while ((n = inflaterInputStream.read(byArray, 0, 65536)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inflaterInputStream.close();
            l = System.currentTimeMillis() - l;
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileBackup);
        }
    }

    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {}
        }
    }

    private void runScript() throws SQLException {
        if (!new File(this.sFileScript).exists()) {
            return;
        }
        this.bRestoring = true;
        this.dDatabase.setReferentialIntegrity(false);
        Vector<Channel> vector = new Vector<Channel>();
        vector.addElement(this.cSystem);
        Channel channel = this.cSystem;
        int n = 1;
        try {
            String string;
            long l = System.currentTimeMillis();
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.sFileScript));
            while ((string = Log.readLine(lineNumberReader)) != null) {
                int n2;
                if (string.startsWith("/*C")) {
                    n2 = Integer.parseInt(string.substring(3, string.indexOf(42, 4)));
                    if (n2 >= n) {
                        vector.setSize(n2 + 1);
                    }
                    if ((channel = (Channel)vector.elementAt(n2)) == null) {
                        channel = new Channel(this.cSystem, n2);
                        vector.setElementAt(channel, n2);
                        this.dDatabase.registerChannel(channel);
                    }
                    string = string.substring(string.indexOf(47, 1) + 1);
                }
                if (!string.equals("")) {
                    this.dDatabase.execute(string, channel);
                }
                if (!string.equals("DISCONNECT")) continue;
                n2 = channel.getId();
                channel = new Channel(this.cSystem, n2);
                vector.setElementAt(channel, n2);
            }
            lineNumberReader.close();
            int n3 = 0;
            while (n3 < n) {
                channel = (Channel)vector.elementAt(n3);
                if (channel != null) {
                    channel.rollback();
                }
                ++n3;
            }
            l = System.currentTimeMillis() - l;
        }
        catch (IOException iOException) {
            throw Trace.error(28, String.valueOf(this.sFileScript) + " " + iOException);
        }
        this.dDatabase.setReferentialIntegrity(true);
        this.bRestoring = false;
    }

    private void saveProperties() throws SQLException {
        File file = new File(this.sFileProperties);
        this.closeProperties();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.pProperties.store(fileOutputStream, "Hypersonic SQL database");
            fileOutputStream.close();
            this.loadProperties();
        }
        catch (Exception exception) {
            throw Trace.error(28, this.sFileProperties);
        }
    }

    static void scriptToFile(Database database, String string, boolean bl, Channel channel) throws SQLException {
        if (new File(string).exists()) {
            throw Trace.error(28, string);
        }
        try {
            long l = System.currentTimeMillis();
            Result result = bl ? database.getScript(false, false, false, channel) : database.getScript(false, false, true, channel);
            Record record = result.rRoot;
            FileWriter fileWriter = new FileWriter(string);
            while (record != null) {
                Log.writeLine(fileWriter, (String)record.data[0]);
                record = record.next;
            }
            Vector vector = database.getTables();
            int n = 0;
            while (n < vector.size()) {
                Table table = (Table)vector.elementAt(n);
                if (bl || !table.isCached()) {
                    Index index = table.getPrimaryIndex();
                    Node node = index.first();
                    while (node != null) {
                        Log.writeLine(fileWriter, table.getInsertStatement(node.getData()));
                        node = index.next(node);
                    }
                }
                ++n;
            }
            fileWriter.close();
            l = System.currentTimeMillis() - l;
        }
        catch (IOException iOException) {
            Trace.error(28, String.valueOf(string) + " " + iOException);
        }
    }

    void setLogSize(int n) {
        this.iLogSize = n;
    }

    void setWriteDelay(boolean bl) {
        this.bWriteDelay = bl;
    }

    void shutdown() throws SQLException {
        this.tRunner = null;
        this.cCache.shutdown();
        this.closeScript();
        this.closeProperties();
    }

    void stop() {
        this.tRunner = null;
    }

    void write(Channel channel, String string) throws SQLException {
        if (this.bRestoring || string == null || string.equals("")) {
            return;
        }
        int n = 0;
        if (channel != null) {
            n = channel.getId();
        }
        if (n != this.mLastId) {
            string = "/*C" + n + "*/" + string;
            this.mLastId = n;
        }
        try {
            Log.writeLine(this.wScript, string);
            if (this.bWriteDelay) {
                this.bNeedFlush = true;
            } else {
                this.wScript.flush();
            }
        }
        catch (IOException iOException) {
            Trace.error(28, this.sFileScript);
        }
        if (this.iLogSize > 0 && this.iLogCount++ > 100) {
            this.iLogCount = 0;
            if (new File(this.sFileScript).length() > (long)(this.iLogSize * 1024 * 1024)) {
                this.checkpoint();
            }
        }
    }

    private static void writeLine(Writer writer, String string) throws IOException {
        writer.write(String.valueOf(StringConverter.unicodeToAscii(string)) + "\r\n");
    }

    private void writeScript(boolean bl) throws SQLException {
        new File(String.valueOf(this.sFileScript) + ".new").delete();
        Log.scriptToFile(this.dDatabase, String.valueOf(this.sFileScript) + ".new", bl, this.cSystem);
    }
}

