#include <stdlib.h>
#include <stdio.h>

#include "rgbmap.h"

typedef unsigned char byte;

int rgbmap_alloc(rgbmap *map,int width,int height) {
  map->width=width,map->height=height;
  map->data=(byte *)malloc(3*map->width*map->height);
  return map->data==0;
}

void rgbmap_free(rgbmap *map) {
  if(map->data) free(map->data);
  map->width=map->height=0;
  map->data=0;
}

void rgbmap_swaprgb(rgbmap *map,int r,int g,int b) {
  byte rgb[3],*h;
  for(h=map->data+3*map->width*map->height;h>map->data;) {
    h-=3;
    rgb[0]=h[0],rgb[1]=h[1],rgb[2]=h[2];
    h[0]=rgb[r],h[1]=rgb[g],h[2]=rgb[b];
  }
}

int rgbmap_import_ppm(rgbmap *map,FILE *f) {
  char line[256];
  int w,h;

  fgets(line,sizeof(line),f);    /* here should be P5 ? */
  if(line[0]!='P'||line[1]!='6') return 1;     /* bad format */
  while((fgets(line,sizeof(line),f))&&line[0]=='#');
  sscanf(line,"%d%d",&w,&h);
  fgets(line,sizeof(line),f);	/* here should be 255 */
  rgbmap_alloc(map,w,h);
  return 1!=fread(map->data,3*w*h,1,f);
}

int rgbmap_import_tga(rgbmap *map,FILE *f) {
  char tgaheader[18];
  int w,h;
  int r;

  fread(tgaheader,sizeof(tgaheader),1,f);
  if(tgaheader[2]!=2) return 1;
  w=*(unsigned short*)(tgaheader+12);
  h=*(unsigned short*)(tgaheader+14);
  rgbmap_alloc(map,w,h);
  fseek(f,*(unsigned short*)(tgaheader),SEEK_CUR);
  r=fread(map->data,3*w*h,1,f);
  rgbmap_swaprgb(map,2,1,0);
  if(!(tgaheader[17]&0x20)) 
    rgbmap_mirror(map,0);
  return r!=1;
}

int rgbmap_import_bmp(rgbmap *map,FILE *f) {
  int i,j;
  int w,h,fbpl;
  unsigned char *line;
  char bmpheader[54];

  fread(bmpheader,sizeof(bmpheader),1,f);
  if(bmpheader[0]!='B'||bmpheader[1]!='M')
    return 0;
  if(*(short*)(bmpheader+26)!=1||*(short*)(bmpheader+28)!=24)
    return 0;
  w=*(int*)(bmpheader+18),h=*(int*)(bmpheader+22);
  fbpl=(3*w+3)&~3;
  rgbmap_alloc(map,w,h);
  line=malloc(fbpl);
  for(j=0;j<h;j++) {
    fread(line,1,fbpl,f);
    memcpy(map->data+3*w*(h-j-1),line,w*3);
  }
  free(line);
  rgbmap_swaprgb(map,2,1,0);
  return 1;
}

void rgbmap_dither(rgbmap *map,int pixel_size,unsigned char *pixels,int rbase,int rlevels,int gbase,int glevels,int bbase,int blevels) {
  int x,y;
  unsigned int c,c2;
  int *m;
  unsigned char *p,*q;
  struct {
    int e,e1,e2,*el,*ep;
  } r,g,b;

  if(!pixels)
    pixels=(byte*)malloc(map->width*map->height*pixel_size);

  rlevels--,glevels--,blevels--;
  m=(int*)calloc(3*(map->width+2),sizeof(int));
  r.el=m;g.el=r.el+map->width+2;b.el=g.el+map->width+2;
  r.e1=r.e2=g.e1=g.e2=b.e1=b.e2=0;

  for(p=map->data,q=pixels,y=map->height;y;y--) {
    r.ep=r.el+1,r.e2=r.ep[0],r.e1=r.ep[1],r.ep[-1]=0,r.ep[0]=0;
    g.ep=g.el+1,g.e2=g.ep[0],g.e1=g.ep[1],g.ep[-1]=0,g.ep[0]=0;
    b.ep=b.el+1,b.e2=b.ep[0],b.e1=b.ep[1],b.ep[-1]=0,b.ep[0]=0;
    for(x=map->width;x;x--,r.ep++,g.ep++,b.ep++) {

      c2=((*p+r.e2)*rlevels+127)/255;
      c=rbase*c2;
      r.e=(*p+r.e2)-c2*255/rlevels;
      r.ep[-1]+=r.e/9,r.ep[0]+=r.e*3/9,r.ep[+1]=r.e/9,r.e2=r.e1+r.e*3/9;
      r.e1=r.ep[2];p++;

      c2=((*p+g.e2)*glevels+127)/255;
      c+=gbase*c2;
      g.e=(*p+g.e2)-c2*255/glevels;
      g.ep[-1]+=g.e/9,g.ep[0]+=g.e*3/9,g.ep[+1]=g.e/9,g.e2=g.e1+g.e*3/9;
      g.e1=g.ep[2];p++;

      c2=((*p+b.e2)*blevels+127)/255;
      c+=bbase*c2;
      b.e=(*p+b.e2)-c2*255/blevels;
      b.ep[-1]+=b.e/9,b.ep[0]+=b.e*3/9,b.ep[+1]=b.e/9,b.e2=b.e1+b.e*3/9;
      b.e1=b.ep[2];p++;

      switch(pixel_size) {
       case 4:q[3]=c>>24;
       case 3:q[2]=c>>16;
       case 2:q[1]=c>>8;
       case 1:q[0]=c;break;
      }

      q+=pixel_size;
    }
  }
  free(m);
}

void rgbmap_grayscale(rgbmap *map) {
  unsigned char *p,*pe,c;
  for(p=map->data,pe=p+3*map->width*map->height;p<pe;) {
    c=(19595*p[0]+38470*p[1]+7471*p[2])>>16;
    *p++=c,*p++=c,*p++=c;
  }
}

void rgbmap_rgb(rgbmap *map,int r,int g,int b) {
  byte q[3],*p,*pe;  
  if(r==0&&g==1&&b==2)
    return;
  for(p=map->data,pe=p+3*map->width*map->height;p<pe;) {
    q[0]=p[0];q[1]=p[1];q[2]=p[2];
    *p++=q[r],*p++=q[g],*p++=q[b];
  }
}

typedef struct {char c[3];} s3;

void rgbmap_rotate(rgbmap *map,int dir) {
  register int i,j;
  register s3 *x,*y;
  register int w=map->width,h=map->height;
  y=(s3*)malloc(3*w*h);
  x=(s3*)map->data;
  memcpy(y,x,3*w*h);
  if(dir>0) 
    for(j=0;j<h;j++)
      for(i=0;i<w;i++)
        x[h*(w-i-1)+j]=y[w*j+i];
  else
    for(j=0;j<h;j++)
      for(i=0;i<w;i++)
        x[h*i+(h-j-1)]=y[w*j+i];
  free((void*)y);
  map->width=h,map->height=w;
}

void rgbmap_mirror(rgbmap *map,int y) {
  register int i,j;
  register s3 c,*x;
  register int w=map->width,h=map->height;
  x=(s3*)map->data;
//  return ;
  if(y)
    for(j=0;j<h;j++)
      for(i=0;i<w/2;i++)
        c=x[w*j+i],x[w*j+i]=x[w*j+w-i-1],x[w*j+w-i-1]=c;
  else
    for(j=0;j<h/2;j++)
      for(i=0;i<w;i++)
        c=x[w*j+i],x[w*j+i]=x[w*(h-j-1)+i],x[w*(h-j-1)+i]=c;
}
