#!/usr/bin/perl
use Dislin;

@x  = (1., 2., 3., 4., 5., 6., 7., 8., 9.);
@y  = (0., 0., 0., 0., 0., 0., 0., 0., 0.);
@y1 = (1., 1.5, 2.5, 1.3, 2.0, 1.2, 0.7, 1.4, 1.1);
@y2 = (2., 2.7, 3.5, 2.1, 3.2, 1.9, 2.0, 2.3, 1.8);
@y3 = (4., 3.5, 4.5, 3.7, 4., 2.9, 3.0, 3.2, 2.6);

$nya = 2700;
$ctit = 'Bar Graphs (BARS)';

Dislin::setpag ('da4p');
Dislin::metafl ('cons');
Dislin::disini ();
Dislin::pagera ();
Dislin::complx ();
Dislin::ticks  (1, 'x');
Dislin::intax  ();
Dislin::axslen (1600, 700);
Dislin::titlin ($ctit, 3);

Dislin::legini ($cbuf, 3, 8);
Dislin::leglin ($cbuf, 'FIRST', 1);
Dislin::leglin ($cbuf, 'SECOND', 2);
Dislin::leglin ($cbuf, 'THIRD', 3);
Dislin::legtit (' ');
Dislin::shdpat (5);

for ($i = 1; $i <= 3; $i++) {
  if ($i > 1) {
    Dislin::labels ('none','x');
  }
  Dislin::axspos (300, $nya-($i-1)*800);
  Dislin::graf (0., 10., 0., 1., 0., 5., 0., 1.);

  if ($i == 1) {
    Dislin::bargrp (3, 0.15);
    Dislin::color  ('red');
    Dislin::bars   (\@x, \@y, \@y1, 9);
    Dislin::color  ('green');
    Dislin::bars   (\@x, \@y, \@y2, 9);
    Dislin::color  ('blue');
    Dislin::bars   (\@x, \@y, \@y3, 9);
    Dislin::color  ('fore');
    Dislin::reset  ('bargrp');
  }
  elsif ($i == 2)
  { Dislin::height (30);
    Dislin::labels ('delta','bars');
    Dislin::labpos ('center','bars');
    Dislin::color  ('red');
    Dislin::bars   (\@x, \@y, \@y1, 9);
    Dislin::color  ('green');
    Dislin::bars   (\@x, \@y1, \@y2, 9);
    Dislin::color  ('blue');
    Dislin::bars   (\@x, \@y2, \@y3, 9);
    Dislin::color  ('fore');
    Dislin::reset  ('height'); 
  }
  elsif ($i == 3)
  { Dislin::labels ('second', 'bars');
    Dislin::labpos ('outside', 'bars');
    Dislin::color  ('red');
    Dislin::bars   (\@x, \@y, \@y1, 9);
    Dislin::color  ('fore');
  }

  if ($i != 3) {
    Dislin::legend ($cbuf,7);
  }

  if ($i == 3)
  { Dislin::height (50);
    Dislin::title  ();
  }

  Dislin::endgrf ();
}

Dislin::disfin ();
