/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.testing;

import com.mockobjects.AbstractExpectation;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.Assert;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.testing.ExpectationValue;
import org.nakedobjects.testing.View;

public class ExpectationObject
extends AbstractExpectation {
    private Class type;
    private Hashtable expectedReferences = new Hashtable();
    private Hashtable expectedValues = new Hashtable();
    private View actual;

    public ExpectationObject(Class clazz) {
        super(clazz.getName());
        this.type = clazz;
    }

    public void addActual(View view) {
        NakedObject nakedObject = (NakedObject)view.getForObject();
        if (!nakedObject.getClass().isAssignableFrom(this.type)) {
            Assert.fail((String)("Expected an object of type " + this.type.getName() + " but got a " + nakedObject.getClass().getName()));
        }
        this.actual = view;
    }

    public void addExpectedReference(String string, NakedObject nakedObject) {
        this.checkFieldUse(string);
        this.expectedReferences.put(string, new ExpectationValue(nakedObject));
        this.setHasExpectations();
    }

    public void addExpectedReference(String string, View view) {
        this.checkFieldUse(string);
        this.expectedReferences.put(string, new ExpectationValue((NakedObject)view.getForObject()));
        this.setHasExpectations();
    }

    public void addExpectedText(String string, String string2) {
        this.checkFieldUse(string);
        this.expectedValues.put(string, string2);
        this.setHasExpectations();
    }

    private void checkFieldUse(String string) {
        if (this.expectedValues.containsKey(string) || this.expectedReferences.containsKey(string)) {
            throw new RuntimeException("Duplicate field: " + string);
        }
    }

    public void clearActual() {
        this.actual = null;
    }

    protected void clearExpectation() {
        this.expectedValues.clear();
        this.expectedReferences.clear();
    }

    public void setExpectNothing() {
        this.clearExpectation();
        this.setHasExpectations();
    }

    public void verify() {
        Object object;
        String string;
        Enumeration enumeration = this.expectedValues.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.actual.getField(string).getTitle();
            this.assertEquals("Wrong value for " + string, this.expectedValues.get(string).toString(), object);
        }
        enumeration = this.expectedReferences.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (NakedObject)this.actual.getField(string).getForObject();
            NakedObject nakedObject = ((ExpectationValue)this.expectedReferences.get(string)).getReference();
            this.assertEquals("Wrong reference for " + string, nakedObject, object);
        }
    }
}

